/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.map.impl.query.PartitionScanExecutor;
import com.hazelcast.map.impl.query.PartitionScanRunner;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import java.util.ArrayList;
import java.util.Collection;

public class CallerRunsPartitionScanExecutor
implements PartitionScanExecutor {
    private final PartitionScanRunner partitionScanRunner;

    public CallerRunsPartitionScanExecutor(PartitionScanRunner partitionScanRunner) {
        this.partitionScanRunner = partitionScanRunner;
    }

    @Override
    public Collection<QueryableEntry> execute(String mapName, Predicate predicate, Collection<Integer> partitions) {
        RetryableHazelcastException storedException = null;
        ArrayList<QueryableEntry> result = new ArrayList<QueryableEntry>();
        for (Integer partitionId : partitions) {
            try {
                result.addAll(this.partitionScanRunner.run(mapName, predicate, partitionId));
            }
            catch (RetryableHazelcastException e) {
                if (storedException != null) continue;
                storedException = e;
            }
        }
        if (storedException != null) {
            throw storedException;
        }
        return result;
    }
}

