/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.common;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ModelItem
implements Serializable {
    private Map<String, Object> values = new HashMap<String, Object>();
    private String elementName = null;
    protected Set<String> keys = new HashSet<String>();

    protected ModelItem() {
    }

    public ModelItem(String elementName) {
        this.elementName = elementName;
    }

    public String getValue(String key) {
        String res = (String)this.values.get(key);
        if (res == null) {
            return "";
        }
        return res;
    }

    public int getIntValue(String key) {
        String val = this.getValue(key);
        if (val.equals("")) {
            return 0;
        }
        return Integer.parseInt(val);
    }

    public Date getDateValue(String key) {
        return TimeUtils.convertStringToDate(this.getValue(key));
    }

    public void setValue(String key, Date value) {
        this.setValue(key, TimeUtils.format(value, "dd.MM.yyyy"));
    }

    public boolean getBooleanValue(String key) {
        String val = this.getValue(key);
        if (val == null) {
            return false;
        }
        return new Boolean(val);
    }

    public Document getXMLValue(String key) {
        return (Document)this.values.get(key);
    }

    public void setValue(String key, String value) {
        if (Utils.isBlankString(value)) {
            this.values.remove(key);
        } else {
            this.values.put(key, value);
        }
    }

    public void setValue(String key, int value) {
        this.setValue(key, String.valueOf(value));
    }

    public void setValue(String key, boolean value) {
        this.setValue(key, String.valueOf(value));
    }

    public void setValue(String key, Document value) {
        this.values.put(key, value);
    }

    public BigDecimal getDecimalValue(String key) {
        return new BigDecimal(this.getValue(key));
    }

    public void setValue(String key, BigDecimal value) {
        this.setValue(key, value.toString());
    }

    public Element saveToXML(Element rootNode) {
        Element res = rootNode.getOwnerDocument().createElement(this.elementName);
        rootNode.appendChild(res);
        this.saveToXMLImpl(res);
        return res;
    }

    private void saveToXMLImpl(Element res) {
        for (String key : this.values.keySet()) {
            String value = (String)this.values.get(key);
            if (value == null) continue;
            res.setAttribute(key, value);
        }
    }

    public void loadFromXML(Element element) {
        NamedNodeMap list = element.getAttributes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            String name = node.getNodeName();
            String value = node.getNodeValue();
            this.values.put(name, value);
        }
    }

    public boolean hasValue(String key) {
        return this.values.containsKey(key) && this.values.get(key) != null;
    }

    public void removeValue(String key) {
        this.values.remove(key);
    }

    public String getElementName() {
        return this.elementName;
    }

    public Set<String> getAllowKeys() {
        return this.values.keySet();
    }

    public Set<String> getAllKey() {
        return this.keys;
    }
}

