/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.common.protocol.barcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Writer;
import com.google.zxing.oned.EAN13Writer;
import com.google.zxing.oned.EAN8Writer;
import com.google.zxing.oned.ITFWriter;
import com.google.zxing.pdf417.PDF417Writer;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;

public class BarcodeUrlConnectionZxing
extends URLConnection {
    private InputStream inputStream;

    public BarcodeUrlConnectionZxing(URL url) {
        super(url);
    }

    @Override
    public void connect() throws IOException {
        BitMatrix matrix;
        block29: {
            String path = this.url.getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            String code = path;
            int width = -1;
            int height = -1;
            matrix = null;
            try {
                HashMap<EncodeHintType, Object> hints;
                int pos = code.indexOf(47);
                if ((pos == -1 || pos > 6) && (pos = code.indexOf(124)) != -1) {
                    System.err.println("ERROR: error deliminter \"|\" in uri " + this.url);
                }
                if (pos == -1) {
                    throw new IOException("barcode: no barcode type in path \"" + path + "\"");
                }
                String codeType = code.substring(0, pos);
                if ((pos = (code = code.substring(pos + 1)).indexOf(47)) == -1 || pos > 7) {
                    pos = code.indexOf(124);
                }
                if (pos != -1) {
                    try {
                        String _sizes = code.substring(0, pos);
                        String[] _wh = _sizes.split("x");
                        width = Integer.valueOf(_wh[0]);
                        height = Integer.valueOf(_wh[1]);
                        code = code.substring(pos + 1);
                    }
                    catch (ArrayIndexOutOfBoundsException | NumberFormatException _sizes) {
                        // empty catch block
                    }
                }
                code = code.replace("<SOH>", "\u0001");
                if (codeType.equalsIgnoreCase("128a") || codeType.equalsIgnoreCase("128")) {
                    if (width == -1) {
                        width = 150;
                    }
                    if (height == -1) {
                        height = 50;
                    }
                    hints = new HashMap<EncodeHintType, Object>();
                    hints.put(EncodeHintType.MARGIN, 5);
                    matrix = new Code128Writer().encode(code, BarcodeFormat.CODE_128, width, height, hints);
                    break block29;
                }
                if (codeType.equalsIgnoreCase("EAN-13") || codeType.equalsIgnoreCase("EAN13")) {
                    code = code + String.valueOf(BarcodeUrlConnectionZxing.calcChecksumEAN13(code));
                    if (width == -1) {
                        width = 150;
                    }
                    if (height == -1) {
                        height = 50;
                    }
                    hints = new HashMap();
                    hints.put(EncodeHintType.MARGIN, 2);
                    matrix = new EAN13Writer().encode(code, BarcodeFormat.EAN_13, width, height, hints);
                    break block29;
                }
                if (codeType.equalsIgnoreCase("EAN-8") || codeType.equalsIgnoreCase("EAN8")) {
                    code = code + String.valueOf(BarcodeUrlConnectionZxing.calcChecksumEAN8(code));
                    if (width == -1) {
                        width = 100;
                    }
                    if (height == -1) {
                        height = 50;
                    }
                    hints = new HashMap();
                    hints.put(EncodeHintType.MARGIN, 2);
                    matrix = new EAN8Writer().encode(code, BarcodeFormat.EAN_8, width, height, hints);
                    break block29;
                }
                if (codeType.equalsIgnoreCase("PDF417")) {
                    if (width == -1) {
                        width = 150;
                    }
                    if (height == -1) {
                        height = 50;
                    }
                    hints = new HashMap();
                    hints.put(EncodeHintType.MARGIN, 2);
                    hints.put(EncodeHintType.PDF417_COMPACT, false);
                    hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
                    matrix = new PDF417Writer().encode(code, BarcodeFormat.PDF_417, width, height, hints);
                    break block29;
                }
                if (codeType.equalsIgnoreCase("QR") || codeType.equalsIgnoreCase("QRcode") || codeType.equalsIgnoreCase("QR-code")) {
                    if (width == -1) {
                        width = 150;
                    }
                    if (height == -1) {
                        height = 150;
                    }
                    hints = new HashMap();
                    hints.put(EncodeHintType.MARGIN, 2);
                    hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
                    hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
                    matrix = new QRCodeWriter().encode(code, BarcodeFormat.QR_CODE, width, height, hints);
                    break block29;
                }
                if (codeType.equalsIgnoreCase("2of5i") || codeType.equalsIgnoreCase("2of5") || codeType.equalsIgnoreCase("ITF")) {
                    if (width == -1) {
                        width = 150;
                    }
                    if (height == -1) {
                        height = 50;
                    }
                    hints = new HashMap();
                    hints.put(EncodeHintType.MARGIN, 2);
                    matrix = new ITFWriter().encode(code, BarcodeFormat.ITF, width, height, hints);
                    break block29;
                }
                throw new IOException("barcode: unknown type \"" + codeType + "\" in path \"" + path + "\"");
            }
            catch (Exception e) {
                e.printStackTrace();
                matrix = this.generateErrorMatrix();
            }
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(2000);
            MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)"gif", (OutputStream)bos);
            this.inputStream = new ByteArrayInputStream(bos.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private BitMatrix generateErrorMatrix() {
        int WIDTH = 50;
        BitMatrix output = new BitMatrix(WIDTH, WIDTH);
        output.setRegion(0, 0, WIDTH, 1);
        output.setRegion(0, WIDTH - 1, WIDTH, 1);
        output.setRegion(0, 0, 1, WIDTH);
        output.setRegion(WIDTH - 1, 0, 1, WIDTH);
        for (int i = 0; i < WIDTH; ++i) {
            output.set(i, i);
            output.set(i, WIDTH - 1 - i);
        }
        return output;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    @Override
    public String getContentType() {
        return "image/gif";
    }

    private static int calcChecksumEAN13(String first12digits) {
        char[] data = first12digits.toCharArray();
        if (data.length != 12) {
            throw new IllegalArgumentException("FIXME");
        }
        return BarcodeUrlConnectionZxing.calcChecksumUPC(data);
    }

    private static int calcChecksumEAN8(String first7digits) {
        char[] data = first7digits.toCharArray();
        if (data.length != 7) {
            throw new IllegalArgumentException("FIXME");
        }
        return BarcodeUrlConnectionZxing.calcChecksumUPC(data);
    }

    private static int calcChecksumUPC(char[] data) {
        for (int i = 0; i < data.length; ++i) {
            if (data[i] >= '0' && data[i] <= '9') continue;
            throw new IllegalArgumentException("FIXME");
        }
        int sum = 0;
        for (int i = data.length - 1; i >= 0; --i) {
            int digit = data[i] - 48;
            sum += (data.length - i) % 2 == 1 ? digit * 3 : digit;
        }
        int mod = sum % 10;
        return mod == 0 ? 0 : 10 - mod;
    }
}

