/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.action;

import bitel.billing.server.admin.action.ActionDirectoryBase;
import bitel.billing.server.admin.bean.AddressManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;

public class ActionDeleteAddressDirectory
extends ActionDirectoryBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int id = this.getIntParameter("id", -1);
        String flag = this.getParameter("flag");
        if (id < 0) {
            throw new BGIllegalArgumentException();
        }
        int mode = this.getIntParameter("mode", -1);
        String table = this.getTable(mode);
        if (table == null) {
            return;
        }
        boolean fl = false;
        StringBuilder query = new StringBuilder();
        if (mode == 6 || mode == 8 || mode == 7) {
            query.append("SELECT count(*) FROM address_house WHERE ");
            if (mode == 6) {
                query.append("areaid");
            } else if (mode == 8) {
                query.append("quarterid");
            } else if (mode == 7) {
                query.append("streetid");
            }
            query.append("=");
            query.append(id);
            fl = this.check(query.toString());
        } else if (mode == 5) {
            fl = !fl & this.cityCheck(id, "area");
            fl = !fl & this.cityCheck(id, "quarter");
            fl = !fl & this.cityCheck(id, "street");
        }
        if (fl) {
            if (flag != null && flag.equals("new")) {
                AddressManager addressManager = new AddressManager(this.con, this.setup);
                addressManager.deleteAddressParams(table, id);
            }
            query = new StringBuilder();
            query.append("DELETE FROM ");
            query.append(table);
            query.append(" WHERE id=?");
            this.delete(query.toString(), id);
            if (mode == 5) {
                this.delete("DELETE FROM address_area WHERE cityid=?", id);
                this.delete("DELETE FROM address_street WHERE cityid=?", id);
                this.delete("DELETE FROM address_quarter WHERE cityid=?", id);
            }
        } else {
            throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0435\u0441\u0442\u044c \u0434\u043e\u043c\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0449\u0438\u0435 \u044d\u0442\u043e\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440. \u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0438\u0445.");
        }
    }

    private boolean cityCheck(int id, String name) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT count(*) FROM address_house AS h LEFT JOIN address_");
        query.append(name);
        query.append(" AS c ON c.id=h.");
        query.append(name);
        query.append("id WHERE c.cityid=");
        query.append(id);
        return this.check(query.toString());
    }

    private boolean check(String query) throws SQLException {
        boolean fl = false;
        Statement st = this.con.createStatement();
        ResultSet rs = st.executeQuery(query);
        while (rs.next()) {
            fl = rs.getInt(1) == 0;
        }
        rs.close();
        st.close();
        return fl;
    }

    private void delete(String query, int id) throws SQLException {
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ps.executeUpdate();
        ps.close();
    }
}

