/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.action;

import bitel.billing.server.admin.action.base.ActionBase;
import bitel.billing.server.admin.bean.AddressCity;
import bitel.billing.server.admin.bean.AddressCountry;
import bitel.billing.server.admin.bean.AddressHouse;
import bitel.billing.server.admin.bean.AddressItem;
import bitel.billing.server.admin.bean.AddressManager;
import java.sql.SQLException;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.SearchResult;

public class ActionSearchAddressDirectory
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        String mode = this.getParameter("mode", null);
        if (mode != null) {
            Element directory = this.createElement(this.rootNode, "directory");
            Element table = this.createElement(directory, "table");
            Element data = this.createElement(table, "data");
            AddressManager addressManager = new AddressManager(this.con, this.setup);
            if ("country".equals(mode = mode.toLowerCase().trim())) {
                SearchResult<AddressCountry> searchResult = new SearchResult<AddressCountry>();
                searchResult.setPage(this.getPage());
                addressManager.searchCountryList(searchResult, this.getMask("searchCountry"));
                for (AddressCountry addressCountry : searchResult.getList()) {
                    Element row = this.createElement(data, "row");
                    row.setAttribute("id", String.valueOf(addressCountry.getId()));
                    row.setAttribute("title", addressCountry.getTitle());
                }
                this.setPageAttribute(table, searchResult.getPage());
            } else if ("city".equals(mode)) {
                SearchResult<AddressCity> searchResult = new SearchResult<AddressCity>();
                searchResult.setPage(this.getPage());
                addressManager.searchCityList(searchResult, this.getIntParameter("countryId", -1), this.getMask("searchCity"), true);
                for (AddressCity addressCity : searchResult.getList()) {
                    Element row = this.createElement(data, "row");
                    row.setAttribute("id", String.valueOf(addressCity.getId()));
                    row.setAttribute("country_id", String.valueOf(addressCity.getCountryId()));
                    row.setAttribute("title", addressCity.getTitle());
                    row.setAttribute("country_title", "-");
                    AddressCountry addressCountry = addressCity.getAddressCountry();
                    if (addressCountry == null) continue;
                    row.setAttribute("country_title", addressCountry.getTitle());
                }
                this.setPageAttribute(table, searchResult.getPage());
            } else if ("street".equals(mode) || "quarter".equals(mode) || "area".equals(mode)) {
                SearchResult<AddressItem> searchResult = new SearchResult<AddressItem>();
                searchResult.setPage(this.getPage());
                if ("street".equals(mode)) {
                    addressManager.searchStreetList(searchResult, this.getIntParameter("cityId", -1), this.getMask("searchStreet"), true, true);
                } else if ("quarter".equals(mode)) {
                    addressManager.searchQuarterList(searchResult, this.getIntParameter("cityId", -1), this.getMask("searchQuarter"), true, true);
                } else if ("area".equals(mode)) {
                    addressManager.searchAreaList(searchResult, this.getIntParameter("cityId", -1), this.getMask("searchArea"), true, true);
                }
                for (AddressItem addressItem : searchResult.getList()) {
                    Element row = this.createElement(data, "row");
                    row.setAttribute("id", String.valueOf(addressItem.getId()));
                    row.setAttribute("city_id", String.valueOf(addressItem.getCityId()));
                    row.setAttribute("title", addressItem.getTitle());
                    row.setAttribute("city_title", "-");
                    row.setAttribute("country_title", "-");
                    AddressCity addressCity = addressItem.getAddressCity();
                    if (addressCity == null) continue;
                    row.setAttribute("city_title", addressCity.getTitle());
                    AddressCountry addressCountry = addressCity.getAddressCountry();
                    if (addressCountry == null) continue;
                    row.setAttribute("country_title", addressCountry.getTitle());
                    row.setAttribute("country_id", String.valueOf(addressCountry.getId()));
                }
                this.setPageAttribute(table, searchResult.getPage());
            } else if ("house".equals(mode)) {
                int areaId = this.getIntParameter("areaId", -1);
                int quarterId = this.getIntParameter("quarterId", -1);
                int streetId = this.getIntParameter("streetId", -1);
                SearchResult<AddressHouse> searchResult = new SearchResult<AddressHouse>();
                searchResult.setPage(this.getPage());
                addressManager.searchHouseList(searchResult, areaId, quarterId, streetId, this.getParameter("searchHouse"), true, true, true);
                for (AddressHouse addressHouse : searchResult.getList()) {
                    Element row = this.createElement(data, "row");
                    row.setAttribute("id", String.valueOf(addressHouse.getId()));
                    row.setAttribute("area_id", String.valueOf(addressHouse.getAreaId()));
                    row.setAttribute("quarter_id", String.valueOf(addressHouse.getQuarterId()));
                    row.setAttribute("street_id", String.valueOf(addressHouse.getStreetId()));
                    row.setAttribute("house", addressHouse.getHouseFrac());
                    row.setAttribute("dt", TimeUtils.format(addressHouse.getDate(), "dd.MM.yyyy"));
                    row.setAttribute("comment", addressHouse.getComment());
                    AddressItem addressItem = null;
                    int submode = this.getIntParameter("submode", 0);
                    addressItem = submode == 1 ? addressHouse.getAddressQuarter() : (submode == 2 ? addressHouse.getAddressArea() : addressHouse.getAddressStreet());
                    row.setAttribute("item_title", "-");
                    row.setAttribute("city_title", "-");
                    row.setAttribute("country_title", "-");
                    if (addressItem == null) continue;
                    row.setAttribute("item_title", addressItem.getTitle());
                    row.setAttribute("item_id", String.valueOf(addressItem.getId()));
                    AddressCity addressCity = addressItem.getAddressCity();
                    if (addressCity == null) continue;
                    row.setAttribute("city_title", addressCity.getTitle());
                    row.setAttribute("city_id", String.valueOf(addressCity.getId()));
                    AddressCountry addressCountry = addressCity.getAddressCountry();
                    if (addressCountry == null) continue;
                    row.setAttribute("country_title", addressCountry.getTitle());
                    row.setAttribute("country_id", String.valueOf(addressCountry.getId()));
                }
                this.setPageAttribute(table, searchResult.getPage());
            }
        } else {
            throw new BGMessageException("Parameter \"mode\" - not found!");
        }
    }

    private String getMask(String name) {
        StringBuilder mask = new StringBuilder();
        String searchText = this.getParameter(name);
        String searchMode = this.getParameter(name + "Mode");
        if (searchText != null && !searchText.isEmpty()) {
            if (searchMode == null || "subs".equals(searchMode) || "end".equals(searchMode)) {
                mask.append('%');
            }
            mask.append(searchText);
            if (searchMode == null || "subs".equals(searchMode) || "start".equals(searchMode)) {
                mask.append('%');
            }
        }
        return mask.toString();
    }
}

