/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.integration.action;

import bitel.billing.server.admin.integration.action.base.ActionBase;
import bitel.billing.server.admin.integration.bean.Register;
import bitel.billing.server.admin.integration.bean.RegisterItem;
import bitel.billing.server.admin.integration.bean.RegisterItemManager;
import bitel.billing.server.admin.integration.bean.RegisterManager;
import bitel.billing.server.contract.bean.BalanceUtils;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentDeletedEvent;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;

public class ActionRollBackRegister
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int id = this.getIntParameter("id", -1);
        if (id < 0) {
            throw new BGIllegalArgumentException();
        }
        RegisterManager regm = new RegisterManager(this.con);
        Register pr = regm.getRegisterById(id);
        if (pr == null) {
            return;
        }
        if (!pr.isProcessed()) {
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0442\u043a\u0430\u0442\u0438\u0442\u044c \u043d\u0435\u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0439 \u0440\u0435\u0435\u0441\u0442\u0440!");
        }
        AbstractIdDao manager = null;
        ArrayList<Integer> ids = new ArrayList<Integer>();
        manager = pr.getRegisterType() == 1 ? new ChargeDao(this.con) : new PaymentDao(this.con);
        RegisterItemManager itemm = new RegisterItemManager(this.con);
        BalanceUtils bu = new BalanceUtils(this.con);
        for (RegisterItem item : itemm.getRegisterItems(pr)) {
            if (pr.getRegisterType() == 1) {
                manager.delete(item.getBalanceItemId());
            } else {
                ids.add(item.getBalanceItemId());
            }
            item.setBalanceItemId(0);
            itemm.updateRegisterItem(pr, item);
            if (pr.getRegisterType() != 1) continue;
            this.con.commit();
            Date date = item.getDate();
            bu.updateBalance(date != null ? date : pr.getDate(), item.getContractId());
            EventProcessor.getInstance().publish(new ContractBalanceChangedEvent(item.getContractId(), 4, item.getSumma().negate()));
        }
        if (pr.getRegisterType() == 0) {
            String idList = Utils.toString(ids);
            List<Payment> payments = ((PaymentDao)manager).getPaymentsById(idList);
            ((PaymentDao)manager).deletePaymentsById(idList);
            ContractManager cm = new ContractManager(this.con);
            this.con.commit();
            for (Payment payment : payments) {
                Contract contract = cm.getContractById(payment.getContractId());
                bu.updateBalance(payment.getDate(), contract);
                this.con.commit();
                EventProcessor.getInstance().publish(new PaymentDeletedEvent(0, payment));
                EventProcessor.getInstance().publish(new ContractBalanceChangedEvent(contract.getId(), 3, payment.getSum().negate()));
            }
            cm.recycle();
        }
        bu.close();
        pr.setProcessed(false);
        regm.updateRegister(pr);
    }
}

