/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action.base;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractPasswordChangedEvent;

public abstract class ActionBase
extends bitel.billing.server.ActionBase {
    protected boolean updatePassword(String pswd1, String pswd2, boolean isPswdAuto) throws BGException {
        String error;
        boolean result = false;
        this.rootNode.setAttribute("status", "ok");
        if (!isPswdAuto && (error = ActionBase.checkPassword(this.setup, pswd1, pswd2)) != null) {
            throw new BGMessageException(error);
        }
        try {
            pswd1 = pswd1.trim();
            String query = "UPDATE contract SET pswd=? WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, pswd1);
            ps.setInt(2, this.cid);
            ps.executeUpdate();
            ps.close();
            result = true;
            this.context.publishAfterCommit(new ContractPasswordChangedEvent((int)this.userId, this.cid, pswd1));
        }
        catch (SQLException ex) {
            throw new BGMessageException(ex.getLocalizedMessage());
        }
        return result;
    }

    protected void treeServices(int moduleId, int onlyUsing) throws SQLException {
        Element tree = this.createElement(this.rootNode, "tree");
        HashMap<Integer, Element> moduleElementMap = new HashMap<Integer, Element>();
        String query = "SELECT `service`.`id`, `service`.`title`, `service`.`mid`, `module`.`title` FROM `service` LEFT JOIN `module` on `module`.`id`=`service`.`mid`";
        if (moduleId > 0) {
            query = query + " WHERE `service`.`mid`=" + moduleId;
            if (onlyUsing > 0) {
                query = query + " AND `service`.`isusing`=1 ";
            }
        } else if (onlyUsing > 0) {
            query = query + " WHERE `service`.`isusing`=1 ";
        }
        query = query + " ORDER BY `module`.`title`, `service`.`title`";
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Element moduleElement;
            int id = rs.getInt(1);
            String titleService = rs.getString(2);
            int mid = rs.getInt(3);
            String titleModule = rs.getString(4);
            if (titleModule == null) {
                titleModule = "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u043c\u043e\u0434\u0443\u043b\u044c (mid=" + mid + ")";
            }
            if ((moduleElement = (Element)moduleElementMap.get(mid)) == null) {
                moduleElement = this.createElement(tree, "module");
                moduleElement.setAttribute("id", String.valueOf(mid));
                moduleElement.setAttribute("title", titleModule);
                moduleElementMap.put(mid, moduleElement);
            }
            Element serviceElement = this.createElement(moduleElement, "service");
            serviceElement.setAttribute("id", String.valueOf(id));
            serviceElement.setAttribute("title", titleService);
            serviceElement.setAttribute("mid", String.valueOf(mid));
        }
        rs.close();
        ps.close();
    }
}

