/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import bitel.billing.server.contract.bean.BalanceUtils;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractPattern;
import bitel.billing.server.contract.bean.ContractPatternManager;
import bitel.billing.server.contract.bean.ContractScriptManager;
import bitel.billing.server.contract.bean.ContractStatus;
import bitel.billing.server.contract.bean.ContractStatusManager;
import bitel.billing.server.contract.bean.ContractUtils;
import bitel.billing.server.contract.object.bean.ContractObject;
import bitel.billing.server.contract.object.bean.ObjectManager;
import bitel.billing.server.tariff.TariffTreeBuilder;
import bitel.billing.server.tariff.TariffTreeSet;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebMenuDao;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffGroup;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractTariffGroupDao;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCloseEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.script.common.bean.ContractScript;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.worker.Recyclable;

public class ContractManager
implements Recyclable,
AutoCloseable {
    private static final Logger logger = Logger.getLogger(ContractManager.class);
    private Connection con;
    public static final String TABLE_CONTRACT = "contract";
    public static final String MESSAGE_ABOUT_DUPLICATE = "\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u043c\u0435\u043d\u0435\u043c \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!";
    private ContractStatusManager contractStatusManager;
    private PreparedStatement getByIdPS = null;
    private PreparedStatement getRealtimeTariffTreeSetPS = null;

    public ContractManager(Connection con) {
        this.con = con;
    }

    private ContractStatusManager getContractStatusManager() {
        if (this.contractStatusManager == null) {
            this.contractStatusManager = new ContractStatusManager(this.con);
        }
        return this.contractStatusManager;
    }

    public Contract createFromPattern(int pattern_id, String title, Calendar date, String pswd) throws Exception {
        return this.createFromPattern(pattern_id, title, date, pswd, Collections.emptyMap(), true, 0, 0);
    }

    public Contract createFromPattern(int pattern_id, String title, Calendar date, String pswd, Map<String, Object> titleParams, boolean inModules, int superId, int subMode) throws Exception {
        return this.createFromPattern(pattern_id, title, date, pswd, titleParams, inModules, superId, subMode, null);
    }

    public Contract createFromPattern(int pattern_id, String title, Calendar date, String pswd, Map<String, Object> titleParams, boolean inModules, int superId, int subMode, String customTitle) throws Exception {
        return this.createFromPattern(pattern_id, title, date, pswd, titleParams, inModules, superId, subMode, customTitle, 0);
    }

    public Contract createFromPattern(int pattern_id, String title, Calendar date, String pswd, Map<String, Object> titleParams, boolean inModules, int superId, int subMode, String customTitle, int userId) throws Exception {
        return this.createFromPattern(pattern_id, title, date, pswd, titleParams, inModules, superId, subMode, customTitle, userId, null);
    }

    public Contract createFromPattern(int pattern_id, String title, Calendar date, String pswd, Map<String, Object> titleParams, boolean inModules, int superId, int subMode, String customTitle, int userId, Map<String, Object> params) throws Exception {
        Contract result = null;
        String query = null;
        PreparedStatement ps = null;
        try (Statement st = this.con.createStatement();){
            int id = -1;
            ContractPattern pattern = null;
            pattern = new ContractPatternManager(this.con).getPattern(pattern_id);
            if (pattern == null) {
                pattern = new ContractPattern();
            }
            if (pattern.getId() > 0 && pattern.getData() != null && inModules) {
                ContractCreateEvent checkEvent = new ContractCreateEvent(userId, 0, pattern, params, true);
                checkEvent.setDateFrom(TimeUtils.convertCalendarToDate(date));
                checkEvent = EventProcessor.getInstance().request(checkEvent);
                if (Utils.notBlankString(checkEvent.getError())) {
                    throw new BGException(checkEvent.getError());
                }
            }
            this.con.commit();
            boolean add = false;
            if (title == null) {
                if (customTitle != null) {
                    if (customTitle.indexOf("${") == -1 && ContractPatternManager.isContractTitleDuplicated(customTitle, false, -1, this.con)) {
                        throw new BGMessageException(MESSAGE_ABOUT_DUPLICATE);
                    }
                    pattern.setNamePattern(customTitle);
                }
                if (pattern.getNamePattern() != null) {
                    title = ContractPatternManager.getContractTitle(this.con, pattern, date, titleParams);
                    add = true;
                }
            }
            if (add && !this.checkContractTitleOnDublication(title, -1) || !add && ContractPatternManager.isContractTitleDuplicated(title, true, -1, this.con)) {
                throw new BGMessageException(MESSAGE_ABOUT_DUPLICATE);
            }
            if (Utils.isBlankString(title)) {
                title = "New contract";
            }
            if (pattern.getId() > 0) {
                long groups = pattern.getGroups();
                for (Integer n : pattern.getContractLabels()) {
                    if (n >= 66) continue;
                    groups |= 1L << n - 2;
                }
                query = "INSERT INTO `contract` SET gr=?, title=?, pswd=?, date1=?, date2=?, closesumma=?, mode=?, pgid=?, fc=?, title_pattern_id=?, status=?, domainId=?";
                ps = this.con.prepareStatement(query);
                ps.setLong(1, groups);
                ps.setString(2, title);
                ps.setString(3, pswd);
                ps.setDate(4, TimeUtils.convertCalendarToSqlDate(date));
                if (pattern.getDaysToLive() == 0) {
                    ps.setDate(5, null);
                } else {
                    Calendar end = (Calendar)date.clone();
                    end.add(6, pattern.getDaysToLive() - 1);
                    ps.setDate(5, TimeUtils.convertCalendarToSqlDate(end));
                }
                ps.setFloat(6, pattern.getClosesumma());
                ps.setInt(7, pattern.getMode());
                ps.setInt(8, pattern.getParamsGroupId());
                ps.setInt(9, pattern.getFc());
                ps.setInt(10, pattern.getPatternId());
                ps.setInt(11, pattern.getStatus());
                ps.setInt(12, pattern.getDomainId());
                ps.executeUpdate();
                ps.close();
            } else {
                ps = this.con.prepareStatement("INSERT INTO `contract` SET title=?, date1=?, pswd=?");
                ps.setString(1, title);
                ps.setDate(2, TimeUtils.convertCalendarToSqlDate(date));
                ps.setString(3, pswd);
                ps.executeUpdate();
                ps.close();
            }
            id = ServerUtils.lastInsertId(this.con);
            new ContractLabelManager(this.con).setContractLabelIds(id, pattern.getContractLabels());
            result = this.getContractById(id);
            ContractStatus status = new ContractStatus();
            status.setContractId(id);
            status.setStatus(pattern.getStatus());
            status.setDateFrom(date.getTime());
            status.setDateTo(null);
            status.setComment("\u0421\u0442\u0430\u0442\u0443\u0441 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c");
            this.getContractStatusManager().changeStatus(status.clone(), userId, false);
            if (result != null) {
                List<String> serviceList;
                Element objectsElement;
                List<String> moduleList = pattern.getModuleList();
                if (moduleList != null && !moduleList.isEmpty()) {
                    query = "INSERT INTO contract_module SET cid=?, mid=?";
                    ps = this.con.prepareStatement(query);
                    ps.setInt(1, result.getId());
                    for (String moduleId : moduleList) {
                        ps.setString(2, moduleId);
                        ps.executeUpdate();
                    }
                    ps.close();
                }
                if (pattern.getData() != null && (objectsElement = XMLUtils.selectElement(pattern.getData(), "//objects")) != null) {
                    ObjectManager com = new ObjectManager(this.con);
                    NodeList nodeList = objectsElement.getElementsByTagName("object");
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Element singleObject = (Element)nodeList.item(i);
                        int oid = Utils.parseInt(singleObject.getAttribute("type"));
                        int amount = Utils.parseInt(singleObject.getAttribute("amount"));
                        for (int j = 0; j < amount; ++j) {
                            ContractObject newObj = new ContractObject();
                            newObj.setContractId(id);
                            newObj.setTypeId(oid);
                            newObj.setDate1(date);
                            com.updateObject(newObj);
                        }
                    }
                }
                if ((serviceList = pattern.getServiceList()) != null && !serviceList.isEmpty()) {
                    query = "INSERT INTO contract_service SET cid=?, sid=?, date1=?, date2=?";
                    ps = this.con.prepareStatement(query);
                    ps.setInt(1, result.getId());
                    ps.setDate(3, TimeUtils.convertDateToSqlDate(result.getDateFrom()));
                    ps.setDate(4, TimeUtils.convertDateToSqlDate(result.getDateTo()));
                    for (String string : serviceList) {
                        ps.setString(2, string);
                        ps.executeUpdate();
                    }
                    ps.close();
                }
                Throwable throwable = null;
                try (Iterator<Integer> contractTariffGroupDao = new ContractTariffGroupDao(this.con);){
                    int tariffGroupId;
                    if (pattern.getTariffGroupList().size() > 0 && (tariffGroupId = pattern.getTariffGroupList().get(0).intValue()) > 0) {
                        ContractTariffGroup contractGroup = new ContractTariffGroup();
                        contractGroup.setContractId(result.getId());
                        contractGroup.setTariffGroupId(tariffGroupId);
                        ((AbstractDao)((Object)contractTariffGroupDao)).update(contractGroup);
                    }
                }
                catch (Throwable tariffGroupId) {
                    Throwable throwable2 = tariffGroupId;
                    throw tariffGroupId;
                }
                query = "INSERT INTO contract_tariff SET cid=?, tpid=?, date1=?, date2=?, pos=?, tariff_group_id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(1, result.getId());
                ps.setDate(3, TimeUtils.convertDateToSqlDate(result.getDateFrom()));
                ps.setDate(4, TimeUtils.convertDateToSqlDate(result.getDateTo()));
                for (String string : pattern.getTariffPlanList()) {
                    int tariffGroupId = -1;
                    int tariffPosition = 0;
                    String[] aa = string.split(":");
                    int tariffId = Utils.parseInt(aa[0], 0);
                    if (aa.length > 1) {
                        tariffPosition = Utils.parseInt(aa[1]);
                    }
                    if (aa.length > 2) {
                        tariffGroupId = Utils.parseInt(aa[2]);
                    }
                    ps.setInt(2, tariffId);
                    ps.setInt(5, tariffPosition);
                    ps.setInt(6, tariffGroupId);
                    ps.executeUpdate();
                }
                ps.close();
                for (Integer n : pattern.getScriptList()) {
                    ContractScriptManager contractScriptManager = new ContractScriptManager(this.con);
                    ContractScript contractScript = new ContractScript();
                    contractScript.setContractId(result.getId());
                    contractScript.setScriptId(n);
                    contractScript.setDate1(new GregorianCalendar());
                    contractScriptManager.updateContractScript(contractScript);
                }
                Throwable throwable3 = null;
                try (WebMenuDao webMenuDao = new WebMenuDao(this.con);){
                    int webMenuId = pattern.getWebMenuId();
                    if (webMenuId > 0) {
                        webMenuDao.setWebMenuIdForContract(webMenuId, id);
                    }
                }
                catch (Throwable throwable4) {
                    Throwable throwable5 = throwable4;
                    throw throwable4;
                }
                if (pattern != null && pattern.getData() != null && inModules) {
                    ContractCreateEvent ev = new ContractCreateEvent(userId, id, pattern, params, false);
                    ev.setDateFrom(result.getDateFrom());
                    ev.setDateTo(result.getDateTo());
                    ev = EventProcessor.getInstance().request(ev);
                }
            }
            if (superId > 0) {
                result.setSuperId(superId);
                result.setSubMode(subMode);
                this.addSub(superId, id, subMode, userId);
            }
        }
        catch (Exception ex) {
            if (!MESSAGE_ABOUT_DUPLICATE.equals(ex.getMessage())) {
                ContractPatternManager.removeContractTitleFromLastTitles(title);
            }
            if (ex instanceof BGMessageException) {
                throw ex;
            }
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new BGException(ex.getMessage(), ex.getCause());
        }
        return result;
    }

    public List<Contract> getContracts(String idList) {
        ArrayList<Contract> result = new ArrayList<Contract>();
        try {
            if (idList == null || idList.isEmpty()) {
                return result;
            }
            String query = "SELECT * FROM contract WHERE id IN ( " + idList + " )";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getContractFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Contract getContractById(int cid) {
        Contract contract = null;
        try {
            PreparedStatement ps = this.getByIdPS;
            if (ps == null) {
                ps = this.getByIdPS = this.con.prepareStatement("SELECT * FROM contract WHERE id=?");
            }
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                contract = this.getContractFromRS(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return contract;
    }

    @Deprecated
    public Contract getContractByTitle(String title) {
        Contract result = null;
        try {
            String query = "SELECT * FROM contract WHERE title=? LIMIT 1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, title);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result = this.getContractFromRS(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public List<Contract> getContractsByTitles(String titles) {
        ArrayList<Contract> result = new ArrayList<Contract>();
        if (Utils.notBlankString(titles)) {
            try {
                String query = "SELECT * FROM contract WHERE title IN (" + titles + ")";
                PreparedStatement ps = this.con.prepareStatement(query);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    result.add(this.getContractFromRS(rs));
                }
                rs.close();
                ps.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    private Contract getContractFromRS(ResultSet rs) throws SQLException {
        Contract contract = new Contract();
        contract.setId(rs.getInt("id"));
        contract.setTitle(rs.getString("title"));
        contract.setPswd(rs.getString("pswd"));
        contract.setComment(rs.getString("comment"));
        contract.setBalanceMode(rs.getInt("mode"));
        contract.setBalanceLimit(rs.getBigDecimal("closesumma"));
        contract.setGroups(rs.getLong("gr"));
        contract.setFc(rs.getInt("fc"));
        contract.setParamGroup(rs.getInt("pgid"));
        contract.setDateFrom(rs.getDate("date1"));
        contract.setDateTo(rs.getDate("date2"));
        contract.setDel(rs.getInt("del"));
        contract.setSuperId(rs.getInt("scid"));
        contract.setDependSubList(rs.getString("sub_list"));
        contract.setSubMode(rs.getInt("sub_mode"));
        contract.setStatus(rs.getInt("status"));
        contract.setTitlePatternId(rs.getInt("title_pattern_id"));
        contract.setStatusDate(TimeUtils.convertDateToCalendar(rs.getDate("status_date")));
        contract.setDomainId(rs.getInt("domainId"));
        return contract;
    }

    public TariffTreeSet getRealtimeTariffTreeSet(int cid, java.util.Date date, String module, int mid, boolean useChache) {
        return this.getRealtimeTariffTreeSet(cid, date, module, mid, 0, 0, useChache);
    }

    @Deprecated
    public TariffTreeSet getRealtimeTariffTreeSet(int cid, Calendar time, String module, int mid, boolean useChache) {
        return this.getRealtimeTariffTreeSet(cid, time.getTime(), module, mid, 0, 0, useChache);
    }

    @Deprecated
    public TariffTreeSet getRealtimeTariffTreeSet(int cid, Calendar time, String module, int mid, int emid, int eid, boolean useChache) {
        return this.getRealtimeTariffTreeSet(cid, time.getTime(), module, mid, emid, eid, useChache);
    }

    public TariffTreeSet getRealtimeTariffTreeSet(int cid, java.util.Date time, String module, int mid, int emid, int eid, boolean useChache) {
        TariffTreeSet result = null;
        try {
            TariffTreeBuilder ttb = new TariffTreeBuilder(this.con);
            result = new TariffTreeSet(module, mid, ttb, cid, useChache);
            PreparedStatement ps = this.getRealtimeTariffTreeSetPS;
            if (ps == null) {
                String query = "SELECT tree_id, date1, date2, emid, eid, 1, pos FROM contract_tariff INNER JOIN tariff_plan ON contract_tariff.tpid=tariff_plan.id WHERE cid=? AND ((emid=0 AND eid=0) OR (emid=? AND eid=?)) AND ( isNull(date2) OR date2='0000-00-00' OR date2>=? ) UNION SELECT tree_id, date1, date2, emid, eid, 0, pos FROM contract_tree_link WHERE cid=? AND ((emid=0 AND eid=0) OR (emid=? AND eid=?)) AND (date2 IS NULL OR date2>=?) ORDER BY 4 DESC, 5 DESC, 6 ASC, 7 ASC";
                ps = this.getRealtimeTariffTreeSetPS = this.con.prepareStatement(query);
            }
            Date dt = TimeUtils.convertDateToSqlDate(time);
            ps.setInt(1, cid);
            ps.setInt(2, emid);
            ps.setInt(3, eid);
            ps.setDate(4, dt);
            ps.setInt(5, cid);
            ps.setInt(6, emid);
            ps.setInt(7, eid);
            ps.setDate(8, dt);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int treeId = rs.getInt(1);
                Date dateFrom = rs.getDate(2);
                Date dateTo = rs.getDate(3);
                int _emid = rs.getInt(4);
                int _eid = rs.getInt(5);
                result.addTariffTree(treeId, _emid, _eid, dateFrom, dateTo);
            }
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public TariffTreeSet getTariffTreeSetForDay(int contractId, Calendar time, String module, int moduleId, boolean useChache) {
        LocalDate localDate = LocalDateTime.ofInstant(time.toInstant(), time.getTimeZone().toZoneId()).toLocalDate();
        return this.getTariffTreeSetForDay(contractId, localDate, module, moduleId, useChache);
    }

    public TariffTreeSet getTariffTreeSetForDay(int contractId, LocalDate time, String module, int moduleId, boolean useChache) {
        TariffTreeSet result = null;
        try {
            TariffTreeBuilder ttb = new TariffTreeBuilder(this.con);
            result = new TariffTreeSet(module, moduleId, ttb, contractId, useChache);
            Date day = TimeUtils.convertLocalDateToSqlDate(time);
            String query = "SELECT tree_id, date1, date2, emid, eid, 1, pos FROM contract_tariff INNER JOIN tariff_plan ON contract_tariff.tpid=tariff_plan.id WHERE cid=? AND ( isNull(date1) OR date1='0000-00-00' OR date1<=? ) AND ( isNull(date2) OR date2='0000-00-00' OR date2>=? ) UNION SELECT tree_id, date1, date2, emid, eid, 0, pos FROM contract_tree_link WHERE cid=? AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR date2>=?) ORDER BY 4 DESC, 5 DESC, 6 ASC, 7 ASC";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ps.setDate(2, day);
            ps.setDate(3, day);
            ps.setInt(4, contractId);
            ps.setDate(5, day);
            ps.setDate(6, day);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int treeId = rs.getInt(1);
                Date dateFrom = rs.getDate(2);
                Date dateTo = rs.getDate(3);
                int emid = rs.getInt(4);
                int eid = rs.getInt(5);
                result.addTariffTree(treeId, emid, eid, dateFrom, dateTo);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public String freeContract(int cid) throws SQLException {
        Contract contract = this.getContractById(cid);
        int superCid = contract.getSuperId();
        java.util.Date recalculateDate = this.getRecalculateDate(contract.getId());
        if (recalculateDate == null && contract.getSubMode() == 0) {
            return "\u0421\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0438\u043c\u0435\u0435\u0442 \u0437\u0430\u043f\u0438\u0441\u0438 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u0432 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u043c \u043f\u0435\u0440\u0438\u043e\u0434\u0435!!";
        }
        try {
            String query = "UPDATE contract SET scid=0, sub_list='' WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.executeUpdate();
            ps.close();
            this.updateSuperContractDependSubList(superCid);
            if (contract.getSubMode() == 0) {
                BalanceUtils bu = new BalanceUtils(this.con);
                bu.recalculateBalance(superCid, recalculateDate);
                bu.recalculateBalance(cid, recalculateDate);
                bu.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void updateSuperContractDependSubList(int superId) throws SQLException {
        StringBuffer subList = new StringBuffer();
        String query = "SELECT id, sub_mode FROM contract WHERE scid=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, superId);
        boolean hasSub = false;
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            hasSub = true;
            int mode = rs.getInt(2);
            if (mode != 0) continue;
            if (subList.length() != 0) {
                subList.append(",");
            }
            subList.append(rs.getString(1));
        }
        ps.close();
        query = "UPDATE contract SET scid=?, sub_list=? WHERE id=?";
        ps = this.con.prepareStatement(query);
        if (!hasSub) {
            ps.setInt(1, 0);
            ps.setString(2, "");
        } else {
            ps.setInt(1, -1);
            ps.setString(2, subList.toString());
        }
        ps.setInt(3, superId);
        ps.executeUpdate();
        ps.close();
    }

    public String addSub(int superId, int subId, int subMode) throws SQLException, BGException {
        return this.addSub(superId, subId, subMode, 0);
    }

    private String addSub(int superId, int subId, int subMode, int userId) throws SQLException, BGException {
        ServerContext context;
        Contract contract = this.getContractById(subId);
        if (contract.getSuperId() != 0) {
            return "\u0421\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u043c \u043c\u043e\u0436\u043d\u043e \u0441\u0434\u0435\u043b\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440!";
        }
        Contract superContract = this.getContractById(superId);
        if (superContract.isSub()) {
            return "\u0421\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u043c \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0432\u044b\u0441\u0442\u0443\u043f\u0430\u0442\u044c \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440!";
        }
        java.util.Date recalculateDate = this.getRecalculateDate(contract.getId());
        if (recalculateDate == null && subMode == 0) {
            return "\u0421\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0438\u043c\u0435\u0435\u0442 \u0437\u0430\u043f\u0438\u0441\u0438 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u0432 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u043c \u043f\u0435\u0440\u0438\u043e\u0434\u0435!!";
        }
        String query = "UPDATE contract SET scid=?, sub_list='', sub_mode=? WHERE id=?";
        PreparedStatement psSetSuper = this.con.prepareStatement(query);
        psSetSuper.setInt(1, superId);
        psSetSuper.setInt(2, subMode);
        psSetSuper.setInt(3, subId);
        psSetSuper.executeUpdate();
        psSetSuper.close();
        this.updateSuperContractDependSubList(superId);
        if (subMode == 0) {
            query = "UPDATE contract_balance SET summa1=0 WHERE cid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, subId);
            ps.executeUpdate();
            ps.close();
            BalanceUtils bu = new BalanceUtils(this.con);
            bu.recalculateBalance(superId, recalculateDate);
            bu.recalculateBalance(subId, recalculateDate);
            bu.close();
        }
        if ((context = (ServerContext)ServerContext.get()) != null) {
            context.publishAfterCommit(new ContractModifiedEvent(userId, subId));
            context.publishAfterCommit(new ContractModifiedEvent(userId, superId));
        } else {
            EventProcessor.getInstance().publish(new ContractModifiedEvent(userId, subId));
            EventProcessor.getInstance().publish(new ContractModifiedEvent(userId, superId));
        }
        return null;
    }

    public List<Contract> getSubContracts(int cid) {
        ArrayList<Contract> result = new ArrayList<Contract>();
        try {
            String query = "SELECT * FROM contract WHERE scid=? ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getContractFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean isSubContract(int cid, int subcid) throws BGException {
        boolean result = false;
        try {
            String query = "SELECT * FROM contract WHERE id=? AND scid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, subcid);
            ps.setInt(2, cid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = true;
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            throw new BGException(e);
        }
        return result;
    }

    public List<Contract> getSubContracts(int cid, int subMode) {
        ArrayList<Contract> result = new ArrayList<Contract>();
        try {
            String query = "SELECT * FROM contract WHERE scid=? AND sub_mode=? ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, subMode);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getContractFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public void updateLastTariffChange(int cid) {
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE contract SET last_tariff_change=NOW() WHERE id=?");
            ps.setInt(1, cid);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateContract(Contract contract) {
        if (contract != null) {
            try {
                int index = 1;
                PreparedStatement ps = null;
                StringBuilder query = new StringBuilder();
                query.append("UPDATE ");
                query.append(TABLE_CONTRACT);
                query.append(" SET gr=?, title=?, title_pattern_id=?, pswd=?, date1=?, date2=?,");
                query.append(" mode=?, closesumma=?, pgid=?, fc=?, comment=?, del=?,");
                query.append(" scid=?, sub_list=?, sub_mode=?, status=?, status_date=?, domainId=? WHERE id=?");
                ps = this.con.prepareStatement(query.toString());
                ps.setLong(index++, contract.getGroups());
                ps.setString(index++, contract.getTitle());
                ps.setInt(index++, contract.getTitlePatternId());
                ps.setString(index++, contract.getPswd());
                ps.setDate(index++, TimeUtils.convertDateToSqlDate(contract.getDateFrom()));
                ps.setDate(index++, TimeUtils.convertDateToSqlDate(contract.getDateTo()));
                ps.setInt(index++, contract.getBalanceMode());
                ps.setBigDecimal(index++, contract.getBalanceLimit());
                ps.setInt(index++, contract.getParamGroup());
                ps.setInt(index++, contract.getFc());
                ps.setString(index++, contract.getComment());
                ps.setInt(index++, contract.getDel());
                ps.setInt(index++, contract.getSuperId());
                ps.setString(index++, contract.getDependSubList());
                ps.setInt(index++, contract.getSubMode());
                ps.setInt(index++, contract.getStatus());
                ps.setDate(index++, TimeUtils.convertCalendarToSqlDate(contract.getStatusDate()));
                ps.setInt(index++, contract.getDomainId());
                ps.setInt(index++, contract.getId());
                ps.executeUpdate();
                ps.close();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean checkContractTitleOnDublication(String contractTitle, int contractId) {
        boolean result = true;
        String query = "SELECT count(*) FROM contract WHERE " + (contractId > 0 ? "id<>" + contractId + " AND " : "") + "UPPER(title)=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, contractTitle.toUpperCase());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1) == 0;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    private java.util.Date getRecalculateDate(int cid) throws SQLException {
        String query = "SELECT yy, mm FROM contract_balance WHERE cid=? ORDER BY yy, mm";
        PreparedStatement firstDatePs = this.con.prepareStatement(query);
        firstDatePs.setInt(1, cid);
        ResultSet rs = firstDatePs.executeQuery();
        GregorianCalendar recalculateDate = new GregorianCalendar();
        if (rs.next()) {
            recalculateDate = new GregorianCalendar(rs.getInt(1), rs.getInt(2) - 1, 1);
        }
        firstDatePs.close();
        Calendar closePeriodDate = ClosedDateChecker.getInstance().getClosePeriodDate(1);
        if (closePeriodDate != null && TimeUtils.dateBefore(recalculateDate, closePeriodDate)) {
            return null;
        }
        return recalculateDate.getTime();
    }

    public void addContractGroup(int cid, int groupId) throws SQLException {
        PreparedStatement ps = this.con.prepareStatement("UPDATE contract SET gr=gr|(1<<?) WHERE id=?");
        ps.setInt(1, groupId);
        ps.setInt(2, cid);
        ps.executeUpdate();
        ps.close();
    }

    public void deleteContractGroup(int cid, long groupId) throws SQLException {
        PreparedStatement ps = this.con.prepareStatement("UPDATE contract SET gr=gr&~(1<<?) WHERE id=?");
        ps.setLong(1, groupId);
        ps.setInt(2, cid);
        ps.executeUpdate();
        ps.close();
    }

    public void closeContract(int cid) throws SQLException, BGException {
        this.closeContract(cid, 0, 0, new java.util.Date());
    }

    public void closeContract(int cid, int mid, int userId) throws SQLException, BGException {
        this.closeContract(cid, mid, userId, new java.util.Date());
    }

    public void closeContract(int cid, int mid, int userId, java.util.Date date) throws SQLException, BGException {
        Contract contract = this.getContractById(cid);
        if (contract == null) {
            throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0431\u0430\u0437\u0435");
        }
        if (date != null) {
            String error;
            Calendar closedDate = null;
            closedDate = ClosedDateChecker.getClosePeriodDateIfChecking("ActionUpdateContractDate2", mid, userId);
            if (closedDate != null) {
                ClosedDateChecker.checkDatesForDelete(closedDate, date);
            }
            ArrayList<Contract> dependSubList = new ArrayList<Contract>();
            if (contract.getSuperId() == -1) {
                for (int subContractId : Utils.toIntegerList(contract.getDependSubList())) {
                    String error2;
                    Contract subContract = this.getContractById(subContractId);
                    dependSubList.add(subContract);
                    if (subContract.getDateTo() != null && TimeUtils.dateBeforeOrEq(subContract.getDateTo(), date) || !Utils.notBlankString(error2 = this.checkClosePossible(subContractId, date, userId))) continue;
                    throw new BGMessageException("\u0421\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + new ContractUtils(this.con).getContractTitle(subContractId, false) + " " + error2);
                }
            }
            if (Utils.notBlankString(error = this.checkClosePossible(cid, date, userId))) {
                throw new BGException(error);
            }
            if (contract.getSuperId() == -1) {
                for (Contract subContract : dependSubList) {
                    if (subContract.getDateTo() != null && TimeUtils.dateBeforeOrEq(subContract.getDateTo(), date)) continue;
                    this.changeDate2(subContract.getId(), date, userId);
                }
            }
        }
        this.changeDate2(cid, date, userId);
    }

    private String checkClosePossible(int cid, java.util.Date date, int userID) throws BGException {
        ContractCloseEvent checkEvent = new ContractCloseEvent(userID, cid, date, true);
        EventProcessor.getInstance().request(checkEvent);
        return checkEvent.getError();
    }

    private void changeDate2(int contractId, java.util.Date date, int userId) throws SQLException, BGException {
        if (date == null) {
            Date sqlDate = TimeUtils.convertDateToSqlDate(date);
            String query = "UPDATE contract SET date2=? WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setDate(1, sqlDate);
            ps.setInt(2, contractId);
            ps.executeUpdate();
            ps.close();
        } else {
            Date sqlDate = TimeUtils.convertDateToSqlDate(date);
            String query = "UPDATE contract SET date2=? WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setDate(1, sqlDate);
            ps.setInt(2, contractId);
            ps.executeUpdate();
            ps.close();
            query = "UPDATE contract_service SET date2=? WHERE isNull( date2 ) AND cid=?";
            ps = this.con.prepareStatement(query);
            ps.setDate(1, sqlDate);
            ps.setInt(2, contractId);
            ps.executeUpdate();
            ps.close();
            query = "UPDATE contract_tariff SET date2=? WHERE isNull( date2 ) AND cid=?";
            ps = this.con.prepareStatement(query);
            ps.setDate(1, sqlDate);
            ps.setInt(2, contractId);
            ps.executeUpdate();
            ps.close();
            query = "UPDATE contract_tree_link SET date2=? WHERE isNull( date2 ) AND cid=?";
            ps = this.con.prepareStatement(query);
            ps.setDate(1, sqlDate);
            ps.setInt(2, contractId);
            ps.executeUpdate();
            ps.close();
            query = "UPDATE contract_script SET date2=? WHERE isNull( date2 ) AND cid=?";
            ps = this.con.prepareStatement(query);
            ps.setDate(1, sqlDate);
            ps.setInt(2, contractId);
            ps.executeUpdate();
            ps.close();
            query = "UPDATE object SET date2=? WHERE isNull( date2 ) AND cid=?";
            ps = this.con.prepareStatement(query);
            ps.setDate(1, sqlDate);
            ps.setInt(2, contractId);
            ps.executeUpdate();
            ps.close();
            EventProcessor.getInstance().request(new ContractCloseEvent(userId, contractId, date, false));
        }
    }

    @Override
    public void recycle() {
        try {
            if (this.getByIdPS != null) {
                this.getByIdPS.close();
                this.getByIdPS = null;
            }
            if (this.getRealtimeTariffTreeSetPS != null) {
                this.getRealtimeTariffTreeSetPS.close();
                this.getRealtimeTariffTreeSetPS = null;
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public Map<Integer, Integer> getContractParameterGroupCountMap() throws BGException {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        try {
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT pgid, COUNT(*) FROM contract GROUP BY pgid");
            while (rs.next()) {
                map.put(rs.getInt(1), rs.getInt(2));
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return map;
    }

    public boolean checkContractService(int contractId, int serviceId, java.util.Date date) throws BGException {
        boolean result = false;
        try {
            Date sqlDate = TimeUtils.convertDateToSqlDate(date);
            String query = "SELECT count(*) FROM contract_service WHERE cid=? AND sid=? AND date1<=? AND ( isNull( date2 ) || date2 >=? )";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ps.setInt(2, serviceId);
            ps.setDate(3, sqlDate);
            ps.setDate(4, sqlDate);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result = rs.getInt(1) > 0;
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return result;
    }

    @Override
    public void close() {
        this.recycle();
    }
}

