/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractStatus;
import bitel.billing.server.contract.bean.ContractStatusLog;
import bitel.billing.server.util.Config;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.ContractSetStatusLogicEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusChangedEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusChangedTopicEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusChangingEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusModifiedEvent;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.worker.Recyclable;
import ru.bitel.common.worker.ThreadContext;

public class ContractStatusManager
implements Recyclable {
    private static final Logger logger = Logger.getLogger(ContractStatusManager.class);
    protected final Connection con;
    private final ServerContext context;
    private final EventProcessor ep;
    private ContractManager contractManager;
    private PreparedStatement getStatusListPS;
    private PreparedStatement getPeriodListPS;

    public ContractStatusManager(Connection con) {
        this.con = con;
        Object context = ThreadContext.get();
        this.context = context instanceof ServerContext ? (ServerContext)context : null;
        this.ep = EventProcessor.getInstance();
    }

    public ContractStatus getStatus(int cid, java.util.Date date) throws SQLException {
        ContractStatus result = null;
        Date sqlDate = TimeUtils.convertDateToSqlDate(date);
        String query = "SELECT * FROM contract_status WHERE cid=? AND date1<=? AND (date2 IS NULL OR date2>=?) LIMIT 1";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, cid);
        ps.setDate(2, sqlDate);
        ps.setDate(3, sqlDate);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = this.getStatusFromRs(rs);
        }
        rs.close();
        ps.close();
        return result;
    }

    public List<ContractStatus> getStatusList(int cid, java.util.Date date) throws SQLException {
        ArrayList<ContractStatus> result = new ArrayList<ContractStatus>();
        String query = "SELECT * FROM contract_status WHERE cid=? AND (date2 IS NULL OR ?<=date2) ORDER BY date1";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, cid);
        ps.setDate(2, TimeUtils.convertDateToSqlDate(date));
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(this.getStatusFromRs(rs));
        }
        rs.close();
        ps.close();
        return result;
    }

    public List<ContractStatus> getStatusListAfterDate(int cid, Calendar date) throws SQLException {
        ArrayList<ContractStatus> result = new ArrayList<ContractStatus>();
        Date sqlDate = TimeUtils.convertCalendarToSqlDate(date);
        String query = "SELECT * FROM contract_status WHERE cid=? AND date1>? ORDER BY date1";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, cid);
        ps.setDate(2, sqlDate);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(this.getStatusFromRs(rs));
        }
        rs.close();
        ps.close();
        return result;
    }

    public List<ContractStatus> getStatusList(int cid) throws SQLException {
        ArrayList<ContractStatus> result = new ArrayList<ContractStatus>();
        String query = "SELECT * FROM contract_status WHERE cid=? ORDER BY date1";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, cid);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(this.getStatusFromRs(rs));
        }
        rs.close();
        ps.close();
        return result;
    }

    private void updateStatus(ContractStatus status, Integer userId) throws BGException {
        try {
            PreparedStatement ps;
            if (status.getId() <= 0) {
                String query = "INSERT INTO contract_status (date1, date2, status, comment, cid) VALUES (?, ?, ?, ?, ?)";
                ps = this.con.prepareStatement(query, 1);
                ps.setInt(5, status.getContractId());
            } else {
                String query = "UPDATE contract_status SET date1=?, date2=?, status=?, comment=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(5, status.getId());
            }
            ps.setDate(1, TimeUtils.convertDateToSqlDate(status.getDateFrom()));
            ps.setDate(2, TimeUtils.convertDateToSqlDate(status.getDateTo()));
            ps.setInt(3, status.getStatus());
            ps.setString(4, status.getComment());
            ps.executeUpdate();
            if (status.getId() <= 0) {
                status.setId(ServerUtils.lastInsertId(ps));
            }
            ps.close();
            if (this.context != null) {
                this.context.publishAfterCommit(new ContractStatusModifiedEvent(status.getContractId(), (int)userId, null, status));
            } else {
                this.ep.publish(new ContractStatusModifiedEvent(status.getContractId(), (int)userId, null, status));
            }
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void setContractStatus(ContractStatus status) throws SQLException {
        String query = "UPDATE contract SET status=?, status_date=? WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, status.getStatus());
        ps.setDate(2, TimeUtils.convertDateToSqlDate(status.getDateFrom()));
        ps.setInt(3, status.getContractId());
        ps.executeUpdate();
        ps.close();
    }

    private void deleteStatus(int id) throws BGException {
        try {
            String query = "DELETE FROM contract_status WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
            ContractStatus status = new ContractStatus();
            status.setId(id);
            if (this.context != null) {
                this.context.publishAfterCommit(new ContractStatusModifiedEvent(status.getContractId(), 0, status, null));
            } else {
                this.ep.publish(new ContractStatusModifiedEvent(status.getContractId(), 0, status, null));
            }
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    private void deleteStatus(ContractStatus status, int userId) throws BGException {
        try {
            String query = "DELETE FROM contract_status WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, status.getId());
            ps.executeUpdate();
            ps.close();
            if (this.context != null) {
                this.context.publishAfterCommit(new ContractStatusModifiedEvent(status.getContractId(), userId, status, null));
            } else {
                this.ep.publish(new ContractStatusModifiedEvent(status.getContractId(), userId, status, null));
            }
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    private ContractStatus getStatusFromRs(ResultSet rs) throws SQLException {
        ContractStatus result = new ContractStatus();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("cid"));
        result.setDateFrom(rs.getDate("date1"));
        result.setDateTo(rs.getDate("date2"));
        result.setStatus(rs.getInt("status"));
        result.setComment(rs.getString("comment"));
        return result;
    }

    public void changeStatus(ContractStatus newStatus, Integer userId) throws BGException {
        this.changeStatus(newStatus, userId, true);
    }

    private ContractManager getContractManager() {
        if (this.contractManager == null) {
            this.contractManager = new ContractManager(this.con);
        }
        return this.contractManager;
    }

    public void changeStatus(ContractStatus newStatus, Integer userId, boolean processEvent) throws BGException {
        try {
            userId = userId != null ? userId : 0;
            boolean useEventSetStatusLogic = Setup.getSetup().getBoolean("use.event.set.status.logic", false);
            ContractStatus originalStatus = newStatus.clone();
            newStatus = newStatus.clone();
            Contract contract = this.getContractManager().getContractById(originalStatus.getContractId());
            if (contract == null) {
                return;
            }
            GregorianCalendar prevDay = new GregorianCalendar();
            prevDay.setTime(originalStatus.getDateFrom());
            ((Calendar)prevDay).add(5, -1);
            GregorianCalendar nextDay = null;
            if (originalStatus.getDateTo() != null) {
                nextDay = new GregorianCalendar();
                nextDay.setTime(originalStatus.getDateTo());
                ((Calendar)nextDay).add(6, 1);
            }
            List<ContractStatus> statusList = this.getStatusList(originalStatus.getContractId(), originalStatus.getDateFrom());
            for (ContractStatus status : statusList) {
                if (!ContractStatusManager.isStatusPeriodValid(newStatus)) break;
                if (useEventSetStatusLogic) {
                    ContractSetStatusLogicEvent contractSetStatusLogicEvent = new ContractSetStatusLogicEvent((int)userId, status, newStatus, originalStatus);
                    contractSetStatusLogicEvent = EventProcessor.getInstance().request(contractSetStatusLogicEvent);
                    if (contractSetStatusLogicEvent.isProcessed()) continue;
                }
                if (newStatus.getDateFrom() != null && status.getDateTo() != null && !TimeUtils.dateBeforeOrEq(newStatus.getDateFrom(), status.getDateTo()) || newStatus.getDateTo() != null && status.getDateFrom() != null && !TimeUtils.dateBeforeOrEq(status.getDateFrom(), newStatus.getDateTo())) continue;
                if (TimeUtils.dateBeforeOrEq(newStatus.getDateFrom(), status.getDateFrom()) && (newStatus.getDateTo() == null || status.getDateTo() != null && TimeUtils.dateBeforeOrEq(status.getDateTo(), newStatus.getDateTo()))) {
                    this.deleteStatus(status, userId);
                    continue;
                }
                if (newStatus.getDateTo() != null && TimeUtils.periodInRange(newStatus.getDateFrom(), newStatus.getDateTo(), status.getDateFrom(), status.getDateTo())) {
                    ContractStatus nextStatus = status.clone();
                    nextStatus.setDateFrom(nextDay.getTime());
                    if (ContractStatusManager.isStatusPeriodValid(nextStatus)) {
                        this.updateStatus(nextStatus, userId);
                    }
                    status.setDateTo(prevDay.getTime());
                    this.doByPeriod(status, userId);
                    continue;
                }
                if (newStatus.getDateTo() != null && TimeUtils.dateInRange(status.getDateFrom(), newStatus.getDateFrom(), newStatus.getDateTo())) {
                    status.setDateFrom(nextDay.getTime());
                    this.doByPeriod(status, userId);
                    continue;
                }
                if (status.getDateTo() != null && !TimeUtils.dateInRange(status.getDateTo(), newStatus.getDateFrom(), newStatus.getDateTo())) continue;
                status.setDateTo(prevDay.getTime());
                this.doByPeriod(status, userId);
            }
            ContractStatus statusEvent = new ContractStatus();
            statusEvent.setContractId(newStatus.getContractId());
            statusEvent.setDateFrom(newStatus.getDateFrom());
            statusEvent.setDateTo(newStatus.getDateTo());
            statusEvent.setStatus(newStatus.getStatus());
            statusEvent.setComment(newStatus.getComment());
            if (processEvent) {
                EventProcessor.getInstance().request(new ContractStatusChangingEvent((int)userId, statusEvent, originalStatus));
            }
            if (ContractStatusManager.isStatusPeriodValid(statusEvent)) {
                this.updateStatus(statusEvent, userId);
            }
            java.util.Date date = new java.util.Date();
            if (TimeUtils.dateBeforeOrEq(statusEvent.getDateFrom(), date) && (statusEvent.getDateTo() == null || TimeUtils.dateBeforeOrEq(date, statusEvent.getDateTo()))) {
                this.setContractStatus(statusEvent);
                if (processEvent) {
                    EventProcessor.getInstance().publishAfterCommit(new ContractStatusChangedEvent(statusEvent, userId));
                    EventProcessor.getInstance().publishAfterCommit(new ContractStatusChangedTopicEvent(statusEvent, userId));
                }
            }
            ContractStatusLog log = new ContractStatusLog();
            log.setDate(new java.util.Date());
            log.setCid(originalStatus.getContractId());
            log.setComment(originalStatus.getComment());
            log.setUserId(userId);
            log.setStatus(originalStatus.getStatus());
            log.setDate1(originalStatus.getDateFrom());
            log.setDate2(originalStatus.getDateTo());
            if (originalStatus.getStatus() != statusEvent.getStatus() || statusEvent.getDateFrom() == null || originalStatus.getDateFrom().getTime() != statusEvent.getDateFrom().getTime() || originalStatus.getDateTo() == null && statusEvent.getDateTo() != null || originalStatus.getDateTo() != null && statusEvent.getDateTo() == null || originalStatus.getDateTo() != null && statusEvent.getDateTo() != null && originalStatus.getDateTo().getTime() != statusEvent.getDateTo().getTime()) {
                log.setComment(log.getComment() + "; \u0441\u0442\u0430\u0442\u0443\u0441 \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u0441\u044f (\u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u043f\u0440\u043e\u043c\u0435\u0436\u0443\u0442\u043e\u043a: " + TimeUtils.formatDate(statusEvent.getDateFrom()) + "-" + TimeUtils.formatDate(statusEvent.getDateTo()) + ":" + StatusCache.getInstance().getStatusTitle(statusEvent.getStatus()) + ")");
                if (!ContractStatusManager.isStatusPeriodValid(statusEvent)) {
                    log.setComment(log.getComment() + "(\u0442.\u0435. \u0432\u044b\u0440\u043e\u0434\u0438\u043b\u0441\u044f)");
                }
            }
            if (!originalStatus.getComment().equals(statusEvent.getComment())) {
                log.setComment(log.getComment() + "; \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u0441\u044f: \"" + statusEvent.getComment() + "\"");
            }
            this.saveLog(log);
            if (contract.isSuper()) {
                ContractStatusManagerConf conf = Setup.getSetup().getConfig(0, ContractStatusManagerConf.class);
                if (conf.dependSubContractStatusChange) {
                    Iterator<Comparable<Integer>> iterator = Utils.toIntegerList(contract.getDependSubList()).iterator();
                    while (iterator.hasNext()) {
                        int subId = iterator.next();
                        originalStatus.setContractId(subId);
                        this.changeStatus(originalStatus, userId, processEvent);
                    }
                }
                if (conf.independSubContractStatusChange) {
                    for (Contract contr : this.getContractManager().getSubContracts(contract.getId(), 1)) {
                        originalStatus.setContractId(contr.getId());
                        this.changeStatus(originalStatus, userId, processEvent);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public static boolean isStatusPeriodValid(ContractStatus status) {
        return status.getDateFrom() != null && (status.getDateTo() == null || TimeUtils.dateBeforeOrEq(status.getDateFrom(), status.getDateTo()));
    }

    private void doByPeriod(ContractStatus status, Integer userId) throws BGException {
        if (ContractStatusManager.isStatusPeriodValid(status)) {
            this.updateStatus(status, userId);
        } else {
            this.deleteStatus(status, userId);
        }
    }

    private void saveLog(ContractStatusLog log) throws SQLException {
        String query = "INSERT INTO contract_status_log SET  date=?,  status=?, comment=?, uid=?, date1 = ?, date2 = ?, cid = ? ";
        PreparedStatement ps = this.con.prepareStatement(query);
        int idx = 1;
        ps.setTimestamp(idx++, TimeUtils.convertDateToTimestamp(log.getDate()));
        ps.setInt(idx++, log.getStatus());
        ps.setString(idx++, log.getComment());
        ps.setInt(idx++, log.getUserId());
        ps.setDate(idx++, TimeUtils.convertDateToSqlDate(log.getDate1()));
        ps.setDate(idx++, TimeUtils.convertDateToSqlDate(log.getDate2()));
        ps.setInt(idx++, log.getCid());
        ps.executeUpdate();
        ps.close();
    }

    public List<ContractStatusLog> getLogList(int cid) throws SQLException {
        ArrayList<ContractStatusLog> result = new ArrayList<ContractStatusLog>();
        String query = "SELECT * FROM contract_status_log WHERE cid=? ORDER BY date";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, cid);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.add(this.getLogFromRs(rs));
        }
        rs.close();
        ps.close();
        return result;
    }

    private ContractStatusLog getLogFromRs(ResultSet rs) throws SQLException {
        ContractStatusLog result = new ContractStatusLog();
        result.setId(rs.getInt("id"));
        result.setUserId(rs.getInt("uid"));
        result.setDate(rs.getTimestamp("date"));
        result.setStatus(rs.getInt("status"));
        result.setComment(rs.getString("comment"));
        result.setCid(rs.getInt("cid"));
        result.setDate1(rs.getDate("date1"));
        result.setDate2(rs.getDate("date2"));
        return result;
    }

    public List<ContractStatus> getStatusList(int cid, Set<Integer> statuses, java.util.Date startMonth, java.util.Date endMonth) throws SQLException {
        ArrayList<ContractStatus> result = new ArrayList<ContractStatus>();
        if (this.getStatusListPS == null) {
            String query = "SELECT status.id, status.date1, status.date2 FROM contract_status AS status WHERE status.cid=? AND status.status IN (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) AND (? IS NULL OR status.date1 IS NULL OR status.date1<=?) AND (status.date2 IS NULL OR status.date2>=?) ORDER BY status.date1";
            this.getStatusListPS = this.con.prepareStatement(query);
        }
        if (statuses.size() > 20) {
            logger.error((Object)"Too many suspended statuses (contract.status.suspend.codes)!");
        }
        int i = 1;
        this.getStatusListPS.setInt(i++, cid);
        for (Integer status : statuses) {
            this.getStatusListPS.setInt(i++, status);
        }
        while (i < 22) {
            this.getStatusListPS.setNull(i, 4);
            ++i;
        }
        Date endMonthSql = TimeUtils.convertDateToSqlDate(endMonth);
        this.getStatusListPS.setDate(i++, endMonthSql);
        this.getStatusListPS.setDate(i++, endMonthSql);
        this.getStatusListPS.setDate(i++, TimeUtils.convertDateToSqlDate(startMonth));
        ResultSet rs = this.getStatusListPS.executeQuery();
        while (rs.next()) {
            Date date1 = rs.getDate(2);
            Date date2 = rs.getDate(3);
            ContractStatus status = new ContractStatus();
            status.setId(rs.getInt(1));
            status.setDateFrom(date1);
            status.setDateTo(date2);
            result.add(status);
        }
        rs.close();
        return result;
    }

    public List<Period> getPeriodList(int contractId, Set<Integer> statuses, java.util.Date startMonth, java.util.Date endMonth) throws SQLException {
        ArrayList<Period> result = new ArrayList<Period>();
        if (this.getPeriodListPS == null) {
            String query = "SELECT status.date1, status.date2 FROM contract_status AS status WHERE status.cid=? AND status.status IN (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) AND (? IS NULL OR status.date1 IS NULL OR status.date1<=?) AND (status.date2 IS NULL OR status.date2>=?) ORDER BY status.date1";
            this.getPeriodListPS = this.con.prepareStatement(query);
        }
        if (statuses.size() > 20) {
            logger.error((Object)"Too many suspended statuses (contract.status.suspend.codes)!");
        }
        int i = 1;
        this.getPeriodListPS.setInt(i++, contractId);
        for (Integer status : statuses) {
            this.getPeriodListPS.setInt(i++, status);
        }
        while (i < 22) {
            this.getPeriodListPS.setNull(i, 4);
            ++i;
        }
        Date endMonthSql = TimeUtils.convertDateToSqlDate(endMonth);
        this.getPeriodListPS.setDate(i++, endMonthSql);
        this.getPeriodListPS.setDate(i++, endMonthSql);
        this.getPeriodListPS.setDate(i++, TimeUtils.convertDateToSqlDate(startMonth));
        ResultSet rs = this.getPeriodListPS.executeQuery();
        while (rs.next()) {
            java.util.Date date2;
            java.util.Date date1 = rs.getDate(1);
            if (date1 == null || startMonth != null && TimeUtils.dateBefore(date1, startMonth)) {
                date1 = startMonth;
            }
            if ((date2 = rs.getDate(2)) == null || endMonth != null && TimeUtils.dateBefore(endMonth, date2)) {
                date2 = endMonth;
            }
            result.add(new Period(date1, date2));
        }
        rs.close();
        result.trimToSize();
        return result;
    }

    @Override
    public void recycle() {
        try {
            if (this.getStatusListPS != null) {
                this.getStatusListPS.close();
                this.getStatusListPS = null;
            }
            if (this.getPeriodListPS != null) {
                this.getPeriodListPS.close();
                this.getPeriodListPS = null;
            }
            if (this.contractManager != null) {
                this.contractManager.recycle();
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public static class ContractStatusManager4Script
    extends ContractStatusManager {
        public ContractStatusManager4Script(Connection con) {
            super(con);
        }

        @Override
        public void deleteStatus(int id) throws BGException {
            ((ContractStatusManager)this).deleteStatus(id);
        }

        @Override
        public void updateStatus(ContractStatus status, Integer userId) throws BGException {
            ((ContractStatusManager)this).updateStatus(status, userId);
        }

        @Override
        public void doByPeriod(ContractStatus status, Integer userId) throws BGException {
            ((ContractStatusManager)this).doByPeriod(status, userId);
        }

        @Override
        public void saveLog(ContractStatusLog log) throws SQLException {
            ((ContractStatusManager)this).saveLog(log);
        }
    }

    static class ContractStatusManagerConf
    extends Config {
        final boolean dependSubContractStatusChange;
        final boolean independSubContractStatusChange = Utils.parseBoolean(Setup.getSetup().get("independ.subcontract.status.change", "no"));

        public ContractStatusManagerConf(int mid, ParameterMap moduleSetup, Setup serverSetup) {
            super(mid, moduleSetup, serverSetup);
            this.dependSubContractStatusChange = Utils.parseBoolean(Setup.getSetup().get("depend.subcontract.status.change", "1"));
        }
    }
}

