/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean.find;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import ru.bitel.common.Utils;

public class SearchConvertPattern {
    private static final Logger log = Logger.getLogger(SearchConvertPattern.class);
    private static final Pattern p0 = Pattern.compile("\\$0");
    private static final Pattern p1 = Pattern.compile("\\$1");
    private static final Pattern p2 = Pattern.compile("\\$2");
    private static final Pattern p3 = Pattern.compile("\\$3");
    private static final Pattern p4 = Pattern.compile("\\$4");
    private static final Pattern p5 = Pattern.compile("\\$5");
    private static final Pattern pArrow = Pattern.compile("=>");
    private static final Pattern pOr = Pattern.compile("\\|\\|");
    private final Pattern pattern;
    private final String replace;

    public SearchConvertPattern(String param) {
        Pattern pattern = null;
        String replace = null;
        if (param != null) {
            String[] params = pArrow.split(param, 2);
            try {
                pattern = Pattern.compile(params[0]);
                replace = params[1];
            }
            catch (Exception e) {
                pattern = null;
                replace = null;
                e.printStackTrace();
                log.warn((Object)("SearchContract: Can't parse param: " + param));
            }
        }
        this.pattern = pattern;
        this.replace = replace;
    }

    public static final SearchConvertPattern[] getPatterns(String patterns) {
        if (Utils.notEmptyString(patterns)) {
            String[] pt = pOr.split(patterns);
            ArrayList<SearchConvertPattern> result = new ArrayList<SearchConvertPattern>(pt.length);
            for (String p : pt) {
                SearchConvertPattern s = new SearchConvertPattern(p);
                if (s.pattern == null) continue;
                result.add(s);
            }
            return result.toArray(new SearchConvertPattern[result.size()]);
        }
        return null;
    }

    public String toString() {
        return this.pattern != null ? this.pattern.pattern() + "=>" + this.replace : "";
    }

    public static String toString(SearchConvertPattern[] ps) {
        if (ps != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ps.length; ++i) {
                if (i != 0) {
                    sb.append("||");
                }
                sb.append(ps[i].toString());
            }
            return sb.toString();
        }
        return "";
    }

    public static String convert(String number, SearchConvertPattern[] patterns) {
        for (SearchConvertPattern pattern : patterns) {
            Matcher m;
            if (pattern.replace == null || !(m = pattern.pattern.matcher(number)).find()) continue;
            number = pattern.replace;
            switch (m.groupCount()) {
                case 5: {
                    number = p5.matcher(number).replaceAll(m.group(5));
                }
                case 4: {
                    number = p4.matcher(number).replaceAll(m.group(4));
                }
                case 3: {
                    number = p3.matcher(number).replaceAll(m.group(3));
                }
                case 2: {
                    number = p2.matcher(number).replaceAll(m.group(2));
                }
                case 1: {
                    number = p1.matcher(number).replaceAll(m.group(1));
                    break;
                }
                case 0: {
                    number = p0.matcher(number).replaceAll(m.group());
                }
            }
            return number;
        }
        return number;
    }
}

