/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.object.bean;

import bitel.billing.server.contract.object.bean.AddressParamValue;
import bitel.billing.server.contract.object.bean.ContractObject;
import bitel.billing.server.contract.object.bean.DateParamValue;
import bitel.billing.server.contract.object.bean.FlagParamValue;
import bitel.billing.server.contract.object.bean.ListParamValue;
import bitel.billing.server.contract.object.bean.ListValue;
import bitel.billing.server.contract.object.bean.ListValueManager;
import bitel.billing.server.contract.object.bean.ObjectParam;
import bitel.billing.server.contract.object.bean.ObjectType;
import bitel.billing.server.contract.object.bean.ObjectTypeManager;
import bitel.billing.server.contract.object.bean.ParamManager;
import bitel.billing.server.contract.object.bean.ParamValue;
import bitel.billing.server.contract.object.bean.ParamValueManager;
import bitel.billing.server.contract.object.bean.TextParamValue;
import bitel.billing.server.contract.object.bean.TypeParam;
import bitel.billing.server.contract.object.bean.TypeParamManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionChecker;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ObjectManager {
    private static final String TABLE_NAME = "object";
    private Connection con;

    public ObjectManager(Connection con) {
        this.con = con;
    }

    public ContractObject getObject(int id) {
        ContractObject result = null;
        try {
            String query = "SELECT * FROM object WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getObjectFromRs(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void findObjectList(SearchResult<ContractObject> searchResult, int cid, int typeId, String title) throws BGException {
        List<ContractObject> list = searchResult.getList();
        Page page = searchResult.getPage();
        try {
            StringBuilder query = new StringBuilder("SELECT SQL_CALC_FOUND_ROWS * FROM ").append(TABLE_NAME).append(" WHERE cid=").append(cid);
            if (typeId > 0) {
                query.append(" AND type_id=").append(typeId);
            }
            if (Utils.notBlankString(title)) {
                query.append(" AND title REGEXP ?");
            }
            query.append(" ORDER BY pos").append(page.sqlLimit());
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            if (Utils.notBlankString(title)) {
                ps.setString(1, title);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(this.getObjectFromRs(rs));
            }
            rs.close();
            ps.close();
            page.setRecordCount(ServerUtils.foundRows(this.con));
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public List<ContractObject> getObjectList(int cid) throws BGException {
        ArrayList<ContractObject> result = new ArrayList<ContractObject>();
        String query = "SELECT * FROM object WHERE cid=? ORDER BY pos";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getObjectFromRs(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return result;
    }

    public List<ContractObject> getActiveObjectList(int cid) {
        ArrayList<ContractObject> result = new ArrayList<ContractObject>();
        try {
            String query = "SELECT * FROM object WHERE cid=? AND ( date1<=NOW() OR date1 IS NULL ) AND ( isNULL(date2) OR date2 > NOW() ) ORDER BY pos";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getObjectFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ContractObject> getSuperObjectList(int cid, boolean showAll) {
        ArrayList<ContractObject> result = new ArrayList<ContractObject>();
        String query = null;
        query = showAll ? "SELECT o.* FROM object o, contract c WHERE (o.cid=c.id OR (o.cid=c.scid AND c.scid!=0 AND c.scid!=-1) ) AND c.id=? ORDER BY o.pos" : "SELECT o.* FROM object o, contract c WHERE (o.cid=c.id OR (o.cid=c.scid AND c.scid!=0 AND c.scid!=-1)) AND c.id=? AND (o.date1<=NOW() OR o.date1 IS NULL) AND (isNULL(o.date2) OR o.date2 > NOW()) ORDER BY o.pos";
        try {
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getObjectFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void deleteObject(int id) {
        try {
            String query = "DELETE FROM object WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void orderObject(int id, boolean up) {
        try {
            ContractObject o = this.getObject(id);
            String query = up ? "SELECT id, pos FROM object WHERE cid=? AND pos<? AND id!=? ORDER BY pos DESC LIMIT 1" : "SELECT id, pos FROM object WHERE cid=? AND pos>? AND id!=? ORDER BY pos ASC LIMIT 1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, o.getContractId());
            ps.setInt(2, o.getPos());
            ps.setInt(3, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                int contrObjectId = rs.getInt(1);
                int contrObjectPos = rs.getInt(2);
                ps.close();
                ps = this.con.prepareStatement("UPDATE object SET pos=? WHERE id=?");
                ps.setInt(1, o.getPos());
                ps.setInt(2, contrObjectId);
                ps.executeUpdate();
                ps.setInt(1, contrObjectPos);
                ps.setInt(2, id);
                ps.executeUpdate();
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateObject(ContractObject value) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (value.getId() <= 0) {
                query = "INSERT INTO object (title, date1, date2, cid, type_id) VALUES (?,?,?,?,?)";
                ps = this.con.prepareStatement(query, 1);
                ps.setInt(4, value.getContractId());
                ps.setInt(5, value.getTypeId());
            } else {
                query = "UPDATE object SET title=?, date1=?, date2=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(4, value.getId());
            }
            ps.setString(1, value.getTitle());
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate(value.getDate1()));
            ps.setDate(3, TimeUtils.convertCalendarToSqlDate(value.getDate2()));
            ps.executeUpdate();
            if (value.getId() <= 0) {
                value.setId(ServerUtils.lastInsertId(ps));
                ps.close();
                ps = this.con.prepareStatement("UPDATE object SET pos=? WHERE id=?");
                ps.setInt(1, value.getId());
                ps.setInt(2, value.getId());
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void moveObject(int id, int cidTo) {
        try {
            String query = "UPDATE object SET cid=? WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cidTo);
            ps.setInt(2, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ContractObject getObjectFromRs(ResultSet rs) throws SQLException {
        ContractObject result = new ContractObject();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("cid"));
        result.setTitle(rs.getString("title"));
        result.setTypeId(rs.getInt("type_id"));
        result.setDate1(TimeUtils.convertDateToCalendar(rs.getDate("date1")));
        result.setDate2(TimeUtils.convertDateToCalendar(rs.getDate("date2")));
        result.setPos(rs.getInt("pos"));
        return result;
    }

    @Deprecated
    public static void addObjectParams(Connection con, int objectId, Element table, ObjectType type) {
        ObjectManager.addObjectParams(con, objectId, table, type, 0);
    }

    public static void addObjectParams(Connection con, int objectId, Element table, ObjectType type, int userId) {
        Map<Integer, ListValue> listValuesMap = new ListValueManager(con).getValuesMap();
        Map<Integer, ObjectParam> paramMap = new ParamManager(con).getParamMap();
        List<TypeParam> typeParamList = new TypeParamManager(con).getTypeParamList(type.getId());
        Map<Integer, ParamValue> valuesMap = new ParamValueManager(con).getObjectParamMap(objectId);
        for (TypeParam typeParam : typeParamList) {
            ObjectParam objectParam = paramMap.get(typeParam.getParamId());
            if (objectParam == null) continue;
            Element row = XMLUtils.createElement(table, "row");
            row.setAttribute("param_id", String.valueOf(objectParam.getId()));
            row.setAttribute("type_id", String.valueOf(objectParam.getTypeId()));
            row.setAttribute("title", objectParam.getTitle());
            row.setAttribute("history", objectParam.isHistory() ? "loopa" : "loopa_fade");
            ParamValue value = valuesMap.get(objectParam.getId());
            boolean parameterAllowed = PermissionChecker.checkReadObjectParameter(objectParam.getId(), userId);
            if (parameterAllowed) {
                if (value == null) continue;
                switch (objectParam.getTypeId()) {
                    case 1: {
                        row.setAttribute("value", ((TextParamValue)value).getValue());
                        break;
                    }
                    case 5: {
                        row.setAttribute("value", String.valueOf(((FlagParamValue)value).getValue()));
                        break;
                    }
                    case 4: {
                        row.setAttribute("value", ((AddressParamValue)value).getAddress());
                        break;
                    }
                    case 3: {
                        row.setAttribute("value", TimeUtils.formatDate(((DateParamValue)value).getValue()));
                        break;
                    }
                    case 2: {
                        ListValue listValue = listValuesMap.get(((ListParamValue)value).getValue());
                        if (listValue != null) {
                            row.setAttribute("value", listValue.getTitle());
                            break;
                        }
                        row.setAttribute("value", "???");
                        break;
                    }
                }
                continue;
            }
            row.setAttribute("value", "<\u0421\u041a\u0420\u042b\u0422\u041e>");
        }
    }

    public static void addObjectParams(Connection con, int objectId, XMLStreamWriter table, ObjectType type) throws XMLStreamException {
        Map<Integer, ListValue> listValuesMap = new ListValueManager(con).getValuesMap();
        Map<Integer, ObjectParam> paramMap = new ParamManager(con).getParamMap();
        List<TypeParam> typeParamList = new TypeParamManager(con).getTypeParamList(type.getId());
        Map<Integer, ParamValue> valuesMap = new ParamValueManager(con).getObjectParamMap(objectId);
        for (TypeParam typeParam : typeParamList) {
            ParamValue value;
            ObjectParam objectParam = paramMap.get(typeParam.getParamId());
            if (objectParam == null || (value = valuesMap.get(objectParam.getId())) == null) continue;
            table.writeStartElement("row");
            table.writeAttribute("param_id", String.valueOf(objectParam.getId()));
            table.writeAttribute("type_id", String.valueOf(objectParam.getTypeId()));
            table.writeAttribute("title", objectParam.getTitle());
            switch (objectParam.getTypeId()) {
                case 1: {
                    table.writeAttribute("value", ((TextParamValue)value).getValue());
                    break;
                }
                case 5: {
                    table.writeAttribute("value", String.valueOf(((FlagParamValue)value).getValue()));
                    break;
                }
                case 4: {
                    table.writeAttribute("value", ((AddressParamValue)value).getAddress());
                    break;
                }
                case 3: {
                    table.writeAttribute("value", TimeUtils.formatDate(((DateParamValue)value).getValue()));
                    break;
                }
                case 2: {
                    ListValue listValue = listValuesMap.get(((ListParamValue)value).getValue());
                    if (listValue != null) {
                        table.writeAttribute("value", listValue.getTitle());
                        break;
                    }
                    table.writeAttribute("value", "???");
                    break;
                }
            }
            table.writeEndElement();
        }
    }

    public String getObjectParamTitle(int objectId, int paramId) {
        ContractObject object = new ObjectManager(this.con).getObject(objectId);
        ObjectParam objectParam = new ParamManager(this.con).getParam(paramId);
        Map<Integer, ParamValue> valuesMap = new ParamValueManager(this.con).getObjectParamMap(objectId);
        ParamValue value = valuesMap.get(paramId);
        if (object != null && objectParam != null && value != null) {
            switch (objectParam.getTypeId()) {
                case 1: {
                    return ((TextParamValue)value).getValue();
                }
                case 5: {
                    return String.valueOf(((FlagParamValue)value).getValue());
                }
                case 4: {
                    return ((AddressParamValue)value).getAddress();
                }
                case 3: {
                    return TimeUtils.formatDate(((DateParamValue)value).getValue());
                }
                case 2: {
                    Map<Integer, ListValue> listValuesMap = new ListValueManager(this.con).getValuesMap();
                    ListValue listValue = listValuesMap.get(((ListParamValue)value).getValue());
                    if (listValue != null) {
                        return listValue.getTitle();
                    }
                    return "???";
                }
            }
        }
        return null;
    }

    public void saveTitleByMacros(ContractObject object) throws BGMessageException {
        String generateTitle = this.generateTitle(object);
        if (!object.getTitle().equals(generateTitle)) {
            object.setTitle(generateTitle);
            this.updateObject(object);
        }
    }

    public String generateTitle(ContractObject object) throws BGMessageException {
        String title = object.getTitle();
        ObjectType type = new ObjectTypeManager(this.con).getType(object.getTypeId());
        if (type == null) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430!");
        }
        String macros = type.getNameMakros();
        if (Utils.isBlankString(macros)) {
            return title;
        }
        Pattern pattern = Pattern.compile("\\$\\{([\\w:]+)\\}");
        Matcher m = pattern.matcher(macros);
        StringBuffer result = new StringBuffer();
        int end = 0;
        while (m.find()) {
            int start = m.start();
            result.append(macros.substring(end, start));
            result.append(this.processMacros(m.group(1), type, object));
            end = m.end();
        }
        result.append(macros.substring(end, macros.length()));
        title = result.toString();
        return title;
    }

    private String processMacros(String macros, ObjectType type, ContractObject object) {
        int id;
        ListValue listValue;
        ListParamValue value;
        String result = "";
        ParamValueManager valueManager = new ParamValueManager(this.con);
        if (macros.equals("type")) {
            result = type.getTitle();
        } else if (macros.equals("id")) {
            result = String.valueOf(object.getId());
        } else if (macros.startsWith("address:")) {
            AddressParamValue value2 = valueManager.getAddressParamValue(object.getId(), this.getParamId(macros));
            if (value2 != null) {
                result = value2.getAddress();
            }
        } else if (macros.startsWith("date:")) {
            DateParamValue value3 = valueManager.getDateParamValue(object.getId(), this.getParamId(macros));
            if (value3 != null) {
                result = TimeUtils.formatDate(value3.getValue());
            }
        } else if (macros.startsWith("text:")) {
            TextParamValue value4 = valueManager.getTextParamValue(object.getId(), this.getParamId(macros));
            if (value4 != null) {
                result = value4.getValue();
            }
        } else if (macros.startsWith("list:") && (value = valueManager.getListParamValue(object.getId(), this.getParamId(macros))) != null && (listValue = new ListValueManager(this.con).getValue(id = value.getValue())) != null) {
            result = listValue.getTitle();
        }
        return result;
    }

    private int getParamId(String str) {
        int result = 0;
        int pos = str.indexOf(58);
        if (pos > 0 && pos < str.length() - 1) {
            result = Utils.parseInt(str.substring(pos + 1), 0);
        }
        return result;
    }
}

