/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.ext.dhcp;

import bitel.billing.common.IPUtils;
import bitel.billing.common.VersionInfo;
import bitel.billing.server.ext.dhcp.DHCPAdminSocketThread;
import bitel.billing.server.ext.dhcp.DHCPPacket;
import bitel.billing.server.ext.dhcp.DHCPProcessor;
import bitel.billing.server.ext.dhcp.DHCPSetup;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.DatagramChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.xml.serializer.ToXMLStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.bootstrap.Shutdown;

public class DHCPRelayProcessor
extends DHCPProcessor {
    private final Date startTime;
    protected byte option_82 = 0;
    protected int position_82 = 0;
    protected volatile Map<DHCPProcessor.DHCPIpAddress, DHCPGate> gateIpMap = new HashMap<DHCPProcessor.DHCPIpAddress, DHCPGate>();
    protected volatile Map<String, DHCPGate> gateIdMap = new HashMap<String, DHCPGate>();
    List<DHCPOptionSet> netOptions = new ArrayList<DHCPOptionSet>();
    private final TimerTask saveTask = new TimerTask(){

        @Override
        public synchronized void run() {
            try {
                File newFile = new File(DHCPRelayProcessor.this.setup.get("dhcp.data.save.path", "") + "dhcp.data.new");
                ToXMLStream stream = new ToXMLStream();
                stream.setOutputStream((OutputStream)new FileOutputStream(newFile));
                stream.setEncoding("UTF-8");
                stream.startDocument();
                stream.startElement("sync");
                for (DHCPGate gate : DHCPRelayProcessor.this.gateIdMap.values()) {
                    stream.startElement("gate");
                    stream.addAttribute("id", gate.id);
                    stream.addAttribute("host", DHCPRelayProcessor.this.convertIPToString(((DHCPGate)gate).address.address));
                    for (Map.Entry<Integer, Object> entry : gate.parameters.entrySet()) {
                        stream.startElement("param");
                        stream.addAttribute("id", (String)((Object)entry.getKey()));
                        stream.addAttribute("value", (String)entry.getValue());
                        stream.endElement("param");
                    }
                    stream.endElement("gate");
                }
                for (DHCPGate gate : DHCPRelayProcessor.this.gateIdMap.values()) {
                    for (Map.Entry<Integer, byte[]> entry : gate.clientIpMap.entrySet()) {
                        stream.startElement("port");
                        stream.addAttribute("gateId", gate.id);
                        stream.addAttribute("id", String.valueOf(entry.getKey()));
                        stream.addAttribute("ip", DHCPRelayProcessor.this.convertIPToString_x16(entry.getValue()));
                        stream.endElement("port");
                    }
                    for (Map.Entry<Integer, Object> entry : gate.clientPortMacIpMap.entrySet()) {
                        Map map = (Map)entry.getValue();
                        for (Map.Entry e2 : map.entrySet()) {
                            stream.startElement("portMac");
                            stream.addAttribute("gateId", gate.id);
                            stream.addAttribute("id", String.valueOf(entry.getKey()));
                            stream.addAttribute("ip", DHCPRelayProcessor.this.convertIPToString_x16((byte[])e2.getValue()));
                            stream.addAttribute("mac", (String)e2.getKey());
                            stream.endElement("portMac");
                        }
                    }
                }
                stream.endElement("sync");
                stream.getWriter().close();
                stream.close();
                File file = new File(DHCPRelayProcessor.this.setup.get("dhcp.data.save.path", "") + "dhcp.data");
                if (file.exists()) {
                    file.renameTo(new File(DHCPRelayProcessor.this.setup.get("dhcp.data.save.path", "") + "dhcp.data.old"));
                }
                newFile.renameTo(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public DHCPRelayProcessor(DHCPSetup setup, DatagramChannel channel) {
        super(setup, channel);
        this.startTime = new Date();
        log.info((Object)"Starting BGDhcpIPN (BGBilling DHCP server/gate for IPN)...");
    }

    @Override
    public void init() {
        super.init();
        Shutdown.addShutdownHook(this.saveTask);
        long delay = this.setup.getInt("dhcp.data.save.delay", 3600) * 1000;
        long period = this.setup.getInt("dhcp.data.save.period", 3600) * 1000;
        this.loadNetConfig();
        this.option_82 = (byte)this.setup.getInt("dhcp.82.key.option.code", 1);
        this.position_82 = this.setup.getInt("dhcp.82.key.position", 5);
        log.info((Object)("option_82=" + this.option_82));
        log.info((Object)("position_82=" + this.position_82));
        log.info((Object)("dhcp.data.save.delay=" + delay));
        log.info((Object)("dhcp.data.save.period=" + period));
        new Timer("saveDHCPDataThread", true).scheduleAtFixedRate(this.saveTask, delay, period);
        try {
            File file = new File(this.setup.get("dhcp.data.save.path", "") + "dhcp.data");
            if (file.exists()) {
                log.info((Object)"Load data from file.");
                XMLUtils.parseDocument(new InputSource(new FileInputStream(file)), new CommandHandler(System.out, null));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadNetConfig() {
        ParameterMap values = this.setup.sub("net.");
        for (Map.Entry<String, String> entry : values.entrySet()) {
            String longKey = entry.getKey();
            String key = longKey.substring(0, longKey.indexOf("."));
            Integer idx = Integer.valueOf(key);
            if (this.netOptions.size() < idx) {
                for (int i = this.netOptions.size(); i < idx; ++i) {
                    DHCPOptionSet set = new DHCPOptionSet();
                    this.netOptions.add(set);
                }
            }
            DHCPOptionSet set = this.netOptions.get(idx - 1);
            String suffix = longKey.substring(longKey.indexOf(".") + 1);
            set.parameters.put(suffix, entry.getValue());
        }
    }

    @Override
    public void processRequest(InetSocketAddress requestAddress, DHCPPacket request) {
        byte messageType = request.messageType;
        DHCPPacket.DHCPSubOption agentInformation = request.optionAgentInformation;
        log.debug((Object)"processing request");
        if (request.op == 1) {
            log.debug((Object)"OP_BOOT_REQUEST");
            if (agentInformation == null) {
                log.debug((Object)"agent information is not found");
                DHCPPacket.DHCPOption requestedIP = request.getOption((byte)50);
                DHCPPacket.DHCPOption serverIdentifier = request.getOption((byte)54);
                log.debug((Object)"trying to renew ip");
                if (messageType == 3 && requestedIP == null && serverIdentifier == null && !this.notFilled(request.ciaddr)) {
                    DHCPPacket response = request.createResponse();
                    DHCPProcessor.DHCPIpAddress ip = new DHCPProcessor.DHCPIpAddress(request.ciaddr);
                    response.setOption((byte)54, this.serverIdentifier);
                    if (this.renewingIP(ip, request, response, (DHCPProcessor.DHCPClientIdentifier)this.occupiedIPs.get(ip))) {
                        this.sendResponse(request, response);
                    }
                }
            } else {
                log.debug((Object)"agent information  found!");
                if (messageType == 3 || messageType == 1) {
                    log.debug((Object)"DHCP_REQUEST or  DHCP_DISCOVER");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("request.giaddr =" + IPUtils.convertIpToString(new DHCPProcessor.DHCPIpAddress((byte[])request.giaddr).addressInt)));
                    }
                    DHCPPacket response = request.createResponse();
                    DHCPGate gate = this.gateIpMap.get(new DHCPProcessor.DHCPIpAddress(request.giaddr));
                    if (gate != null) {
                        DHCPProcessor.DHCPClientIdentifier client;
                        DHCPProcessor.DHCPIpAddress ip;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("gateId = " + gate.id));
                        }
                        if ((ip = this.getIpAddress(gate, request, client = DHCPRelayProcessor.getDHCPClientIdentifier(request))) != null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("ip = " + IPUtils.convertIpToString(ip.addressInt)));
                            }
                            response.setOption((byte)54, this.serverIdentifier);
                            switch (messageType) {
                                case 1: {
                                    log.debug((Object)"DHCP_DISCOVER");
                                    response.messageType = (byte)2;
                                    this.offerIP(gate, ip, request, response, client);
                                    break;
                                }
                                case 3: {
                                    log.debug((Object)"DHCP_REQUEST");
                                    DHCPPacket.DHCPOption requestedIP = request.getOption((byte)50);
                                    if (requestedIP != null && !Arrays.equals(requestedIP.value, ip.address)) {
                                        log.info((Object)("requestedIP=" + IPUtils.convertIpToString(new DHCPProcessor.DHCPIpAddress((byte[])requestedIP.value).addressInt)));
                                        response.messageType = (byte)6;
                                        response.flags = FLAG_BROADCAST;
                                        break;
                                    }
                                    log.debug((Object)"DHCP_ACK");
                                    response.messageType = (byte)5;
                                    this.occupyIP(gate, ip, request, response, client);
                                    break;
                                }
                                default: {
                                    return;
                                }
                            }
                            this.sendResponse(request, response);
                        }
                    }
                }
            }
        }
    }

    protected DHCPProcessor.DHCPIpAddress getIpAddress(DHCPGate gate, DHCPPacket request, DHCPProcessor.DHCPClientIdentifier client) {
        int port = request.optionAgentInformation.getSubOption((byte)this.option_82).value[this.position_82] & 0xFF;
        log.debug((Object)("port=" + port));
        byte[] address = gate.clientIpMap.get(port);
        return address != null ? new DHCPProcessor.DHCPIpAddress(address) : null;
    }

    protected void setOptions(DHCPGate gate, DHCPPacket response, DHCPProcessor.DHCPIpAddress ip) {
        DHCPOptionSet optionSet = new DHCPOptionSet();
        optionSet.copyParams(gate);
        if (this.netOptions.size() > 0) {
            Long ipl = Utils.unsignedIntToLong(Utils.convertBytesToInt(ip.address));
            this.updateNetOption(ipl, optionSet);
        }
        this.updateOption(optionSet);
        if (response.parameterRequestListOption == null) {
            if (optionSet.ipAddressLeaseTime != null) {
                response.setOption((byte)51, optionSet.ipAddressLeaseTime);
            }
            if (optionSet.subnetMask != null) {
                response.setOption((byte)1, optionSet.subnetMask);
            }
            if (optionSet.domainNameServer != null) {
                response.setOption((byte)6, optionSet.domainNameServer);
            }
            if (optionSet.router != null) {
                response.setOption((byte)3, optionSet.router);
            }
            if (optionSet.domainName != null) {
                response.setOption((byte)15, optionSet.domainName);
            }
            if (optionSet.timeOffset != null) {
                response.setOption((byte)2, optionSet.timeOffset);
            }
        } else {
            if (optionSet.ipAddressLeaseTime != null) {
                response.setOption((byte)51, optionSet.ipAddressLeaseTime);
            }
            block8: for (int i = 0; i < response.parameterRequestListOption.length; ++i) {
                switch (response.parameterRequestListOption[i]) {
                    case 51: {
                        continue block8;
                    }
                    case 1: {
                        if (optionSet.subnetMask == null) continue block8;
                        response.setOption((byte)1, optionSet.subnetMask);
                        continue block8;
                    }
                    case 6: {
                        if (optionSet.domainNameServer == null) continue block8;
                        response.setOption((byte)6, optionSet.domainNameServer);
                        continue block8;
                    }
                    case 3: {
                        if (optionSet.router == null) continue block8;
                        response.setOption((byte)3, optionSet.router);
                        continue block8;
                    }
                    case 15: {
                        if (optionSet.domainName == null) continue block8;
                        response.setOption((byte)15, optionSet.domainName);
                        continue block8;
                    }
                    case 2: {
                        if (optionSet.timeOffset == null) continue block8;
                        response.setOption((byte)2, optionSet.timeOffset);
                        continue block8;
                    }
                    default: {
                        for (int j = 0; j < optionSet.options.length; ++j) {
                            if (optionSet.options[j].code != response.parameterRequestListOption[i]) continue;
                            response.setOption(optionSet.options[j]);
                        }
                    }
                }
            }
        }
    }

    private void updateNetOption(long ip, DHCPOptionSet gate) {
        DHCPOptionSet result = null;
        for (DHCPOptionSet opt : this.netOptions) {
            long mask;
            long ipNet = IPUtils.convertStringIPtoLong(opt.getParam("ip", "0.0.0.0"), 0L);
            int bits = Utils.parseInt(opt.getParam("bits", "0"), 0);
            if (ipNet <= 0L || bits <= 0 || (ip & (mask = 0xFFFFFFFFL << 32 - bits)) != (ipNet & mask)) continue;
            result = opt;
            break;
        }
        if (result != null) {
            gate.copyParams(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean occupyIP(DHCPGate gate, DHCPProcessor.DHCPIpAddress ip, DHCPPacket request, DHCPPacket response, DHCPProcessor.DHCPClientIdentifier client) {
        Map map = this.occupiedIPs;
        synchronized (map) {
            if (ip == null) {
                return false;
            }
            client.gateId = gate.id;
            this.occupiedIPs.put(ip, client);
            DHCPProcessor.OccupiedIP occupiedIP = new DHCPProcessor.OccupiedIP(ip, gate.ipAddressLeaseTimeLong + System.currentTimeMillis(), request.xid);
            this.occupiedIPQueue.remove(occupiedIP);
            this.occupiedIPQueue.offer(occupiedIP);
            response.yiaddr = ip.address;
            this.setOptions(gate, response, ip);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean renewingIP(DHCPProcessor.DHCPIpAddress ip, DHCPPacket request, DHCPPacket response, DHCPProcessor.DHCPClientIdentifier client) {
        Map map = this.occupiedIPs;
        synchronized (map) {
            if (ip == null || client == null) {
                return false;
            }
            DHCPGate gate = this.gateIdMap.get(client.gateId);
            if (gate == null) {
                return false;
            }
            this.occupiedIPs.put(ip, client);
            this.occupiedIPQueue.offer(new DHCPProcessor.OccupiedIP(ip, gate.ipAddressLeaseTimeLong + System.currentTimeMillis(), request.xid));
            response.yiaddr = ip.address;
            this.setOptions(gate, response, ip);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean offerIP(DHCPGate gate, DHCPProcessor.DHCPIpAddress ip, DHCPPacket request, DHCPPacket response, DHCPProcessor.DHCPClientIdentifier client) {
        Map map = this.occupiedIPs;
        synchronized (map) {
            if (ip == null) {
                return false;
            }
            this.occupiedIPs.put(ip, client);
            this.occupiedIPQueue.offer(new DHCPProcessor.OccupiedIP(ip, gate.ipAddressLeaseTimeLong + System.currentTimeMillis(), request.xid));
            response.yiaddr = ip.address;
            this.setOptions(gate, response, ip);
            return true;
        }
    }

    public synchronized void updateGates(DHCPGate root) {
        if (root != null) {
            int leaseTime = Utils.parseInt(root.getParam("dhcp.ipAddressLeaseTime", null), 43200);
            root.ipAddressLeaseTimeLong = leaseTime * 1000;
            root.ipAddressLeaseTime = Utils.convertIntToBytes(leaseTime);
            root.subnetMask = this.convertStringToIP4(root.getParam("dhcp.subnetMask", null));
            root.domainNameServer = this.convertStringToIP4List(root.getParam("dhcp.dns", null));
            root.router = this.convertStringToIP4List(root.getParam("dhcp.router", null));
            String domainName = root.getParam("dhcp.domain", null);
            if (domainName != null) {
                root.domainName = domainName.getBytes();
            }
            root.timeOffset = Utils.convertIntToBytes(Utils.parseInt(root.getParam("dhcp.timeOffset", null), 0));
            this.setGateParams(root);
        } else {
            log.warn((Object)"Null DHCPGate for update!");
        }
    }

    public synchronized void updateOption(DHCPOptionSet root) {
        if (root != null) {
            int leaseTime = Utils.parseInt(root.getParam("dhcp.ipAddressLeaseTime", null), 43200);
            root.ipAddressLeaseTimeLong = leaseTime * 1000;
            root.ipAddressLeaseTime = Utils.convertIntToBytes(leaseTime);
            root.subnetMask = this.convertStringToIP4(root.getParam("dhcp.subnetMask", null));
            root.domainNameServer = this.convertStringToIP4List(root.getParam("dhcp.dns", null));
            root.router = this.convertStringToIP4List(root.getParam("dhcp.router", null));
            String domainName = root.getParam("dhcp.domain", null);
            if (domainName != null) {
                root.domainName = domainName.getBytes();
            }
            root.timeOffset = Utils.convertIntToBytes(Utils.parseInt(root.getParam("dhcp.timeOffset", null), 0));
            ArrayList<DHCPPacket.DHCPOption> options = new ArrayList<DHCPPacket.DHCPOption>(5);
            for (Map.Entry<String, String> e : root.parameters.entrySet()) {
                String key = e.getKey();
                if (!key.startsWith("dhcp.option.")) continue;
                key = key.substring(12);
                try {
                    int code = Integer.parseInt(key);
                    DHCPPacket.DHCPOption option = new DHCPPacket.DHCPOption((byte)(code & 0xFF), new BigInteger(e.getValue(), 16).toByteArray());
                    options.add(option);
                }
                catch (Exception exception) {}
            }
            root.options = options.toArray(new DHCPPacket.DHCPOption[options.size()]);
        } else {
            log.warn((Object)"Null DHCPGate for update!");
        }
    }

    private void setGateParams(DHCPGate gate) {
        for (DHCPGate n : gate.children) {
            String domainName;
            DHCPGate parent;
            int leaseTime = Utils.parseInt(n.getParam("dhcp.ipAddressLeaseTime", null), 0);
            if (leaseTime > 0) {
                n.ipAddressLeaseTimeLong = leaseTime * 1000;
                n.ipAddressLeaseTime = Utils.convertIntToBytes(leaseTime);
            } else {
                while ((parent = n.parent) != null) {
                    if (parent.ipAddressLeaseTime == null) continue;
                    n.ipAddressLeaseTime = parent.ipAddressLeaseTime;
                    n.ipAddressLeaseTimeLong = parent.ipAddressLeaseTimeLong;
                    break;
                }
            }
            n.subnetMask = this.convertStringToIP4(n.getParam("dhcp.subnetMask", null));
            if (n.subnetMask == null) {
                while ((parent = n.parent) != null) {
                    if (parent.subnetMask == null) continue;
                    n.subnetMask = parent.subnetMask;
                    break;
                }
            }
            n.domainNameServer = this.convertStringToIP4List(n.getParam("dhcp.dns", null));
            if (n.domainNameServer == null) {
                while ((parent = n.parent) != null) {
                    if (parent.domainNameServer == null) continue;
                    n.domainNameServer = parent.domainNameServer;
                    break;
                }
            }
            n.router = this.convertStringToIP4List(n.getParam("dhcp.router", null));
            if (n.router == null) {
                while ((parent = n.parent) != null) {
                    if (parent.router == null) continue;
                    n.router = parent.router;
                    break;
                }
            }
            if ((domainName = n.getParam("dhcp.domain", null)) != null) {
                n.domainName = domainName.getBytes();
            } else {
                DHCPGate parent2;
                while ((parent2 = n.parent) != null) {
                    if (parent2.domainName == null) continue;
                    n.domainName = parent2.domainName;
                    break;
                }
            }
            this.setGateParams(n);
        }
    }

    public synchronized void setGate(DHCPGate _gate) {
        DHCPGate gate;
        if (log.isDebugEnabled()) {
            log.debug((Object)("set gate " + _gate.id + " " + this.convertIPToString(((DHCPGate)_gate).address.address)));
        }
        if ((gate = this.gateIdMap.get(_gate.id)) == null) {
            gate = _gate;
            HashMap<String, DHCPGate> gateIdMap = new HashMap<String, DHCPGate>(this.gateIdMap);
            HashMap<DHCPProcessor.DHCPIpAddress, DHCPGate> gateIpMap = new HashMap<DHCPProcessor.DHCPIpAddress, DHCPGate>(this.gateIpMap);
            gateIdMap.put(gate.id, gate);
            gateIpMap.put(gate.address, gate);
            this.gateIdMap = gateIdMap;
            this.gateIpMap = gateIpMap;
        } else {
            if (!gate.address.equals(_gate.address)) {
                gate.address = _gate.address;
                HashMap<DHCPProcessor.DHCPIpAddress, DHCPGate> gateIpMap = new HashMap<DHCPProcessor.DHCPIpAddress, DHCPGate>();
                for (DHCPGate n : this.gateIdMap.values()) {
                    gateIpMap.put(n.address, n);
                }
                this.gateIpMap = gateIpMap;
            }
            gate.copyParams(_gate);
        }
    }

    public String setGatePortIp(String gateId, int port, byte[] address) {
        DHCPGate gate;
        log.info((Object)("setGatePortIp:  gateId =   " + gateId + ";port=" + port + ";adress=" + IPUtils.convertIpToString(Utils.convertBytesToInt(address))));
        if (port >= 0 && address != null && (gate = this.gateIdMap.get(gateId)) != null) {
            gate.clientIpMap.put(port, address);
            return null;
        }
        log.warn((Object)("Bad port or ip to gateId=" + gateId));
        return "error\n";
    }

    public String setGatePortMac(String gateId, int port, byte[] address, String mac) {
        DHCPGate gate;
        log.info((Object)("setGatePortMacIp:  gateId =   " + gateId + ";port=" + port + ";adress=" + IPUtils.convertIpToString(Utils.convertBytesToInt(address)) + ";mac=" + mac));
        if (mac != null && port >= 0 && address != null && (gate = this.gateIdMap.get(gateId)) != null) {
            Map<String, byte[]> map = gate.clientPortMacIpMap.get(port);
            if (map == null) {
                map = new HashMap<String, byte[]>();
                gate.clientPortMacIpMap.put(port, map);
            }
            map.put(mac, address);
            return null;
        }
        log.warn((Object)("Bad port or ip to gateId or mac=" + gateId));
        return "error\n";
    }

    public String removeGatePortIp(String gateId, int port, byte[] address) {
        DHCPGate gate;
        log.info((Object)("removeGatePortIp:  gateId =   " + gateId + ";port=" + port + ";adress=" + IPUtils.convertIpToString(Utils.convertBytesToInt(address))));
        if (port >= 0 && address != null && (gate = this.gateIdMap.get(gateId)) != null) {
            gate.clientIpMap.remove(port);
            gate.clientPortMacIpMap.remove(port);
            return null;
        }
        log.warn((Object)("Bad port or ip to gateId=" + gateId));
        return "error\n";
    }

    @Override
    public void adminCommand(DHCPAdminSocketThread thread) {
        log.debug((Object)"admin command ");
        XMLUtils.parseDocument(new InputSource(thread.getIn()), new CommandHandler(thread.getOut(), thread.getSocket()));
    }

    private class CommandHandler
    extends DefaultHandler {
        private final Socket socket;
        private final PrintWriter out;
        private String answer = "ok";
        private int deep = 0;
        private boolean stop = false;
        private boolean gates = false;
        private DHCPGate root;
        private DHCPGate current;

        public CommandHandler(OutputStream out, Socket socket) {
            this.socket = socket;
            this.out = new PrintWriter(out);
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            block10: {
                try {
                    --this.deep;
                    switch (this.deep) {
                        case 1: {
                            if (!this.stop && "gates".equals(qName)) {
                                this.gates = false;
                                DHCPRelayProcessor.this.updateGates(this.root);
                                break;
                            }
                            if (this.stop || !"gate".equals(qName)) break;
                            DHCPRelayProcessor.this.updateOption(this.current);
                            DHCPRelayProcessor.this.setGate(this.current);
                            this.current = null;
                            break;
                        }
                        default: {
                            if (this.stop || this.deep <= 1 || !this.gates || !"gate".equals(qName)) break;
                            this.current = this.current.parent;
                        }
                    }
                    if (this.deep != 0) break block10;
                    PrintWriter pw = new PrintWriter(this.out);
                    pw.println(this.answer);
                    pw.flush();
                    try {
                        if (this.socket != null) {
                            this.socket.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (this.stop) {
                        System.exit(0);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            try {
                switch (this.deep) {
                    case 0: {
                        if ("stop".equals(qName)) {
                            this.answer = "ok";
                            DHCPProcessor.log.info((Object)"Admin command: stop.");
                            this.stop = true;
                            break;
                        }
                        if (!"status".equals(qName)) break;
                        VersionInfo vi = VersionInfo.getVersionInfo("ipn.dhcp");
                        StringBuilder status = new StringBuilder();
                        status.append("BGDhcpIPN v ");
                        status.append(vi.getVersionString());
                        status.append("\n");
                        status.append(ServerUtils.uptimeStatus(DHCPRelayProcessor.this.startTime));
                        status.append("\n");
                        status.append(Utils.memoryStatus());
                        status.append("\n");
                        this.answer = status.toString();
                        DHCPProcessor.log.info((Object)"Admin command: status.");
                        break;
                    }
                    case 1: {
                        if (!this.stop && "gates".equals(qName)) {
                            this.gates = true;
                            break;
                        }
                        if ("port".equals(qName)) {
                            DHCPRelayProcessor.this.setGatePortIp(attrs.getValue("gateId"), Utils.parseInt(attrs.getValue("id"), -1), DHCPRelayProcessor.this.convertStringToIP4_x16(attrs.getValue("ip")));
                            break;
                        }
                        if ("portMac".equals(qName)) {
                            DHCPRelayProcessor.this.setGatePortMac(attrs.getValue("gateId"), Utils.parseInt(attrs.getValue("id"), -1), DHCPRelayProcessor.this.convertStringToIP4_x16(attrs.getValue("ip")), attrs.getValue("mac"));
                            break;
                        }
                        if ("removePort".equals(qName)) {
                            DHCPRelayProcessor.this.removeGatePortIp(attrs.getValue("gateId"), Utils.parseInt(attrs.getValue("id"), -1), DHCPRelayProcessor.this.convertStringToIP4_x16(attrs.getValue("ip")));
                            break;
                        }
                        if ("list".equals(qName)) {
                            try {
                                DHCPGate gate = DHCPRelayProcessor.this.gateIdMap.get(attrs.getValue("gateId"));
                                if (gate != null) {
                                    for (Map.Entry<Integer, byte[]> e : gate.clientIpMap.entrySet()) {
                                        this.out.print(e.getKey());
                                        this.out.print('\t');
                                        this.out.print(DHCPRelayProcessor.this.convertIPToString(e.getValue()));
                                        this.out.println();
                                    }
                                }
                                this.out.println();
                                this.out.flush();
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                            break;
                        }
                        if ("listGates".equals(qName)) {
                            try {
                                for (DHCPGate gate : DHCPRelayProcessor.this.gateIdMap.values()) {
                                    this.out.print(gate.id);
                                    this.out.print('\t');
                                    this.out.print(DHCPRelayProcessor.this.convertIPToString(((DHCPGate)gate).address.address));
                                    this.out.println();
                                }
                                this.out.println();
                                this.out.flush();
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                            break;
                        }
                        if (this.stop || !"gate".equals(qName)) break;
                        DHCPGate gate = new DHCPGate();
                        gate.parent = this.current;
                        gate.id = attrs.getValue("id");
                        gate.address = new DHCPProcessor.DHCPIpAddress(DHCPRelayProcessor.this.convertStringToIP(attrs.getValue("host")));
                        gate.parameters = new HashMap();
                        gate.children = new ArrayList<DHCPGate>(0);
                        this.current = gate;
                        break;
                    }
                    case 2: {
                        if (this.stop || this.current == null || !"param".equals(qName)) break;
                        this.current.parameters.put(attrs.getValue("id"), attrs.getValue("value"));
                        break;
                    }
                    default: {
                        if (!this.stop && this.deep > 1 && this.gates && "gate".equals(qName)) {
                            DHCPGate gate = new DHCPGate();
                            gate.parent = this.current;
                            gate.id = attrs.getValue("id");
                            gate.address = new DHCPProcessor.DHCPIpAddress(Utils.convertIntToBytes(IPUtils.convertStringIPtoInt(attrs.getValue("host"))));
                            gate.parameters = new HashMap();
                            gate.children = new ArrayList<DHCPGate>();
                            if (this.current != null) {
                                this.current.children.add(gate);
                            }
                            this.current = gate;
                            if (this.root != null) break;
                            this.root = this.current;
                            break;
                        }
                        if (this.stop || this.deep <= 2 || !this.gates || this.current == null || !"param".equals(qName)) break;
                        this.current.parameters.put(attrs.getValue("id"), attrs.getValue("value"));
                    }
                }
                ++this.deep;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected static class DHCPOptionSet {
        protected byte[] ipAddressLeaseTime;
        protected long ipAddressLeaseTimeLong;
        protected byte[] subnetMask;
        protected byte[] domainNameServer;
        protected byte[] router;
        protected byte[] domainName;
        protected byte[] timeOffset;
        protected Map<String, String> parameters = new HashMap<String, String>();
        protected DHCPPacket.DHCPOption[] options;

        protected DHCPOptionSet() {
        }

        protected String getParam(String name, String def) {
            String result = this.parameters.get(name);
            return result != null ? result : def;
        }

        public void copyParams(DHCPOptionSet set) {
            for (Map.Entry<String, String> entry : set.parameters.entrySet()) {
                this.parameters.put(entry.getKey(), entry.getValue());
            }
        }
    }

    protected static class DHCPGate
    extends DHCPOptionSet {
        private String id;
        private DHCPProcessor.DHCPIpAddress address;
        protected ConcurrentHashMap<Integer, byte[]> clientIpMap = new ConcurrentHashMap();
        protected ConcurrentHashMap<Integer, Map<String, byte[]>> clientPortMacIpMap = new ConcurrentHashMap();
        protected DHCPGate parent;
        protected List<DHCPGate> children;

        protected DHCPGate() {
        }
    }
}

