/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.installer;

import bitel.billing.common.VersionInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.ftp.FTPClient;
import ru.bitel.common.Utils;

public class FtpClient {
    protected VersionInfo serverVersionInfo = VersionInfo.getVersionInfo("server");
    protected FTPClient ftp;
    protected Path tmpDirPath = null;
    protected String updateUrl = null;
    protected Map<String, FileInfo> ftpFiles = new HashMap<String, FileInfo>();

    public FtpClient(String set) {
        this.updateUrl = System.getProperty("update.url", "ftp://ftp.bgbilling.ru/pub/bgbilling");
        try {
            this.tmpDirPath = Files.createTempDirectory("BGBillingServer", new FileAttribute[0]);
            this.tmpDirPath.toFile().deleteOnExit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.connect(set);
        this.getFileList();
    }

    private void connect(String set) {
        System.out.println("Update starting...");
        System.out.println("Update from " + this.updateUrl);
        String serverVersion = this.serverVersionInfo.getVersion();
        if (Utils.isBlankString(serverVersion)) {
            System.err.println("ERROR: Can't take BGBilling server version, exiting");
            System.exit(1);
        }
        System.out.println("Server version is " + serverVersion);
        if (set != null && !set.startsWith("sets/")) {
            set = "sets/" + set;
        }
        URI uri = URI.create(this.updateUrl.concat("/").concat(serverVersion).concat(set != null ? "/".concat(set) : ""));
        this.ftp = new FTPClient();
        if (uri.getPort() > 0) {
            this.ftp.setDefaultPort(uri.getPort());
        }
        try {
            this.ftp.connect(uri.getHost());
            if (System.getProperty("bginstaller.update.ftp.mode", "passive").equals("passive")) {
                this.ftp.enterLocalPassiveMode();
                System.out.println("Set passive mode...");
            } else {
                this.ftp.enterLocalActiveMode();
                System.out.println("Set active mode...");
            }
            this.ftp.login("anonymous", "");
            this.ftp.setFileType(2);
            System.out.println("Changing dir to " + uri.getPath());
            if (!this.ftp.changeWorkingDirectory(uri.getPath())) {
                throw new Exception("not change to " + uri.getPath());
            }
        }
        catch (Exception e) {
            System.err.println("ERROR connect");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void getFileList() {
        Pattern pattern = Pattern.compile("^(\\w+)_([\\d\\.]+)_(\\d+)\\.zip$");
        try {
            String[] files;
            for (String file : files = this.ftp.listNames()) {
                Matcher m = pattern.matcher(file);
                if (!m.find()) continue;
                String name = m.group(1);
                FileInfo fi = new FileInfo();
                fi.build = m.group(3);
                fi.fullName = file;
                this.ftpFiles.put(name, fi);
            }
        }
        catch (Exception e) {
            System.err.println("ERROR get file list");
            e.printStackTrace();
            System.exit(1);
        }
    }

    protected void downloadFile(String fileName) throws IOException {
        System.out.print("Downloading " + fileName);
        Path tmpFilePath = Paths.get(this.tmpDirPath.toString(), fileName);
        try (OutputStream os = Files.newOutputStream(tmpFilePath, new OpenOption[0]);){
            this.ftp.retrieveFile(fileName, os);
        }
        System.out.println(" OK");
    }

    protected static class FileInfo {
        public String build;
        public String fullName;

        protected FileInfo() {
        }
    }
}

