/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.radius;

import bitel.billing.server.radius.RadiusManager;
import bitel.billing.server.radius.RadiusSetup;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class AdminPortListener
extends Thread {
    private Logger log = Logger.getLogger(AdminPortListener.class);
    private RadiusManager manager;
    private int port = 0;
    private ServerSocket server;

    public AdminPortListener(RadiusSetup setup, int port, RadiusManager manager) {
        this.port = port;
        this.manager = manager;
        this.initSocket();
        this.start();
    }

    private void initSocket() {
        try {
            this.server = new ServerSocket(this.port);
        }
        catch (Exception ex) {
            this.log.error((Object)("Port " + this.port + " is busy!!! [" + ex.getMessage() + "]"));
            System.exit(0);
        }
    }

    @Override
    public void run() {
        this.log.info((Object)("Starting AdminPortListener on " + this.port));
        while (true) {
            try {
                while (true) {
                    Socket socket = this.server.accept();
                    new AdminPortThread(socket);
                }
            }
            catch (Exception ex) {
                this.log.error((Object)ex.getMessage());
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    private final class AdminPortThread
    extends Thread {
        private final Socket socket;
        private final BufferedReader br;
        private final PrintWriter out;

        public AdminPortThread(Socket socket) throws Exception {
            this.socket = socket;
            this.br = ServerUtils.getSocketIn(socket);
            this.out = ServerUtils.getSocketOut(socket);
            this.setDaemon(true);
            this.start();
        }

        private void doCommand(String cmd) {
            String command = cmd;
            String params = "";
            int pos = cmd.indexOf(" ");
            if (pos > 0) {
                command = cmd.substring(0, pos);
                params = cmd.substring(pos + 1, cmd.length());
            }
            String result = AdminPortListener.this.manager.executeCommand(command, params);
            StringTokenizer st = new StringTokenizer(result, "\n");
            while (st.hasMoreTokens()) {
                this.out.println(st.nextToken());
            }
        }

        @Override
        public void run() {
            try {
                StringBuilder command = new StringBuilder();
                String line = this.br.readLine();
                command.append(line);
                command.append("\n");
                if ("set_levels".equals(line)) {
                    while (!Utils.isBlankString(line = this.br.readLine())) {
                        command.append(line);
                        command.append("\n");
                    }
                }
                String cmd = command.toString().trim();
                this.doCommand(cmd);
                this.socket.close();
                if (cmd.equals("stop")) {
                    System.exit(0);
                }
            }
            catch (Exception ex) {
                AdminPortListener.this.log.error((Object)ex.getMessage());
                ex.printStackTrace();
            }
        }
    }
}

