/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.util.exslt;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.common.Utils;

public class Counter {
    private Map<String, BigDecimal> values = new HashMap<String, BigDecimal>();

    public void set(String name, String value) {
        this.values.put(name, Utils.parseBigDecimal(value, BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP));
    }

    public void add(String name, String value) {
        BigDecimal currentValue = this.values.get(name);
        if (currentValue == null) {
            currentValue = BigDecimal.ZERO.setScale(2);
        }
        currentValue = currentValue.add(Utils.parseBigDecimal(value, BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP));
        this.values.put(name, currentValue);
    }

    public String get(String name) {
        BigDecimal result = this.values.get(name);
        if (result == null) {
            result = BigDecimal.ZERO;
        }
        return result.toPlainString();
    }

    public void minus(String name, String value) {
        BigDecimal currentValue = this.values.get(name);
        if (currentValue == null) {
            currentValue = BigDecimal.ZERO.setScale(2);
        }
        currentValue = currentValue.add(Utils.parseBigDecimal(value, BigDecimal.ZERO).negate().setScale(2, RoundingMode.HALF_UP));
        this.values.put(name, currentValue);
    }

    public void mult(String name, String value) {
        BigDecimal currentValue = this.values.get(name);
        if (currentValue == null) {
            currentValue = BigDecimal.ZERO;
        }
        currentValue = currentValue.multiply(Utils.parseBigDecimal(value, BigDecimal.ZERO).setScale(2, RoundingMode.HALF_UP));
        this.values.put(name, currentValue);
    }
}

