/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.service;

import bitel.billing.server.admin.bgsecure.bean.GroupManager;
import bitel.billing.server.admin.bgsecure.bean.UserGroupManager;
import bitel.billing.server.admin.bgsecure.bean.UserPermitionsManager;
import bitel.billing.server.contract.bean.ContractUtils;
import java.sql.SQLException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jws.WebService;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.UserService;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.module.common.bean.BGSAction;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.bean.UserManager;
import ru.bitel.bgbilling.kernel.module.server.event.ModulesChangedEvent;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.bgsecure.common.service.UserService")
public class UserServiceImpl
extends AbstractService
implements UserService {
    private static final Logger logger = Logger.getLogger(UserServiceImpl.class);
    private UserManager userManager;

    @PostConstruct
    public void init() throws BGException {
        this.userManager = new UserManager(this.getConnection());
    }

    @Override
    public String getCurrentUserEmail() throws BGException {
        String email = null;
        User user = (User)this.userManager.get(this.userId);
        if (user != null) {
            email = user.getEmail();
        }
        return email;
    }

    @Override
    public SearchResult<User> findUsers(String field, String value, int status, int groupId, Page page) throws BGException {
        SearchResult<User> searchResult = new SearchResult<User>();
        searchResult.setPage(page);
        searchResult.setAttribute("field", field);
        searchResult.setAttribute("value", value);
        searchResult.setAttribute("status", String.valueOf(status));
        searchResult.setAttribute("groupId", String.valueOf(groupId));
        this.userManager.findSearchResult(searchResult);
        ContractUtils contractUtils = new ContractUtils(this.getConnection());
        for (User user : searchResult.getList()) {
            user.setUserGroups(new UserGroupManager(this.getConnection()).getUserGroups(user.getId()));
            user.setContractTitle(contractUtils.getContractTitle(user.getContractCid(), false, null));
        }
        return searchResult;
    }

    @Override
    public void deleteUser(int userId) throws BGException {
        this.userManager.delete(userId);
        new GroupManager(this.getConnection()).deleteUserGroup(userId);
    }

    @Override
    public User getUser(int userId) throws BGException {
        User user = (User)this.userManager.get(userId);
        user.setUserGroups(new UserGroupManager(this.getConnection()).getUserGroups(userId));
        user.setActionList(new UserPermitionsManager(this.getConnection()).getUserActions(userId));
        ContractUtils cu = new ContractUtils(this.getConnection());
        user.setContractTitle(cu.getContractTitle(user.getContractCid(), false, null));
        return user;
    }

    @Override
    public void updateUser(User user, List<Integer> groups) throws BGException {
        if (user.getId() < -1 || user.getLogin() == null || user.getName() == null || user.getDescription() == null) {
            throw new BGIllegalArgumentException();
        }
        try {
            if (this.userManager.checkLogin(user.getLogin(), user.getId())) {
                throw new BGMessageException("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \"" + user.getLogin() + "\" - \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
            }
            this.userManager.update(user);
            new UserGroupManager(this.getConnection()).updateUserGroups(user.getId(), groups);
            new UserPermitionsManager(this.getConnection()).updateUserActions(user.getId(), user.getActionList());
            this.getConnection().commit();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        UserMap.initUserMap(this.getConnection());
        this.context.publishAfterCommit(new ModulesChangedEvent(this.context.getUserId(), true));
    }

    @Override
    public List<User> listUsers() throws BGException {
        return this.userManager.list();
    }

    @Override
    public UserInfo userInfoGet(int userId) {
        try {
            return this.context.getDirectory(UserInfo.class, 0).get(userId);
        }
        catch (BGException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<UserInfo> userInfoList() {
        try {
            return this.context.getDirectory(UserInfo.class, 0).list();
        }
        catch (BGException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<BGSAction> loadUserActions(int userId) throws BGException {
        return new UserPermitionsManager(this.getConnection()).getUserActions(userId);
    }

    @PreDestroy
    private void destroy() {
        try {
            if (this.userManager != null) {
                this.userManager.close();
                this.userManager = null;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

