/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.label.server.service;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jws.WebService;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.label.common.bean.ContractLabelItem;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService")
public class ContractLabelServiceImpl
extends AbstractService
implements ContractLabelService {
    @Override
    public List<ContractLabelItem> getContractLabelTreeItemList(int contractId, boolean calcCount) throws BGException {
        ContractLabelManager contractLabelManager = new ContractLabelManager(this.getConnection());
        List<ContractLabelItem> contractLabelItems = contractLabelManager.getContractLabelItemList(calcCount);
        if (contractId > 0) {
            Set<Integer> contractLabelSet = contractLabelManager.getContractLabelIds(contractId);
            for (ContractLabelItem contractLabelItem : contractLabelItems) {
                contractLabelItem.setSelected(contractLabelSet.contains(contractLabelItem.getId()));
            }
        }
        return contractLabelItems;
    }

    @Override
    public void setContractLabelTreeItemList(int contractId, List<ContractLabelItem> items) throws BGException {
        HashSet<Integer> labelIds = new HashSet<Integer>();
        if (items != null) {
            for (ContractLabelItem contractLabelItem : items) {
                labelIds.add(contractLabelItem.getId());
            }
        }
        new ContractLabelManager(this.getConnection()).setContractLabelIds(contractId, labelIds);
    }

    @Override
    public int updateContractLabelTreeItem(ContractLabelItem contractLabelItem) throws BGException {
        new ContractLabelManager(this.getConnection()).updateContractLabelTreeItem(contractLabelItem);
        return contractLabelItem != null ? contractLabelItem.getId() : -1;
    }

    @Override
    public void removeContractLabelTreeItem(int contractLabelItemId) throws BGException {
        new ContractLabelManager(this.getConnection()).removeContractLabelItem(contractLabelItemId);
    }

    @Override
    public ContractLabelItem getContractLabelTree() throws BGException {
        return new ContractLabelManager(this.getConnection()).getTree();
    }

    @Override
    public void syncLabelAndGroupDirectory() throws BGException {
        try {
            Statement st = this.getConnection().createStatement();
            st.executeUpdate("DELETE FROM contract_label WHERE id < 100");
            st.close();
            st = this.getConnection().createStatement();
            st.executeUpdate("INSERT INTO contract_label ( id, parent_id, title ) SELECT id+2, 1, title FROM contract_group WHERE enable=1");
            st.close();
        }
        catch (Exception e) {
            Logger.getLogger(ContractLabelServiceImpl.class).error((Object)e);
            throw new BGException(e);
        }
    }

    @Override
    public void syncLabelAndGroupContract() throws BGException {
        try {
            Statement st = this.getConnection().createStatement();
            st.executeUpdate("DELETE FROM contract_label_link WHERE label_id < 66");
            st.close();
            PreparedStatement psInsert = this.getConnection().prepareStatement("INSERT INTO contract_label_link SET contract_id=?, label_id=?");
            st = this.getConnection().createStatement();
            ResultSet rs = st.executeQuery("SELECT id, gr FROM contract WHERE gr > 0");
            while (rs.next()) {
                psInsert.setInt(1, rs.getInt(1));
                long gr = rs.getLong(2);
                for (int pos = 0; pos < 64; ++pos) {
                    if ((gr & 1L << pos) <= 0L) continue;
                    psInsert.setInt(2, pos + 2);
                    psInsert.executeUpdate();
                }
            }
            rs.close();
            st.close();
            psInsert.close();
        }
        catch (Exception e) {
            Logger.getLogger(ContractLabelServiceImpl.class).error((Object)e);
            throw new BGException(e);
        }
    }
}

