/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.flow;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.kernel.network.flow.SFlowRecord;

public class SFlowArray
extends FlowArray<SFlowRecord> {
    private static Logger logger = Logger.getLogger(SFlowArray.class);

    public SFlowArray(int size) {
        super(SFlowArray.create(size));
    }

    private static final List<SFlowRecord> create(int size) {
        if (size <= 0) {
            size = 8192;
        }
        ArrayList<SFlowRecord> recordList = new ArrayList<SFlowRecord>(size);
        for (int i = 0; i < size; ++i) {
            SFlowRecord rec = new SFlowRecord();
            recordList.add(rec);
        }
        return recordList;
    }

    private SFlowRecord get(int index) {
        try {
            return ((SFlowRecord[])this.array)[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Expand SFlowArray: " + ((SFlowRecord[])this.array).length + " => " + ((SFlowRecord[])this.array).length * 2));
            }
            SFlowRecord[] recs = new SFlowRecord[((SFlowRecord[])this.array).length * 2];
            System.arraycopy(this.array, 0, recs, 0, ((SFlowRecord[])this.array).length);
            int size = recs.length;
            for (int i = ((SFlowRecord[])this.array).length; i < size; ++i) {
                recs[i] = new SFlowRecord();
            }
            this.array = recs;
            return ((SFlowRecord[])this.array)[index];
        }
    }

    /*
     * Exception decompiling
     */
    public final boolean parsePacket(ByteBuffer data, long millis) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 10[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int next(ByteBuffer data) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Parsing sFlow");
        }
        int arrayOffset = 0;
        int bufferLimit = data.limit() - 1;
        int offset = data.position();
        try {
            while (offset < bufferLimit) {
                long milliseconds = data.getLong();
                int sFlowVersion = data.getInt();
                int ipVersion = data.getInt();
                if (sFlowVersion != 5 && sFlowVersion != 4) {
                    logger.error((Object)("Incompatible sFlow version: " + sFlowVersion));
                    offset = bufferLimit + 1;
                    break;
                }
                if (ipVersion != 1) {
                    logger.error((Object)"sFlow packet parse, can't work with this IP version(6?)");
                    offset = bufferLimit + 1;
                    break;
                }
                data.getInt();
                if (sFlowVersion >= 5) {
                    data.getInt();
                }
                data.getInt();
                data.getInt();
                long samplesCount = (long)data.getInt() & 0xFFFFFFFFL;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("samples: " + samplesCount));
                }
                block7: for (long sampleNum = 0L; sampleNum < samplesCount; ++sampleNum) {
                    int formatSampleData = data.getInt();
                    int sampleLength = data.getInt();
                    switch (formatSampleData) {
                        case 1: 
                        case 3: {
                            logger.debug((Object)"Flow Sample");
                            int lim = data.limit();
                            data.limit(data.position() + sampleLength);
                            data.position(data.position() - 8);
                            ByteBuffer bb = data.slice();
                            data.position(data.limit());
                            data.limit(lim);
                            SFlowRecord flow = ((SFlowRecord[])this.array)[arrayOffset++];
                            flow.sFlowVersion = sFlowVersion;
                            flow.fillData(bb);
                            flow.setMilliseconds(milliseconds);
                            continue block7;
                        }
                        case 2: 
                        case 4: {
                            logger.debug((Object)"Counter Sample");
                            data.position(data.position() + sampleLength);
                        }
                    }
                }
                offset = data.position();
            }
            this.size = arrayOffset;
        }
        catch (BufferUnderflowException ex) {
            logger.error((Object)("sFlow packet parse, " + ex.getMessage() + "; pos=" + data.position()), (Throwable)ex);
            throw ex;
        }
        return offset;
    }
}

