/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.mikrotik;

import bitel.billing.server.util.AbstractSession;
import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;
import me.legrange.mikrotik.ApiConnection;
import me.legrange.mikrotik.ApiConnectionException;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.network.mikrotik.AnonymousSocketFactory;

public class MikrotikApiSession
extends AbstractSession
implements AutoCloseable {
    private static Logger logger = Logger.getLogger(MikrotikApiSession.class);
    private String login = null;
    private String pswd = null;
    private ApiConnection con = null;
    private String lastIds = null;
    private boolean useSSL;

    public MikrotikApiSession(String host, int port, String login, String pswd) {
        this(host, port, login, pswd, null, 0);
    }

    public MikrotikApiSession(String host, int port, String login, String pswd, String sourceHost, int sourcePort) {
        this(host, port, login, pswd, sourceHost, sourcePort, false);
    }

    public MikrotikApiSession(String host, int port, String login, String pswd, String sourceHost, int sourcePort, boolean useSSL) {
        super(host, port, sourceHost, sourcePort);
        this.login = login;
        this.pswd = pswd;
        this.useSSL = useSSL;
    }

    @Override
    public String doCommand(String command) throws Exception {
        this.lastIds = null;
        List result = this.con.execute(command);
        StringBuffer resultStr = new StringBuffer();
        StringBuilder lastIds = new StringBuilder();
        for (Map map : result) {
            String id = (String)map.get(".id");
            if (lastIds.length() > 0) {
                lastIds.append(",");
            }
            lastIds.append(id);
            resultStr.append("entity id = " + id + "\n");
            map.entrySet().forEach(e -> resultStr.append((String)e.getKey() + "=" + (String)e.getValue() + "\n"));
        }
        this.lastIds = lastIds.toString();
        return resultStr.toString();
    }

    @Override
    public String connect() throws Exception {
        this.con = this.useSSL ? ApiConnection.connect((SocketFactory)AnonymousSocketFactory.getDefault(), (String)this.host, (int)this.port, (int)this.timeout) : ApiConnection.connect((SocketFactory)SocketFactory.getDefault(), (String)this.host, (int)this.port, (int)this.timeout);
        if (!this.con.isConnected()) {
            throw new BGException("not connected");
        }
        this.con.login(this.login, this.pswd);
        return "success";
    }

    @Override
    public void disconnect() throws BGException {
        try {
            this.con.close();
        }
        catch (ApiConnectionException e) {
            logger.error((Object)"error while closing", (Throwable)e);
        }
    }

    @Override
    public void close() throws Exception {
        this.disconnect();
    }

    public String getLastIds() {
        return this.lastIds;
    }
}

