/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius;

import bitel.billing.server.call.bean.Login;
import bitel.billing.server.card.bean.Card;
import bitel.billing.server.card.bean.CardManager;
import bitel.billing.server.card.bean.CardSeriesManager;
import bitel.billing.server.contract.bean.BalanceUtils;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractService;
import bitel.billing.server.contract.bean.ContractServiceManager;
import bitel.billing.server.radius.RadiusSetup;
import bitel.billing.server.tariff.TariffTreesCache;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.LocalEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractCreatedEvent;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.RadiusSession;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasList;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

public abstract class AbstractRadiusProcessor<C extends NasConnection<?>, N extends Nas<C, ?, ?>, P>
extends RadiusProcessor<C, N, P> {
    private static final Logger logger = Logger.getLogger(AbstractRadiusProcessor.class);
    private final boolean checkService;
    private Date startTime = new Date();

    public AbstractRadiusProcessor(RadiusSetup setup, String module, int mid, NasList<C, N> nasList) throws BGException {
        super(setup, module, mid, nasList);
        this.checkService = setup.getInt("check.service", 0) > 0;
    }

    protected void checkLoginAndContract(Login login, Contract contract) {
        if (login == null) {
            logger.error((Object)"Login is null!!!");
        } else if (contract == null) {
            logger.error((Object)"Contract is null!!!");
        } else {
            if (login.getId() <= 0) {
                logger.error((Object)"Login id <= 0!");
            }
            if (contract.getId() <= 0) {
                logger.error((Object)"Contract id <= 0");
            }
            if (contract.getTitle() == null) {
                logger.error((Object)"Contract title is NULL!");
            }
        }
    }

    protected int executeError(Connection con, N nas, RadiusPacket request, RadiusPacket response, int cid, int lid, int errorCode, int log_record_id) {
        response.setStringAttribute(-1, 18, String.valueOf(errorCode));
        String query = null;
        PreparedStatement ps = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMM");
            String table_name = "log_error_" + String.valueOf(this.moduleId) + "_" + dateFormat.format(new GregorianCalendar().getTime());
            this.checkErrorTable(con, table_name);
            query = "INSERT INTO " + table_name + " (dt, cid, lid, login, nas_id, nas_port, error_code, log_rec_id) VALUES  ( NOW(), ?, ?, ?, ?, ?, ?, ? )";
            ps = con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, lid);
            ps.setString(3, request.getStringAttribute(-1, 1, "<null>"));
            ps.setInt(4, ((Nas)nas).getId());
            ps.setString(5, String.valueOf(request.getIntAttribute(-1, 5, -1)));
            ps.setInt(6, errorCode);
            ps.setInt(7, log_record_id);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return errorCode;
    }

    private void checkErrorTable(Connection con, String table_name) throws SQLException {
        String query = "CREATE TABLE " + table_name + "( dt datetime, cid int, lid int,  login char(50), nas_id int, nas_port char(30), error_code int not null, log_rec_id int not null, KEY dt (dt), KEY cid (cid), KEY lid (lid), KEY nas_id (nas_id) )";
        this.setup.checkAndCreatePeriodicTableName(con, table_name, query);
    }

    protected abstract Login getLogin(N var1, RadiusPacket var2, RadiusPacket var3, Connection var4, String var5);

    protected abstract Login getLogin(Connection var1, int var2, Card var3);

    @Override
    protected void accessRequestImpl(RadiusListenerWorker<N> req, N nas, RadiusPacket request, RadiusPacket response, Date date, RadiusSession<N, P> radiusSession, int logRecordId, ConnectionSet connectionSet) {
        super.accessRequestImpl(req, nas, request, response, date, radiusSession, logRecordId, connectionSet);
        byte result = response.getCode();
        if ((result == 2 || result == 3) && radiusSession.login != null && radiusSession.contract != null) {
            try {
                EventProcessor.getInstance().request(this.newRadiusAuthenticationEvent(request, response, radiusSession, logRecordId));
            }
            catch (BGException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected abstract LocalEvent newRadiusAuthenticationEvent(RadiusPacket var1, RadiusPacket var2, RadiusSession<N, P> var3, int var4);

    @Override
    protected int authentication(RadiusListenerWorker<?> req, N nas, RadiusSession<N, P> session, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int log_record_id) {
        return this.authenticationImpl(req, nas, session, request, response, connectionSet, log_record_id, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int authenticationImpl(RadiusListenerWorker<?> req, N nas, RadiusSession<N, P> session, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int log_record_id, boolean realtimeTariff) {
        Connection con = connectionSet.getConnection();
        Login login = null;
        Contract contract = null;
        boolean authOk = false;
        int errorCode = 0;
        String userName = session.userName;
        int cardModuleId = this.setup.getInt("card.module.id", -1);
        ContractManager contrM = new ContractManager(con);
        logger.debug((Object)"Finding login..");
        AbstractRadiusProcessor abstractRadiusProcessor = this;
        synchronized (abstractRadiusProcessor) {
            login = this.getLogin(nas, request, response, con, userName);
            if (login != null) {
                contract = contrM.getContractById(login.getCid());
                authOk = true;
                logger.debug((Object)("Login found: " + login.getId()));
            } else if (login == null && cardModuleId > 0) {
                logger.debug((Object)"Find in cards");
                CardManager cm = new CardManager(con, cardModuleId);
                Card card = null;
                long topNocardLogin = this.setup.getLong("top.nocard.login", 100000L);
                long longUserName = Utils.parseLong(userName);
                if (longUserName > 0L && longUserName > topNocardLogin) {
                    card = cm.findCard(userName);
                }
                if (card == null) {
                    logger.debug((Object)"Card not found");
                    errorCode = 14;
                } else {
                    logger.debug((Object)"Card found, checking..");
                    if (!card.checkPeriod(new Date())) {
                        logger.debug((Object)"Card expired");
                        errorCode = 8;
                    } else if (card.getStatus() == 0) {
                        logger.debug((Object)"Card lock");
                        errorCode = 9;
                    } else if (card.getStatus() == 3) {
                        logger.debug((Object)"Card activated for balance");
                        errorCode = 10;
                    } else if (!((Nas)nas).canActivateCard(card)) {
                        logger.debug((Object)"Cant't activate card at this NAS");
                        errorCode = 17;
                    } else {
                        boolean pinResultOK = session.checkPassword((Nas<?, ?, ?>)nas, request, response, card.getCardPinCode(), ((Nas)nas).getSecret(), request.authenticator);
                        if (!pinResultOK) {
                            logger.debug((Object)"Card error [ bad pin-code ]");
                            errorCode = 1;
                        } else {
                            authOk = true;
                        }
                    }
                    if (card != null && authOk) {
                        if (card.getStatus() == 1) {
                            HashMap<String, Object> titleParams = new HashMap<String, Object>(4);
                            CardSeriesManager csm = new CardSeriesManager(con, cardModuleId);
                            String cs = csm.getSeriesTitle(card.getSeriesId());
                            titleParams.put("card", card.getCardCode());
                            titleParams.put("card_series", cs);
                            try {
                                contract = contrM.createFromPattern(card.getPatternId(), null, new GregorianCalendar(), card.getCardPinCode(), titleParams, true, 0, 0);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            card.setContractId(contract.getId());
                            try {
                                cm.addCardToContract(con, (Calendar)new GregorianCalendar(), card, contract.getId());
                                cm.activated(card, 2);
                                EventProcessor.getInstance().request(new ContractCreatedEvent(contract));
                                login = this.getLogin(con, contract.getId(), card);
                                authOk = true;
                            }
                            catch (BGException e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                                authOk = false;
                            }
                        } else if (card.getStatus() == 2 && card.getType() == 1) {
                            contract = contrM.getContractById(card.getContractId());
                            login = this.getLogin(con, contract.getId(), card);
                            authOk = true;
                        } else {
                            errorCode = 8;
                            authOk = false;
                        }
                    }
                }
            } else {
                authOk = false;
                errorCode = 14;
            }
        }
        if (authOk) {
            this.checkLoginAndContract(login, contract);
        }
        if (authOk) {
            logger.debug((Object)"Checking access allow...");
            if (!login.getStatus()) {
                logger.debug((Object)"Login access deny...");
                errorCode = 26;
                authOk = false;
            }
        }
        if (authOk) {
            session.login = login;
            logger.debug((Object)"Checking password...");
            if (!session.checkPassword((Nas<?, ?, ?>)nas, request, response, login.getPswd(), ((Nas)nas).getSecret(), request.authenticator)) {
                logger.debug((Object)"Login password error");
                errorCode = 2;
                authOk = false;
            }
        }
        if (authOk) {
            logger.debug((Object)"Checking contract status");
            if (!StatusCache.getInstance().isModuleActiveStatus(this.moduleId, contract.getStatus())) {
                logger.debug((Object)"Contract not open...");
                errorCode = 33;
                authOk = false;
            }
        }
        if (authOk) {
            boolean checkBalanceLast = this.setup.getBoolean("check.balance.last", false);
            if (!checkBalanceLast) {
                boolean bl = authOk = (errorCode = this.checkBalance(con, contract, errorCode)) == 0;
                if (authOk) {
                    errorCode = this.authorization(req, nas, session, request, response, connectionSet, log_record_id, contrM, contract, login, userName);
                    authOk = errorCode == 0;
                }
            } else {
                errorCode = this.authorization(req, nas, session, request, response, connectionSet, log_record_id, contrM, contract, login, userName);
                boolean bl = authOk = errorCode == 0;
                if (authOk) {
                    boolean bl2 = authOk = (errorCode = this.checkBalance(con, contract, errorCode)) == 0;
                }
            }
        }
        if (errorCode != 0) {
            int cid = contract != null ? contract.getId() : 0;
            int lid = login != null ? login.getId() : 0;
            this.executeError(con, nas, request, response, cid, lid, errorCode, log_record_id);
        }
        if (session != null) {
            session.contract = contract;
            session.login = login;
            session.errorCode = errorCode;
        }
        return errorCode;
    }

    private int checkBalance(Connection con, Contract contract, int errorCode) {
        logger.debug((Object)"Checking balance...");
        BalanceUtils bu = new BalanceUtils(con);
        BigDecimal summa = bu.getBalance(new Date(), contract.getId());
        BigDecimal limit = contract.getBalanceLimit();
        bu.close();
        if (summa.compareTo(limit) < 0) {
            errorCode = 4;
        }
        return errorCode;
    }

    protected boolean checkService(Connection con, int cid, Set<Integer> sidSet) {
        boolean result = false;
        if (!this.checkService) {
            result = true;
        } else {
            logger.debug((Object)"Checking services...");
            try {
                ContractServiceManager csManager = new ContractServiceManager(con);
                List<ContractService> csList = csManager.getContractServiceList(cid, new GregorianCalendar());
                for (ContractService cs : csList) {
                    sidSet.remove(cs.getServiceId());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            boolean bl = result = sidSet.size() == 0;
            if (!result && logger.isDebugEnabled()) {
                logger.debug((Object)"Not all services allowed...");
                for (Integer sid : sidSet) {
                    logger.debug((Object)sid);
                }
            }
        }
        return result;
    }

    protected void addCommonStatusData(StringBuilder report) {
        report.append("\n");
        report.append(ServerUtils.uptimeStatus(this.startTime));
        report.append("\n");
        report.append(Utils.memoryStatus());
        report.append("\n");
        report.append("Trees in cache: ");
        report.append(TariffTreesCache.getCache().getCacheStatus());
        report.append("\n");
        report.append(this.setup.getPoolStatus());
    }
}

