/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.tree.server;

import java.util.Set;
import ru.bitel.bgbilling.kernel.tariff.tree.server.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TreeContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.ThreadContext;

public class ContractGroupsTariffTreeNode
extends TariffTreeNode<AbstractTariffRequest<AbstractTariffRequest.ServiceCost>, TariffContext, TreeContext, ThreadContext> {
    private final long contractGroups;
    private final boolean modeOr;

    public ContractGroupsTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.contractGroups = Utils.enumToMask(parameterMap.get("contractGroups", ""));
        this.modeOr = parameterMap.getInt("mode", 0) == 0;
    }

    @Override
    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, AbstractTariffRequest<AbstractTariffRequest.ServiceCost> req, TariffContext context, TreeContext treeContext, ThreadContext workerContext) {
        if (this.contractGroups == 0L) {
            Set<Long> acceptedSet = req.getAcceptedSet(ContractGroupsTariffTreeNode.class);
            if (!acceptedSet.contains(parentTreeNodeId)) {
                acceptedSet.add(parentTreeNodeId);
                return 1;
            }
            return 0;
        }
        if (this.modeOr ? (this.contractGroups & req.contractGroups) == 0L : (this.contractGroups & req.contractGroups) != req.contractGroups) {
            return 0;
        }
        Set<Long> acceptedSet = req.getAcceptedSet(ContractGroupsTariffTreeNode.class);
        acceptedSet.add(parentTreeNodeId);
        return 1;
    }
}

