/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.tree.server;

import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.tariff.tree.server.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TariffTreeNodeHolder;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TreeContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.ThreadContext;

public class DynamicTariffTreeNode
extends TariffTreeNode<AbstractTariffRequest<?>, TariffContext, TreeContext, ThreadContext> {
    private static final Logger logger = Logger.getLogger(DynamicTariffTreeNode.class);
    private static final Class<?>[] types = new Class[]{Integer.TYPE, ParameterMap.class};
    private final String className;
    private final TariffTreeNode<AbstractTariffRequest<?>, TariffContext, TreeContext, ThreadContext> node;

    public DynamicTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.className = parameterMap.get("className", "");
        TariffTreeNode node = null;
        try {
            if (Utils.notBlankString(this.className)) {
                node = DynamicClassManager.getInstance().newInstance(TariffTreeNode.class, this.className, types, new Object[]{id, parameterMap});
            }
        }
        catch (BGException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.node = node;
    }

    @Override
    public int execute(Long treeNodeId, Long parentTreeNodeId, AbstractTariffRequest<?> req, TariffTreeNodeHolder holder, TariffContext ctx, TreeContext treeContext, ThreadContext workerContext) {
        if (this.node != null) {
            return this.node.execute(treeNodeId, parentTreeNodeId, req, holder, ctx, treeContext, workerContext);
        }
        return 0;
    }

    @Override
    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, AbstractTariffRequest<?> req, TariffContext context, TreeContext treeContext, ThreadContext workerContext) {
        throw new UnsupportedOperationException();
    }
}

