/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.tree.server;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.tariff.server.event.TariffTreeModifiedEvent;
import ru.bitel.bgbilling.kernel.tariff.tree.server.AbstractTariffTreeBuilder;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TariffModuleTree;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;

public class TariffTreeCache
extends AbstractTariffTreeBuilder {
    private static final Logger logger = Logger.getLogger(TariffTreeCache.class);
    private static final TariffTreeCache instance = new TariffTreeCache();
    private final ConcurrentMap<Integer, ConcurrentMap<Integer, SoftReference<TariffModuleTreeRef>>> treeModuleMap = new ConcurrentHashMap<Integer, ConcurrentMap<Integer, SoftReference<TariffModuleTreeRef>>>();

    public static TariffTreeCache getInstance() {
        return instance;
    }

    private TariffTreeCache() {
        new Thread("tree-cache-reload"){

            @Override
            public void run() {
                try {
                    EventProcessor.getInstance().addListener(new EventListener<TariffTreeModifiedEvent>(){

                        @Override
                        public void notify(final TariffTreeModifiedEvent e, final EventListenerContext ctx) throws BGException {
                            new Thread("tree-cache-reload"){

                                @Override
                                public void run() {
                                    ServerContext context = new ServerContext(ctx.getSetup(), 0, 0);
                                    ServerContext.push(context);
                                    try {
                                        TariffTreeCache.this.reloadTree(e.getModuleId(), e.getTreeId());
                                    }
                                    finally {
                                        ServerContext.pop(context, null);
                                    }
                                }
                            }.start();
                        }
                    }, TariffTreeModifiedEvent.class);
                }
                catch (BGException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadTree(int moduleId, int treeId) {
        Connection con = Setup.getSetup().getDBConnectionFromPool();
        try {
            ConcurrentMap moduleMap;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Reload tree in cache, moduleId: " + moduleId + "; treeId: " + treeId));
            }
            if ((moduleMap = (ConcurrentMap)this.treeModuleMap.get(treeId)) != null) {
                SoftReference treeRefRef = (SoftReference)moduleMap.get(moduleId);
                TariffModuleTreeRef treeRef = null;
                if (treeRefRef != null && (treeRef = (TariffModuleTreeRef)treeRefRef.get()) != null) {
                    TariffModuleTree tree = this.loadTariffModuleTree(con, treeId, moduleId, treeRef.module);
                    treeRef.set(tree);
                }
            }
        }
        catch (BGException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtomicReference<TariffModuleTree> getModuleTree(Connection con, int treeId, int mid, String module) {
        AtomicReference treeRef;
        ConcurrentMap moduleMap = this.treeModuleMap.computeIfAbsent(treeId, key -> new ConcurrentHashMap());
        SoftReference treeRefRef = (SoftReference)moduleMap.get(mid);
        if (treeRefRef != null && (treeRef = (AtomicReference)treeRefRef.get()) != null) {
            return treeRef;
        }
        ConcurrentMap concurrentMap = moduleMap;
        synchronized (concurrentMap) {
            AtomicReference treeRef2;
            treeRefRef = (SoftReference)moduleMap.get(mid);
            if (treeRefRef != null && (treeRef2 = (AtomicReference)treeRefRef.get()) != null) {
                return treeRef2;
            }
            treeRef2 = null;
            try {
                TariffModuleTree tree = this.loadTariffModuleTree(con, treeId, mid, module);
                if (tree == null) {
                    logger.debug((Object)("Node not found: " + treeId + "; moduleId: " + mid));
                }
                treeRef2 = new TariffModuleTreeRef(module, tree);
                moduleMap.put(mid, new SoftReference<AtomicReference>(treeRef2));
            }
            catch (BGException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return treeRef2;
        }
    }

    final class TariffModuleTreeRef
    extends AtomicReference<TariffModuleTree> {
        final String module;

        public TariffModuleTreeRef(String module, TariffModuleTree initialValue) {
            super(initialValue);
            this.module = module.intern();
        }
    }
}

