/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import ru.bitel.common.Utils;
import ru.bitel.common.io.Base64InputStream;
import ru.bitel.common.io.Base64OutputStream;

public class Base64 {
    static String CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    static char PAD = (char)61;

    public static String encode(String str) throws RuntimeException {
        byte[] bytes = str.getBytes();
        byte[] encoded = Base64.encode(bytes);
        return new String(encoded, StandardCharsets.US_ASCII);
    }

    public static String encode(String str, String charset) throws RuntimeException {
        byte[] bytes;
        try {
            bytes = str.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported charset: " + charset, e);
        }
        byte[] encoded = Base64.encode(bytes);
        return new String(encoded, StandardCharsets.US_ASCII);
    }

    public static String decode(String str) throws RuntimeException {
        byte[] bytes = str.getBytes(StandardCharsets.US_ASCII);
        byte[] decoded = Base64.decode(bytes);
        return new String(decoded);
    }

    public static String decode(String str, String charset) throws RuntimeException {
        byte[] bytes = str.getBytes(StandardCharsets.US_ASCII);
        byte[] decoded = Base64.decode(bytes);
        try {
            return new String(decoded, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported charset: " + charset, e);
        }
    }

    public static byte[] encode(byte[] bytes) throws RuntimeException {
        return Base64.encode(bytes, 0);
    }

    public static byte[] encode(byte[] bytes, int wrapAt) throws RuntimeException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            Base64.encode(inputStream, outputStream, wrapAt);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected I/O error", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {}
            try {
                outputStream.close();
            }
            catch (Throwable throwable) {}
        }
        return outputStream.toByteArray();
    }

    public static byte[] decode(byte[] bytes) throws RuntimeException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            Base64.decode(inputStream, outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected I/O error", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {}
            try {
                outputStream.close();
            }
            catch (Throwable throwable) {}
        }
        return outputStream.toByteArray();
    }

    public static void encode(InputStream inputStream, OutputStream outputStream) throws IOException {
        Base64.encode(inputStream, outputStream, 0);
    }

    public static void encode(InputStream inputStream, OutputStream outputStream, int wrapAt) throws IOException {
        Base64OutputStream aux = new Base64OutputStream(outputStream, wrapAt);
        Utils.flush(inputStream, aux);
        aux.flushbuffer();
    }

    public static void decode(InputStream inputStream, OutputStream outputStream) throws IOException {
        Utils.flush(new Base64InputStream(inputStream), outputStream);
    }

    public static String encode(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            Base64.encode(inputStream, outputStream);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Throwable throwable) {}
        }
        return outputStream.toString();
    }

    public static String encodeWeb(String base64) {
        return base64.replace('+', '-').replace('/', '_');
    }

    public static String decodeWeb(String base64web) {
        return base64web.replace('-', '+').replace('_', '/');
    }
}

