/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.ref;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import ru.bitel.common.ref.ReferenceCollection;

abstract class ReferenceValueConcurrentHashMap<K, V>
implements ConcurrentMap<K, V> {
    protected final ConcurrentHashMap<K, Reference<V>> map;
    protected final ReferenceQueue<V> queue;
    private EntrySet entrySet = null;

    ReferenceValueConcurrentHashMap(ConcurrentHashMap<K, Reference<V>> map) {
        this.map = map;
        this.queue = new ReferenceQueue();
    }

    public ReferenceValueConcurrentHashMap(int initialCapacity, float loadFactor) {
        this(new ConcurrentHashMap(initialCapacity, loadFactor));
    }

    public ReferenceValueConcurrentHashMap(int initialCapacity) {
        this(new ConcurrentHashMap(initialCapacity));
    }

    public ReferenceValueConcurrentHashMap() {
        this(new ConcurrentHashMap());
    }

    protected abstract Reference<V> newReference(K var1, V var2);

    protected void clean() {
        ReferenceValue ref;
        while ((ref = (ReferenceValue)((Object)this.queue.poll())) != null) {
            this.map.remove(ref.getKey(), ref);
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        Reference<V> ref = this.map.get(key);
        if (ref != null) {
            return ref.get() != null;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet(this.map.entrySet()));
    }

    @Override
    public V get(Object key) {
        Reference<V> ref = this.map.get(key);
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public V put(K key, V value) {
        this.clean();
        return this.put0(key, value);
    }

    private V put0(K key, V value) {
        Reference<V> oldRef = this.map.put(key, this.newReference(key, value));
        if (oldRef != null) {
            V v = oldRef.get();
            if (v != null) {
                return v;
            }
            return null;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.clean();
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put0(e.getKey(), e.getValue());
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Reference<V> oldRef;
        this.clean();
        Reference<V> newRef = this.newReference(key, value);
        while ((oldRef = this.map.putIfAbsent(key, newRef)) != null) {
            V v = oldRef.get();
            if (v != null) {
                return v;
            }
            if (this.map.replace(key, oldRef, newRef)) {
                return null;
            }
            this.clean();
        }
        return null;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.map.remove(key, value);
    }

    @Override
    public V remove(Object key) {
        Reference<V> ref = this.map.remove(key);
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.map.replace(key, this.newReference(key, oldValue), this.newReference(key, newValue));
    }

    @Override
    public V replace(K key, V value) {
        Reference<V> ref = this.map.replace(key, this.newReference(key, value));
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public int size() {
        this.clean();
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        return new ReferenceCollection<V>(this.map.values());
    }

    @Override
    public boolean equals(Object o) {
        this.clean();
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        this.clean();
        return this.map.hashCode();
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final Set<Map.Entry<K, Reference<V>>> entrySet;

        EntrySet(Set<Map.Entry<K, Reference<V>>> entrySet) {
            this.entrySet = entrySet;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this.entrySet.iterator());
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object v = ReferenceValueConcurrentHashMap.this.get(e.getKey());
            return v != null && v.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ReferenceValueConcurrentHashMap.this.remove(e.getKey(), e.getValue());
        }

        @Override
        public int size() {
            return ReferenceValueConcurrentHashMap.this.size();
        }

        @Override
        public void clear() {
            ReferenceValueConcurrentHashMap.this.clear();
        }
    }

    final class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, Reference<V>>> iterator;
        private WriteThroughEntry next;

        public EntryIterator(Iterator<Map.Entry<K, Reference<V>>> iterator) {
            this.iterator = iterator;
            this.advance();
        }

        private void advance() {
            while (this.iterator.hasNext()) {
                Object v;
                Reference ref;
                Map.Entry next = this.iterator.next();
                if (next == null || (ref = next.getValue()) == null || (v = ref.get()) == null) continue;
                this.next = new WriteThroughEntry(next.getKey(), v);
                return;
            }
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            WriteThroughEntry result = this.next;
            this.advance();
            return result;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    final class WriteThroughEntry
    extends AbstractMap.SimpleEntry<K, V> {
        WriteThroughEntry(K k, V v) {
            super(k, v);
        }

        @Override
        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Object v = super.setValue(value);
            ReferenceValueConcurrentHashMap.this.put(this.getKey(), value);
            return v;
        }
    }

    static interface ReferenceValue<K> {
        public K getKey();
    }
}

