/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.sql;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.sql.ConnectionSet;

final class SetupConnectionSet
extends ConnectionSet {
    private static final Logger logger = Logger.getLogger(SetupConnectionSet.class);
    private final DefaultServerSetup setup;

    public SetupConnectionSet(DefaultServerSetup setup, boolean autoCommit) {
        this(setup, null, autoCommit);
    }

    public SetupConnectionSet(DefaultServerSetup setup, Connection master, boolean autoCommit) {
        super(master, autoCommit);
        this.setup = setup;
        this.autoCommit = autoCommit;
    }

    @Override
    protected Connection newMasterConnection() {
        return this.setup.getDBConnectionFromPool(this.autoCommit);
    }

    @Override
    protected Connection newSlaveConnection() {
        return this.setup.getDBSlaveConnectionFromPool(this.getConnection());
    }

    @Override
    protected Connection newTrashConnection(String tableName) {
        Connection result = this.setup.getDBTrashConnectionFromPool(tableName, -1);
        try {
            if (result != null && result.getAutoCommit() != this.autoCommit) {
                result.setAutoCommit(this.autoCommit);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return result;
    }
}

