/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.mail.internet.MimeUtility;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ru.bitel.common.Utils;

public class FileDownload {
    public static String getContentDisposition(HttpServletRequest request, String fileName, boolean isInline) throws IOException {
        String contentDisposition;
        block10: {
            if (fileName == null) {
                throw new NullPointerException("Value of the \"filename\" parameter cannot be null!");
            }
            contentDisposition = isInline ? "inline; " : "attachment; ";
            String agent = request.getHeader("USER-AGENT").toLowerCase();
            if (agent == null) {
                contentDisposition = contentDisposition + "filename=" + FileDownload.transliterationFileName(fileName);
            } else if (agent.indexOf("opera") != -1) {
                try {
                    int version;
                    int startIndex;
                    int stopIndex;
                    int prefixIndex = agent.indexOf("opera ");
                    if (prefixIndex < 0) {
                        prefixIndex = agent.indexOf("opera/");
                    }
                    if ((stopIndex = agent.indexOf(".", startIndex = prefixIndex + 6)) == -1) {
                        stopIndex = agent.indexOf(" ", startIndex);
                    }
                    if ((version = Integer.valueOf(agent.substring(startIndex, stopIndex)).intValue()) >= 9) {
                        contentDisposition = contentDisposition + "filename*=utf8''" + FileDownload.toHexString(fileName);
                        break block10;
                    }
                    contentDisposition = contentDisposition + "filename=" + FileDownload.transliterationFileName(fileName);
                }
                catch (Exception e) {
                    contentDisposition = contentDisposition + "filename=" + FileDownload.transliterationFileName(fileName);
                }
            } else {
                contentDisposition = agent.indexOf("msie") != -1 ? contentDisposition + "filename=\"" + FileDownload.toHexString(fileName) + "\"" : (agent.indexOf("chrome") != -1 ? contentDisposition + "filename=\"" + FileDownload.toHexString(fileName) + "\"" : (agent.indexOf("safari") != -1 ? contentDisposition + "filename=" + FileDownload.transliterationFileName(fileName) : (agent.indexOf("firefox") != -1 ? contentDisposition + "filename=\"" + MimeUtility.encodeText((String)fileName, (String)"utf8", (String)"B") + "\"" : contentDisposition + "filename=" + FileDownload.transliterationFileName(fileName))));
            }
        }
        return contentDisposition;
    }

    private static String toHexString(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '\u0000' && c <= '\u00ff' && !Character.isWhitespace(c)) {
                sb.append(c);
                continue;
            }
            byte[] b2 = Character.toString(c).getBytes(StandardCharsets.UTF_8);
            for (int j = 0; j < b2.length; ++j) {
                int k = b2[j];
                if (k < 0) {
                    k += 256;
                }
                sb.append("%" + Integer.toHexString(k).toUpperCase());
            }
        }
        return sb.toString();
    }

    public static String transliterationFileName(String filename) {
        StringBuilder sb = new StringBuilder(filename.length());
        for (char symbol : filename.toCharArray()) {
            sb.append(Character.isWhitespace(symbol) ? (char)'_' : symbol);
        }
        filename = sb.toString();
        filename = Utils.toTranslit(filename);
        return filename;
    }

    public static void doTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String body = "\u0428\u0438\u0440\u043e\u043a\u0430\u044f \u044d\u043b\u0435\u043a\u0442\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f \u044e\u0436\u043d\u044b\u0445 \u0433\u0443\u0431\u0435\u0440\u043d\u0438\u0439 \u0434\u0430\u0441\u0442 \u043c\u043e\u0449\u043d\u044b\u0439 \u0442\u043e\u043b\u0447\u043e\u043a \u043f\u043e\u0434\u044a\u0451\u043c\u0443 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430.";
        response.setHeader("Content-Disposition", FileDownload.getContentDisposition(request, "\u0440\u0443\u0441\u0441\u043a\u0438\u0439 \u0439\u0430\u0437\u044b\u043a\u044a.txt", false));
        ServletOutputStream out = response.getOutputStream();
        out.write(body.getBytes("utf-8"));
        out.write(13);
        out.write(10);
        out.write(request.getHeader("USER-AGENT").getBytes());
        out.close();
    }

    public static boolean bcsrch(char[] chars, char c) {
        int len = chars.length;
        int base = 0;
        int last = len - 1;
        while (last >= base) {
            int p = base + (last - base >> 1);
            if (c == chars[p]) {
                return true;
            }
            if (c < chars[p]) {
                last = p - 1;
                continue;
            }
            base = p + 1;
        }
        return false;
    }

    public static String rfc5987_encode(String s) {
        byte[] s_bytes = s.getBytes(StandardCharsets.UTF_8);
        int len = s_bytes.length;
        StringBuilder sb = new StringBuilder(len << 1);
        char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] attr_char = new char[]{'!', '#', '$', '&', '\'', '+', '-', '.', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '^', '_', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '|', '~'};
        for (int i = 0; i < len; ++i) {
            byte b2 = s_bytes[i];
            if (FileDownload.bcsrch(attr_char, (char)b2)) {
                sb.append((char)b2);
                continue;
            }
            char[] encoded = new char[]{'%', '\u0000', '\u0000'};
            encoded[1] = digits[0xF & b2 >>> 4];
            encoded[2] = digits[b2 & 0xF];
            sb.append(encoded);
        }
        return sb.toString();
    }
}

