/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.worker;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerThread;

public class WorkerThreadFactory<C extends ThreadContext>
implements ThreadFactory,
ThreadContextFactory<C> {
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    protected final ThreadGroup group;
    protected final AtomicInteger threadNumber = new AtomicInteger(1);
    protected final String namePrefix;
    protected final String nestedContext;
    protected final ThreadContextFactory<C> contextFactory;

    public WorkerThreadFactory(String name, String nestedContext, ThreadContextFactory<C> contextFactory) {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.nestedContext = nestedContext;
        this.namePrefix = (name != null ? name + "-" : "worker-") + "p-" + poolNumber.getAndIncrement() + "-t-";
        this.contextFactory = contextFactory;
    }

    protected final String getNextThreadName() {
        return this.namePrefix + this.threadNumber.getAndIncrement();
    }

    protected WorkerThread<C> init(WorkerThread<C> t) {
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }

    @Override
    public WorkerThread<C> newThread(Runnable r) {
        return this.init(new WorkerThread<C>(this.group, r, this.getNextThreadName(), 0L, this.nestedContext, this.newThreadContext()));
    }

    @Override
    public C newThreadContext() {
        if (this.contextFactory != null) {
            return this.contextFactory.newThreadContext();
        }
        return null;
    }
}

