/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttr;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDaoSupport;

abstract class EntityAttrDefaultDao<A extends EntityAttr> {
    protected final Connection con;
    protected final AbstractEntityAttrDao<?> entityAttrDao;
    protected final EntityAttrDaoSupport support;
    final String table;
    protected PreparedStatement selectPS;
    protected PreparedStatement insertPS;
    protected PreparedStatement updatePS;
    protected PreparedStatement deletePS;
    protected PreparedStatement insertHistoryPS = null;

    public EntityAttrDefaultDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String table) {
        this.con = con;
        this.entityAttrDao = entityAttrDao;
        this.support = entityAttrDao.support;
        this.table = table;
    }

    protected String idName() {
        return this.support.idName();
    }

    protected String valueName() {
        return this.support.defaultValueName();
    }

    protected String beanIdName() {
        return this.support.beanIdName();
    }

    protected String typeName() {
        return this.support.typeName();
    }

    protected abstract boolean updateImpl(int var1, A var2) throws SQLException, BGException;

    public boolean update(int entityId, EntitySpecAttr sa, EntityAttr a2) throws SQLException, BGException {
        EntityAttr attr = a2;
        boolean result = this.updateImpl(entityId, attr);
        if (this.support.isHistorySupported() && sa.isHistory() && result) {
            this.insertHistory(entityId, attr);
        }
        return result;
    }

    public abstract void insert(int var1, EntityAttr var2) throws SQLException, BGException;

    public abstract A get(int var1, int var2) throws SQLException;

    protected PreparedStatement getSelectPS(int entityId, int entitySpecAttrId) throws SQLException {
        if (this.selectPS == null) {
            this.selectPS = this.con.prepareStatement("SELECT " + this.valueName() + " FROM " + this.table + " WHERE " + this.idName() + "=? AND " + this.typeName() + "=?");
        }
        this.selectPS.setInt(1, entityId);
        this.selectPS.setInt(2, entitySpecAttrId);
        return this.selectPS;
    }

    protected boolean checkEntitySpecAttrDelete(int entitySpecAttrId) throws SQLException {
        PreparedStatement ps = this.con.prepareStatement("SELECT " + this.typeName() + " FROM " + this.table + " WHERE " + this.typeName() + "=? LIMIT 1");
        ps.setInt(1, entitySpecAttrId);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            rs.close();
            ps.close();
            return false;
        }
        rs.close();
        ps.close();
        return true;
    }

    protected PreparedStatement getInsertPS(int entityId, int entitySpecAttrId) throws SQLException {
        if (this.insertPS == null) {
            this.insertPS = this.con.prepareStatement("INSERT INTO " + this.table + " (" + this.idName() + ", " + this.typeName() + ", " + this.valueName() + ") VALUES (?, ?, ?)");
        }
        this.insertPS.setInt(1, entityId);
        this.insertPS.setInt(2, entitySpecAttrId);
        return this.insertPS;
    }

    protected PreparedStatement getUpdatePS(int entityId, int entitySpecAttrId) throws SQLException {
        if (this.updatePS == null) {
            this.updatePS = this.con.prepareStatement("UPDATE " + this.table + " SET " + this.valueName() + "=? WHERE " + this.idName() + "=? AND " + this.typeName() + "=? AND ((@oldValue:=" + this.valueName() + ") IS NOT NULL)");
        }
        this.updatePS.setInt(2, entityId);
        this.updatePS.setInt(3, entitySpecAttrId);
        return this.updatePS;
    }

    protected PreparedStatement getDeletePS(int entityId, int entitySpecAttrId) throws SQLException {
        if (this.deletePS == null) {
            this.deletePS = this.con.prepareStatement("DELETE FROM " + this.table + " WHERE " + this.idName() + "=? AND " + this.typeName() + "=?");
        }
        this.deletePS.setInt(1, entityId);
        this.deletePS.setInt(2, entitySpecAttrId);
        return this.deletePS;
    }

    public final boolean delete(int entityId, EntitySpecAttr sa) throws BGException {
        try {
            boolean result = this.deleteImpl(entityId, sa.getId());
            if (this.support.isHistorySupported() && sa.isHistory() && result) {
                this.insertHistory(entityId, null);
            }
            return result;
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    protected boolean deleteImpl(int entityId, int entitySpecAttrId) throws SQLException {
        PreparedStatement ps = this.getDeletePS(entityId, entitySpecAttrId);
        return ps.executeUpdate() > 0;
    }

    protected PreparedStatement getInsertHistiryPS() throws SQLException {
        if (this.insertHistoryPS == null) {
            this.insertHistoryPS = this.con.prepareStatement("INSERT INTO " + this.table + "_log SET  " + this.idName() + "=?, " + this.typeName() + "=?, val=?, dt_change=?, user_id=?");
        }
        return this.insertHistoryPS;
    }

    protected void insertHistory(int cid, A attr) throws SQLException {
        PreparedStatement ps = this.getInsertHistiryPS();
        ps.setInt(1, cid);
        ps.setInt(2, ((EntityAttr)attr).getEntitySpecAttrId());
        ps.setString(3, attr != null ? attr.toString() : null);
        ps.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
        ps.setInt(5, this.entityAttrDao.userId);
        ps.executeUpdate();
    }
}

