/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceTypeConfig;

public class DeviceTypeConfigDao
extends AbstractDao<DeviceTypeConfig> {
    public DeviceTypeConfigDao(Connection con, int mid) {
        super(con, 0, "inv_device_type_config_" + mid);
    }

    @Override
    protected DeviceTypeConfig getFromRS(ResultSet rs) throws SQLException, BGException {
        DeviceTypeConfig result = new DeviceTypeConfig();
        result.setId(rs.getInt("id"));
        result.setDeviceTypeId(rs.getInt("deviceTypeId"));
        result.setTitle(rs.getString("title"));
        result.setConfig(rs.getString("config"));
        result.setModifyTime(rs.getTimestamp("modifyTime"));
        result.setUserId(rs.getInt("userId"));
        return result;
    }

    @Override
    protected void updateImpl(DeviceTypeConfig b2) throws BGException, SQLException {
        PreparedStatement ps;
        b2.setModifyTime(new Date());
        if (b2.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (title, config, modifyTime, userId, deviceTypeId) VALUES (?,?,?,?,?)", 1);
            ps.setInt(5, b2.getDeviceTypeId());
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET title=?, config=?, modifyTime=?, userId=? WHERE id=?");
            ps.setInt(5, b2.getId());
        }
        ps.setString(1, b2.getTitle());
        ps.setString(2, b2.getConfig());
        ps.setTimestamp(3, TimeUtils.convertDateToTimestamp(b2.getModifyTime()));
        ps.setInt(4, b2.getUserId());
        ps.executeUpdate();
        if (b2.getId() <= 0) {
            b2.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    public List<DeviceTypeConfig> list(int deviceTypeId) throws BGException {
        return this.list("deviceTypeId=?", "id", deviceTypeId);
    }
}

