package ru.bitel.bgbilling.cashcheck;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import bitel.billing.common.SummaToString;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.bean.UserManager;
import ru.bitel.bgbilling.plugins.cashcheck.common.Payment;
import ru.bitel.bgbilling.plugins.cashcheck.common.Printer;
import ru.bitel.bgbilling.plugins.cashcheck.server.CheckMaker;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.Check;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;

/**
 * Формат чека для стандартного шаблона ПКО (драйвер fop, шаблон cashcheck_pko.xsl).
 * Скрипт обрабатывает попытку печати нескольких платежей, обрабатывая их кучей и
 * анализируя в конце. Например, для печати ПКО для платежа, при котором происходит
 * распределение средств.
 * @author dimon
 */
public class PkoCheck
	extends CheckMaker
{
	private Connection con;
	private List<Payment> payments = new ArrayList<Payment>();
	
	@Override
	public void init( Setup setup, Connection con, Connection conSlave )
		throws BGException
	{
		this.con = con;
	}

	@Override
	public void addPayment( Payment payment, Check check, Printer printer )
		throws BGException
	{
		// сохраняем все позиции, какие к нам придут
		payments.add( payment );
	}

	@Override
	public void endCreate( Set<Integer> cids, Check check, Printer printer )
		throws BGException
	{
		BigDecimal summa = BigDecimal.ZERO;
		Payment payment = null;
		// перебираем все позиции
		for( Payment p : payments )
		{
			// считаем их общую сумму, нам ведь её надо вывести, причём в одном конкретном месте.
			summa = summa.add( p.getSumma() );
			// По пути определяем главный договор (вернее, платёж).
			// Например, это либо первый встретившийся, если вдруг решили печатать
			// просто два платежа одного договора в одну ПКО. Либо тот, который
			// супердоговор (для случая когда при распределении средств печатается),
			// хотя в этом случае он тоже всегда первый будет (но можно проверить
			// дополнительно при желании, это на будущее).
			if ( payment == null )
			{
				payment = p;
			}
		}
		// И далее как в обычном случае, только сумму берём посчитанную, а
		// все остальные данные от одного "главного" платежа.
		// Но можно любые условия тут реализовать, например, конкатенировать
		// комментарии договора итд итп.
		//
		//1. Сумма платежа: "120,00р." (делаем одну строку addPayment, чтобы в драйвере общая сумма посчиталась)
		check.addPayment( summa, String.valueOf(summa) + "р.", 0 );
		//2. Номер договора
		check.addString( payment.getContractTitle() );
		//3. Фамилия клиента: "ИВАНОВ И.И."
		check.addString( payment.getContractComment() );
		//4. Дата платежа: 20-04-2009
		check.addString( TimeUtils.format( payment.getDate(), "dd-MM-yyyy" ) );
		//5. Организация: ООО "ПРОВАЙДЕР"
		check.addString( "ООО \"ПРОВАЙДЕР\"" );
		//6. ФИО кассира (пользователя биллинга)
		UserManager um = new UserManager( con );   
		User user = um.get( payment.getUserId() );
		check.addString( user.getName() );
		//7. Тип платежа: "СПД  №"
		check.addString( "СПД  №" );
		//8. Сумма прописью: "Сто двадцать рублей 00 коп"
		check.addString( SummaToString.summaToString( String.valueOf(summa), true ) );
	}

	@Override
	public void addPaymentRefund( Payment payment, Check check, Printer printer )
		throws BGException
	{
	}

	@Override
	public void endCreateRefund( int cid, Check check, Printer printer )
		throws BGException
	{
	}
}
