/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server.fisc.cashcheckserver;

import java.io.IOException;
import java.math.BigDecimal;
import ru.bitel.bgbilling.apps.cashcheck.frk.common.CmdProtocolClient;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.plugins.cashcheck.common.Check;
import ru.bitel.bgbilling.plugins.cashcheck.common.Printer;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.Fiscalizator;

public class CashCheckServerFiscalizator
extends Fiscalizator {
    private String address;
    private int port;
    private int timeoutConnect = -1;

    public CashCheckServerFiscalizator(Printer printer) throws BGException {
        super(printer);
        try {
            String connector = printer.getConfig().get("connector");
            if (connector == null) {
                throw new BGException("\u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 connector=host:port \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u0435\u043d");
            }
            String[] params = connector.split(":");
            this.address = params[0];
            this.port = Integer.parseInt(params[1]);
        }
        catch (Exception e) {
            throw new BGException("\u043e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 cashcheckserver-\u0444\u0438\u0441\u043a\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440\u0430", (Throwable)e);
        }
        this.timeoutConnect = printer.getConfig().getInt("timeout.connect", this.timeoutConnect);
    }

    private String request(String cmdtitle, String command, Object ... parameters) throws BGException {
        String string;
        CmdProtocolClient client = new CmdProtocolClient(this.address, this.port);
        try {
            client.setTimeoutConnect(this.timeoutConnect);
            client.connect();
            boolean result = client.send(command, parameters);
            if (!result) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u044b " + cmdtitle + "! \u041a\u041a\u0422#" + this.printer.getId() + " \u0441\u043a\u0430\u0437\u0430\u043b: " + client.getReply());
            }
            string = client.getReply();
        }
        catch (Throwable throwable) {
            try {
                try {
                    client.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u043c\u0435\u043d\u0430 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c \u043f\u0435\u0447\u0430\u0442\u0438 \u041a\u041a\u0422#" + this.printer.getId() + " \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b " + cmdtitle + ":\n" + e.getMessage(), (Throwable)e);
            }
        }
        client.close();
        return string;
    }

    @Override
    public void buzzer(String oppass) throws BGException {
        this.request("\u0433\u0443\u0434\u043a\u0430", "buzzer", oppass);
    }

    @Override
    public void cancelcheck(String oppass) throws BGException {
        this.request("\u043e\u0442\u043c\u0435\u043d\u044b \u0447\u0435\u043a\u0430", "cancelcheck", oppass);
    }

    @Override
    public String closecheck_fix(String pass, BigDecimal summa) throws BGException {
        return this.request("\u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0447\u0435\u043a\u0430 fix", "closecheck_fix", pass, summa.toPlainString());
    }

    @Override
    public void continueprint(String oppass) throws BGException {
        this.request("\u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0435\u043d\u0438\u044f \u043f\u0435\u0447\u0430\u0442\u0438", "continueprint", oppass);
    }

    @Override
    public void divreport(String adminpass) throws BGException {
        this.request("\u0441\u043d\u044f\u0442\u0438\u044f \u043e\u0442\u0447\u0451\u0442\u0430", "divreport", adminpass);
    }

    @Override
    public void openday(String adminpass) throws BGException {
        this.request("\u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f \u0434\u043d\u044f", "openday", adminpass);
    }

    @Override
    public void printtext(String oppass, String text) throws BGException {
        this.request("\u043f\u0435\u0447\u0430\u0442\u0438 \u0442\u0435\u043a\u0441\u0442\u0430", "printtext", oppass, text);
    }

    @Override
    public void repeatcheck(String oppass) throws BGException {
        this.request("\u043f\u043e\u0432\u0442\u043e\u0440\u0430 \u0447\u0435\u043a\u0430", "repeatcheck", oppass);
    }

    @Override
    public void xreport(String adminpass) throws BGException {
        this.request("\u0441\u043d\u044f\u0442\u0438\u044f x-\u043e\u0442\u0447\u0451\u0442\u0430", "xreport", adminpass);
    }

    @Override
    public void zreport(String adminpass) throws BGException {
        this.request("\u0441\u043d\u044f\u0442\u0438\u044f z-\u043e\u0442\u0447\u0451\u0442\u0430", "zreport", adminpass);
    }

    @Override
    public String purecommand(String pass, String hexdump) throws BGException {
        return this.request("\u043e\u0442\u043b\u0430\u0434\u043e\u0447\u043d\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b", "purecommand", pass, hexdump);
    }

    @Override
    public String check(String oppass, BigDecimal clientsumma, Check check) throws BGException {
        return this.request("\u043f\u0435\u0447\u0430\u0442\u0438 \u0447\u0435\u043a\u0430", "check", oppass, clientsumma.toPlainString(), check.getPlines());
    }

    @Override
    public String checkreturn(String oppass, BigDecimal clientsumma, Check check) throws BGException {
        return this.request("\u043f\u0435\u0447\u0430\u0442\u0438 \u0447\u0435\u043a\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430", "checkreturn", oppass, clientsumma.toPlainString(), check.getPlines());
    }

    @Override
    public String status(String password) throws BGException {
        return this.request("\u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u0430", "status", password);
    }

    @Override
    public String name(String pass) throws BGException {
        return this.request("\u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0438\u043c\u0435\u043d\u0438", "name", pass);
    }

    @Override
    public String getFiscalizatorStatus() throws BGException {
        String string;
        CmdProtocolClient client = new CmdProtocolClient(this.address, this.port);
        try {
            client.setTimeoutConnect(this.timeoutConnect);
            client.connect();
            string = client.getServerStatus();
        }
        catch (Throwable throwable) {
            try {
                try {
                    client.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u043c\u0435\u043d\u0430 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c \u043f\u0435\u0447\u0430\u0442\u0438 \u041a\u041a\u041c#" + this.printer.getId() + ":\n" + e.getMessage(), (Throwable)e);
            }
        }
        client.close();
        return string;
    }

    @Override
    public boolean isAsynchronous() {
        return false;
    }
}

