/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.cashcheck.frk.driver.fop;

import java.awt.Toolkit;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.math.BigDecimal;
import java.util.Map;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOPException;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.render.print.PrintRenderer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.ICashCheckDriver;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.FrkException;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.NotImplementedException;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.PrinterConnectException;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.PrinterErrorException;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.FrkUtils;
import ru.bitel.bgbilling.plugins.cashcheck.common.Check;
import ru.bitel.common.FOUtils;
import ru.bitel.common.Utils;

public class Driver
implements ICashCheckDriver {
    private PrintService printService;
    private String[] repeatCheckParametersStored;
    private DocumentBuilder docBuilder;
    private String jobName;
    private int jobCopies;
    private String xslName;
    private int method;
    private static final Logger logger = LogManager.getLogger();

    @Override
    public void init(Map<String, String> config) throws Exception {
        String printerName = config.get("printer");
        if (printerName != null && !printerName.isEmpty()) {
            PrintService[] printServices;
            StringBuilder sb = new StringBuilder();
            for (PrintService ps : printServices = PrintServiceLookup.lookupPrintServices(null, null)) {
                sb.append("'").append(ps.getName()).append("',");
                if (!printerName.equals(ps.getName())) continue;
                this.printService = ps;
            }
            if (this.printService == null) {
                throw new Exception("error lookup print service '" + printerName + "'; available: " + sb.toString());
            }
        } else {
            this.printService = PrintServiceLookup.lookupDefaultPrintService();
            if (this.printService == null) {
                throw new Exception("error lookup default print service");
            }
        }
        DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
        dFactory.setNamespaceAware(true);
        this.docBuilder = dFactory.newDocumentBuilder();
        this.xslName = config.get("xsl");
        if (this.xslName == null) {
            throw new Exception("not found param 'xsl'");
        }
        this.jobName = config.get("jobName");
        this.jobCopies = Utils.parseInt((String)config.get("jobCopies"), (int)1);
        this.method = Utils.parseInt((String)config.get("method"), (int)1);
    }

    @Override
    public void touchDriver() {
        PrintService[] printServices;
        logger.debug("fop driver ready");
        StringBuilder sb = new StringBuilder();
        sb.append("available print services:\n");
        for (PrintService ps : printServices = PrintServiceLookup.lookupPrintServices(null, null)) {
            sb.append("'").append(ps.getName()).append("'\n");
        }
        sb.append("default print service:\n");
        PrintService defPrintService = PrintServiceLookup.lookupDefaultPrintService();
        sb.append((String)(defPrintService != null ? "'" + defPrintService.getName() + "'" : "<not>")).append("\n");
        logger.debug(sb.toString());
    }

    @Override
    public synchronized void buzzer(String operatorPass) {
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    public synchronized void printtext(String ... parameters) throws NotImplementedException {
        this.repeatCheckParametersStored = null;
        throw new NotImplementedException();
    }

    @Override
    public synchronized String name(String operatorPass) {
        return this.printService.getName();
    }

    @Override
    public synchronized String status(String operatorPass) {
        Attribute[] attributes;
        StringBuilder sb = new StringBuilder();
        sb.append("\u0410\u0442\u0440\u0438\u0431\u0443\u0442\u044b:\n");
        for (Attribute attribute : attributes = this.printService.getAttributes().toArray()) {
            sb.append(attribute.getName()).append(": ").append(attribute.toString()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public synchronized void xreport(String adminPass) throws NotImplementedException {
        this.repeatCheckParametersStored = null;
        throw new NotImplementedException();
    }

    @Override
    public synchronized void zreport(String adminPass) throws NotImplementedException {
        this.repeatCheckParametersStored = null;
        throw new NotImplementedException();
    }

    @Override
    public synchronized void divreport(String adminPass) throws NotImplementedException {
        this.repeatCheckParametersStored = null;
        throw new NotImplementedException();
    }

    @Override
    public synchronized String check(String ... parameters) throws FrkException {
        BigDecimal par1;
        Document doc = this.docBuilder.newDocument();
        Element dataEl = (Element)doc.appendChild(doc.createElement("data"));
        BigDecimal clientsumma = par1 = FrkUtils.parseBigDecimal(parameters[1]);
        FrkUtils.CommandCheckParameters commandCheckParameters = FrkUtils.processCommandCheckParameters(parameters, logger);
        BigDecimal summa = commandCheckParameters.paymentsum;
        Integer tax = commandCheckParameters.tax;
        Integer paymentType = commandCheckParameters.paymentType;
        int index = 1;
        for (Check.CheckLine l : commandCheckParameters.lines) {
            Element lineEl = (Element)dataEl.appendChild(doc.createElement("line"));
            if (l.getSumma() == null) {
                lineEl.setAttribute("text", l.getText());
            } else {
                lineEl.setAttribute("summ", l.getSumma().toPlainString());
                lineEl.setAttribute("text", l.getText());
                lineEl.setAttribute("dep", String.valueOf(l.getDep()));
            }
            lineEl.setAttribute("n", String.valueOf(index++));
        }
        if (clientsumma.compareTo(summa) < 0) {
            throw new PrinterErrorException("\u0414\u0435\u043d\u0435\u0433 \u0432\u043d\u0435\u0441\u0435\u043d\u043e (" + clientsumma.toPlainString() + ") \u043c\u0435\u043d\u044c\u0448\u0435 \u0441\u0443\u043c\u043c\u044b \u0447\u0435\u043a\u0430 (" + summa.toPlainString() + ")");
        }
        dataEl.setAttribute("clientsumma", clientsumma.toPlainString());
        dataEl.setAttribute("summa", summa.toPlainString());
        dataEl.setAttribute("paymentType", String.valueOf(paymentType));
        dataEl.setAttribute("tax", String.valueOf(tax));
        try {
            this.foPrint(doc);
        }
        catch (Throwable e) {
            throw new PrinterConnectException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0442\u0440\u0430\u043d\u0441\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u0438\u043b\u0438 \u043f\u0435\u0447\u0430\u0442\u0438", e);
        }
        this.repeatCheckParametersStored = (String[])parameters.clone();
        return clientsumma.subtract(summa).toPlainString();
    }

    private void foPrint(Document xml) throws TransformerException, FOPException, PrinterException {
        logger.trace(FrkUtils.serializeToString(xml));
        logger.debug("prepare printerjob...");
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintService(this.printService);
        if (this.jobName != null) {
            printerJob.setJobName(this.jobName);
        }
        printerJob.setCopies(this.jobCopies);
        if (this.method == 1) {
            AWTRenderer renderer = FOUtils.createAWTRenderer();
            logger.debug("render to AWTRenderer...");
            FOUtils.render((Source)new DOMSource(xml), (Source)new StreamSource(this.xslName), (Renderer)renderer, (String)"application/X-fop-awt-preview");
            printerJob.setPageable((Pageable)renderer);
            logger.debug("print...");
            printerJob.print();
        } else if (this.method == 2) {
            PrintRenderer renderer = FOUtils.createPrintRenderer((PrinterJob)printerJob, (int)this.jobCopies);
            logger.debug("render to PrintRenderer...");
            FOUtils.render((Source)new DOMSource(xml), (Source)new StreamSource(this.xslName), (Renderer)renderer, (String)"application/X-fop-print");
        } else {
            throw new RuntimeException("error method value " + this.method);
        }
    }

    @Override
    public synchronized String checkreturn(String ... parameters) throws NotImplementedException {
        this.repeatCheckParametersStored = null;
        throw new NotImplementedException();
    }

    @Override
    public String closecheck_fix(String pass, String summa) throws NotImplementedException {
        this.repeatCheckParametersStored = null;
        throw new NotImplementedException();
    }

    @Override
    public void continueprint(String pass) throws NotImplementedException {
        this.repeatCheckParametersStored = null;
        throw new NotImplementedException();
    }

    @Override
    public String purecommand(String operatorPass, String command) throws NotImplementedException {
        this.repeatCheckParametersStored = null;
        throw new NotImplementedException();
    }

    @Override
    public void repeatcheck(String operatorPass) throws FrkException {
        if (this.repeatCheckParametersStored == null) {
            throw new PrinterErrorException("\u041f\u043e\u0432\u0442\u043e\u0440 \u0447\u0435\u043a\u0430 \u0434\u0435\u043b\u0430\u0435\u0442\u0441\u044f \u043f\u043e\u0441\u043b\u0435 \u0447\u0435\u043a\u0430");
        }
        this.check(this.repeatCheckParametersStored);
    }

    @Override
    public synchronized void cancelcheck(String pass) throws FrkException {
        this.repeatCheckParametersStored = null;
        throw new NotImplementedException();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String getStatus() {
        return "printService=" + this.printService.getName();
    }

    @Override
    public void openday(String pass) throws FrkException {
        this.repeatCheckParametersStored = null;
        throw new NotImplementedException();
    }
}

