/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.cashcheck.frk.vprinter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.CmdTcpServer;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.FrkUtils;

public class VirtualPrinter
extends JFrame {
    private BufferedReader in;
    private JTextArea checkArea;
    private JTextArea commandArea;
    private Timer timer;
    private static final int TIMER_DELTA = 1500;
    private JLabel onoff;
    private boolean onoffFlag = false;
    private static final int CHECK_WIDTH = 40;
    private static final String CHECK_BIGLINE;
    private static final SimpleDateFormat DATE_FIELD_FORMAT;
    private int checkCount = 1;
    private static final String LOG_PREFIX = "driver emulator: ";
    private static final Pattern LOG_FUNC_PATTERN;

    public VirtualPrinter(BufferedReader in) throws IOException {
        this.in = in;
        this.getContentPane().setLayout(new GridBagLayout());
        this.checkArea = new JTextArea(20, 45);
        this.checkArea.setEditable(false);
        this.commandArea = new JTextArea(10, 45);
        this.commandArea.setEditable(false);
        Font font = new Font("Monospaced", this.checkArea.getFont().getStyle(), this.checkArea.getFont().getSize());
        this.checkArea.setFont(font);
        this.commandArea.setFont(font);
        JButton clearButton = new JButton("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c");
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualPrinter.this.checkArea.setText("");
                VirtualPrinter.this.commandArea.setText("");
            }
        });
        this.onoff = new JLabel();
        this.onoff.setPreferredSize(new Dimension(10, 10));
        this.onoff.setMinimumSize(new Dimension(10, 10));
        JScrollPane ca1 = new JScrollPane(this.checkArea);
        ca1.setBorder(new TitledBorder("\u0427\u0435\u043a\u0438"));
        ca1.setHorizontalScrollBarPolicy(31);
        JScrollPane ca2 = new JScrollPane(this.commandArea);
        ca2.setBorder(new TitledBorder("\u041a\u043e\u043c\u0430\u043d\u0434\u044b"));
        JPanel ca3 = new JPanel(new GridBagLayout());
        ca3.add((Component)new JLabel("\u0410\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u044c:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        ca3.add((Component)this.onoff, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        ca3.add((Component)clearButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)ca1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)ca2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)ca3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                VirtualPrinter.this.timer.stop();
                System.exit(0);
            }
        });
        this.setTitle("Virtual Printer");
        this.setResizable(false);
        this.pack();
        this.setVisible(true);
        this.timer = new Timer(1500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Graphics g = VirtualPrinter.this.onoff.getGraphics();
                if (VirtualPrinter.this.onoffFlag) {
                    g.clearRect(0, 0, 10, 10);
                } else {
                    g.setColor(Color.GREEN);
                    g.fillOval(0, 0, 10, 10);
                }
                VirtualPrinter.this.onoffFlag = !VirtualPrinter.this.onoffFlag;
                VirtualPrinter.this.doTimer();
            }
        });
        this.timer.start();
    }

    protected void doTimer() {
        try {
            while (this.in.ready()) {
                String line = this.in.readLine();
                if (!line.startsWith(LOG_PREFIX)) continue;
                String func = line.substring(LOG_PREFIX.length());
                this.commandArea.append(func);
                Matcher m = LOG_FUNC_PATTERN.matcher(func);
                if (m.matches()) {
                    String[] params;
                    String funcName = m.group(1);
                    String funcParams = m.group(2);
                    if (funcName.equals("printtext")) {
                        params = VirtualPrinter.parseParams(funcParams);
                        for (int i = 1; i < params.length; ++i) {
                            this.printOneLineCheck(params[i], null);
                        }
                        this.printOneLineCheck(CHECK_BIGLINE, null);
                    } else if (funcName.equals("xreport")) {
                        this.printHeader("\u041e\u0422\u0427\u0401\u0422 \u0411\u0415\u0417 \u0413\u0410\u0428\u0415\u041d\u0418\u042f");
                        this.printOneLineCheck("<x-\u043e\u0442\u0447\u0451\u0442>", null, true);
                        this.printFooter(false);
                        this.printOneLineCheck(CHECK_BIGLINE, null);
                    } else if (funcName.equals("divreport")) {
                        this.printHeader("\u041e\u0422\u0427\u0401\u0422 \u041f\u041e \u041e\u0422\u0414\u0415\u041b\u0410\u041c");
                        this.printOneLineCheck("<\u043e\u0442\u0447\u0451\u0442 \u043f\u043e \u043e\u0442\u0434\u0435\u043b\u0430\u043c>", null, true);
                        this.printFooter(false);
                        this.printOneLineCheck(CHECK_BIGLINE, null);
                    } else if (funcName.equals("zreport")) {
                        this.printHeader("\u041e\u0422\u0427\u0401\u0422 \u0421 \u0413\u0410\u0428\u0415\u041d\u0418\u0415\u041c");
                        this.printOneLineCheck("<z-\u043e\u0442\u0447\u0451\u0442>", null, true);
                        this.printFooter(true);
                        this.printOneLineCheck(CHECK_BIGLINE, null);
                    } else if (funcName.equals("closecheck_fix")) {
                        params = VirtualPrinter.parseParams(funcParams);
                        String summ = params[1];
                        this.printOneLineCheck("<\u043d\u0430\u0441\u0438\u043b\u044c\u043d\u043e\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0447\u0435\u043a\u0430>", null, true);
                        this.printItogo(summ, summ);
                        this.printFooter(true);
                        this.printOneLineCheck(CHECK_BIGLINE, null);
                    } else if (funcName.equals("check")) {
                        this.printHeader("\u041f\u0420\u041e\u0414\u0410\u0416\u0410");
                        params = VirtualPrinter.parseParams(funcParams);
                        String clientsumma = params[1];
                        BigDecimal summa = BigDecimal.ZERO;
                        for (int i = 2; i < params.length; i += 3) {
                            String s = params[i];
                            String t = params[i + 1];
                            String d = params[i + 2];
                            if ("STRING".equals(s)) {
                                this.printOneLineCheck(t, null);
                                continue;
                            }
                            this.printOneLineCheck(t, null);
                            this.printOneLineCheck(d, s);
                            summa = summa.add(new BigDecimal(s));
                        }
                        this.printItogo(summa.toPlainString(), clientsumma);
                        this.printFooter(true);
                        this.printOneLineCheck(CHECK_BIGLINE, null);
                    } else if (funcName.equals("repeatcheck")) {
                        this.printHeader("\u041f\u041e\u0412\u0422\u041e\u0420 \u0427\u0415\u041a\u0410");
                        this.printOneLineCheck("<\u043f\u043e\u0432\u0442\u043e\u0440 \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0433\u043e \u0447\u0435\u043a\u0430>", null, true);
                        this.printFooter(false);
                        this.printOneLineCheck(CHECK_BIGLINE, null);
                    } else if (funcName.equals("continueprint")) {
                        this.printOneLineCheck("<\u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0435\u043d\u0438\u0435 \u043f\u0435\u0447\u0430\u0442\u0438>", null, true);
                        this.printOneLineCheck(CHECK_BIGLINE, null);
                    }
                    ++this.checkCount;
                    this.checkArea.scrollRectToVisible(new Rectangle(0, this.checkArea.getHeight(), 1, this.checkArea.getHeight()));
                    this.commandArea.scrollRectToVisible(new Rectangle(0, this.commandArea.getHeight(), 1, this.commandArea.getHeight()));
                } else {
                    this.commandArea.append(" (?)");
                }
                this.commandArea.append("\n");
            }
        }
        catch (Throwable e) {
            this.commandArea.append(e.toString());
        }
    }

    private void printOneLineCheck(String line1, String line2, boolean line1Center) {
        if (line1 == CHECK_BIGLINE) {
            this.checkArea.append(CHECK_BIGLINE);
            return;
        }
        int totalLineWidth = 0;
        if (line1 != null) {
            if (line1.length() >= 40) {
                this.checkArea.append(line1.substring(0, 40) + "\n");
                return;
            }
            if (line1Center) {
                int spaceMust = (40 - line1.length()) / 2;
                this.checkArea.append(FrkUtils.spaces(spaceMust) + line1 + "\n");
                return;
            }
            this.checkArea.append(line1);
            totalLineWidth = line1.length();
        }
        if (line2 != null) {
            if (line2.length() >= 40 - totalLineWidth) {
                this.checkArea.append(line2.substring(0, 40 - totalLineWidth) + "\n");
                return;
            }
            int spaceMust = 40 - totalLineWidth - line2.length();
            this.checkArea.append(FrkUtils.spaces(spaceMust) + line2);
            totalLineWidth = 40;
        }
        this.checkArea.append(FrkUtils.spaces(40 - totalLineWidth) + "\n");
    }

    private void printOneLineCheck(String line1, String line2) {
        this.printOneLineCheck(line1, line2, false);
    }

    private void printHeader(String opName) {
        this.printOneLineCheck("\u041e\u041e\u041e '\u0424\u0438\u0440\u043c\u0430'", null, true);
        this.printOneLineCheck("\u0424\u0438\u043b\u0438\u0430\u043b 123, \u041b\u0435\u043d\u0438\u043d\u0430 58", null, true);
        this.printOneLineCheck("\u041d\u0430\u043b\u0438\u0447\u043d\u044b\u0439 \u0440\u0430\u0441\u0447\u0451\u0442", null);
        this.printOneLineCheck("\u041a\u041a\u041c 12345678 \u0418\u041d\u041d 123456789012", "#0000");
        this.printOneLineCheck(DATE_FIELD_FORMAT.format(new Date()), "\u041a\u0430\u0441\u0441\u0438\u0440 \u0410.\u0411.");
        this.printOneLineCheck(opName, "N" + FrkUtils.fn(this.checkCount, 4));
    }

    private void printFooter(boolean fiscal) {
        if (fiscal) {
            this.printOneLineCheck("(\u0424)\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439", null);
        }
        this.printOneLineCheck("\u0421\u043f\u0430\u0441\u0438\u0431\u043e \u0437\u0430 \u043f\u043e\u043a\u0443\u043f\u043a\u0443", null, true);
    }

    private void printItogo(String total, String clientsumma) {
        BigDecimal itotal = new BigDecimal(total);
        BigDecimal iclientsumma = new BigDecimal(clientsumma);
        itotal.setScale(5, 2);
        iclientsumma.setScale(5, 2);
        this.printOneLineCheck("\u0418\u0422\u041e\u0413", itotal.toPlainString());
        this.printOneLineCheck(" \u043d\u0430\u043b\u0438\u0447\u043d\u044b\u043c\u0438", iclientsumma.toPlainString());
        if (itotal.compareTo(iclientsumma) < 0) {
            BigDecimal isubtr = iclientsumma.subtract(itotal);
            isubtr.setScale(5, 2);
            this.printOneLineCheck(" \u0441\u0434\u0430\u0447\u0430", isubtr.toPlainString());
        }
    }

    private static String[] parseParams(String params) {
        if (params == null || params.trim().isEmpty()) {
            return new String[0];
        }
        if (!params.startsWith("'") || !params.endsWith("'")) {
            throw new IllegalArgumentException("func params error: \"" + params + "\"");
        }
        params = params.substring(1, params.length() - 1);
        return params.split("\\'\\,\\'", -1);
    }

    public static void main(String[] args) throws IOException {
        if (args.length > 0) {
            boolean noskipexist = false;
            File logFile = null;
            String encoding = System.getProperty("file.encoding");
            for (String arg : args) {
                if ("--noskipexist".equals(arg)) {
                    noskipexist = true;
                    continue;
                }
                if (arg.startsWith("--encoding=")) {
                    encoding = arg.substring("--encoding=".length());
                    continue;
                }
                logFile = new File(arg.trim());
                break;
            }
            if (logFile == null) {
                System.err.println("Error! File is not specified");
                VirtualPrinter.showHelp();
            } else if (logFile.exists() && logFile.isFile() && logFile.canRead()) {
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(logFile), encoding));
                if (!noskipexist) {
                    while (in.ready()) {
                        in.readLine();
                    }
                }
                new VirtualPrinter(in);
            } else {
                System.err.println("Error! File '" + logFile.getAbsolutePath() + "' is not valid readable file");
                VirtualPrinter.showHelp();
            }
        } else {
            VirtualPrinter.showHelp();
        }
    }

    private static void showHelp() {
        StringBuffer sb = new StringBuffer();
        sb.append("VirtualPrinter (visual log viewer) of ").append(CmdTcpServer.getVersion());
        sb.append("\nUsage: <virtualprinter>[.bat|.sh] [--noskipexist] [--encoding=<encoding>] <logfilename>");
        sb.append("\nParameters:");
        sb.append("\n\t--noskipexist - no skip existing lines of input file");
        sb.append("\n\t--encoding=<encoding> - set encoding of input file");
        sb.append("\n\tlogfilename - path to 'cashserver.out' log file");
        sb.append("\nExample:\n\t./virtualprinter.sh ./log/cashserver.out");
        System.out.println(sb.toString());
    }

    static {
        StringBuffer sb = new StringBuffer(42);
        for (int i = 0; i < 40; ++i) {
            sb.append("-");
        }
        sb.append("\n");
        CHECK_BIGLINE = sb.toString();
        DATE_FIELD_FORMAT = new SimpleDateFormat("dd.MM.yy HH:mm");
        LOG_FUNC_PATTERN = Pattern.compile("^([a-zA-Z_]+)\\((.*)\\)$");
    }
}

