/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.bgsecure.bean;

import java.security.Principal;
import java.sql.Connection;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.AccountLockedException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.bean.UserManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.UserCallbackHandler;
import ru.bitel.common.Utils;

public class UserLoginModule
implements LoginModule {
    protected Subject subject;
    protected CallbackHandler callbackHandler;
    protected Map<String, ?> sharedState;
    protected Map<String, ?> options;
    protected UserPrincipal user;
    protected boolean loginOK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Subject auth(String loginContextName, String userName, String userPswd) throws LoginException {
        Connection conSlave = Setup.getSetup().getDBSlaveConnectionFromPool();
        if (conSlave == null) {
            throw new LoginException("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441 \u0431\u0430\u0437\u043e\u0439 \u0434\u0430\u043d\u043d\u044b\u0445! \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0432 data.properties. ");
        }
        try {
            UserCallbackHandler callbackHandler = new UserCallbackHandler(userName, userPswd.toCharArray(), conSlave);
            LoginContext lc = new LoginContext(loginContextName, callbackHandler);
            lc.login();
            Subject subject = lc.getSubject();
            return subject;
        }
        finally {
            ServerUtils.closeConnection(conSlave);
        }
    }

    public static final User getUser(Subject subject) {
        Iterator<UserPrincipal> iterator = subject.getPrincipals(UserPrincipal.class).iterator();
        if (iterator.hasNext()) {
            UserPrincipal principal = iterator.next();
            return principal.getUser();
        }
        return null;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.loginOK = false;
        this.user = null;
    }

    protected void login(User user, NameCallback name, PasswordCallback pswd) throws LoginException {
        if (user == null) {
            throw new AccountNotFoundException("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \"" + name.getName() + "\" - \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0411\u0414.");
        }
        if (user.getStatus() != 0) {
            throw new AccountLockedException("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \"" + name.getName() + "\" - \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d.");
        }
        if (Utils.isBlankString((String)user.getPassword()) || !user.getPassword().equalsIgnoreCase(Utils.getDigest((String)new String(pswd.getPassword()), (String)"UTF-8"))) {
            throw new FailedLoginException("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean login() throws LoginException {
        this.loginOK = false;
        NameCallback name = new NameCallback("user");
        PasswordCallback pswd = new PasswordCallback("pswd", false);
        ConnectionCallback con = new ConnectionCallback();
        Callback[] callbacks = new Callback[]{con, name, pswd};
        try {
            this.callbackHandler.handle(callbacks);
            User user = new UserManager(con.getConnection()).getUserByLogin(name.getName());
            this.login(user, name, pswd);
            this.user = new UserPrincipal(user);
            this.loginOK = true;
            return true;
        }
        catch (LoginException e) {
            throw new LoginException(e.getLocalizedMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LoginException(e.getLocalizedMessage());
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.loginOK) {
            return false;
        }
        this.subject.getPrincipals().add(this.user);
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        return false;
    }

    public class UserPrincipal
    implements Principal {
        private final User user;

        public UserPrincipal(User user) {
            this.user = user;
        }

        @Override
        public String getName() {
            return this.user.getLogin();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof UserPrincipal) {
                return ((UserPrincipal)obj).user.getId() == this.user.getId();
            }
            return false;
        }

        public User getUser() {
            return this.user;
        }

        @Override
        public int hashCode() {
            return this.user.getId();
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }

    public class ConnectionCallback
    implements Callback {
        private Connection con;

        public Connection getConnection() {
            return this.con;
        }

        public void setConnection(Connection con) {
            this.con = con;
        }
    }

    public static class WithoutPassword
    extends UserLoginModule {
        @Override
        protected void login(User user, NameCallback name, PasswordCallback pswd) throws LoginException {
            if (user == null) {
                throw new AccountNotFoundException("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \"" + name.getName() + "\" - \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0411\u0414");
            }
            if (user.getStatus() != 0) {
                throw new AccountLockedException("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \"" + name.getName() + "\" - \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d");
            }
        }
    }
}

