/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ServiceNormalizer {
    private Connection con;

    public ServiceNormalizer(Connection con) throws SQLException {
        this.con = con;
        this.fillContractModule();
        this.fillNpayServiceObject();
    }

    private void fillContractModule() throws SQLException {
        System.out.println("Filling contract_module from contract_service..");
        String query = null;
        PreparedStatement ps = null;
        query = "INSERT INTO contract_module (cid, mid) VALUES (?,?)";
        PreparedStatement psInsert = this.con.prepareStatement(query);
        query = "SELECT DISTINCT contract_service.cid, service.mid FROM contract_service INNER JOIN service ON contract_service.sid=service.id LEFT JOIN contract_module ON service.mid=contract_module.mid AND contract_service.cid=contract_module.cid WHERE contract_module.cid is null ";
        ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            psInsert.setInt(1, rs.getInt(1));
            psInsert.setInt(2, rs.getInt(2));
            psInsert.executeUpdate();
        }
        ps.close();
        psInsert.close();
    }

    private void fillNpayServiceObject() throws SQLException {
        System.out.println("Filling npay_service_object_<mid> from contract_service...");
        Object query = null;
        PreparedStatement ps = null;
        HashMap npayServices = new HashMap();
        int lastMid = 0;
        HashSet<Integer> lastSet = null;
        query = "SELECT service.mid, service.id FROM service INNER JOIN module ON service.mid=module.id AND module.name='npay' ORDER BY mid";
        ps = this.con.prepareStatement((String)query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            int mid = rs.getInt(1);
            int sid = rs.getInt(2);
            if (mid != lastMid) {
                lastSet = new HashSet<Integer>();
                npayServices.put(mid, lastSet);
                lastMid = mid;
                System.out.println("mid=" + mid);
            }
            lastSet.add(sid);
        }
        ps.close();
        for (Map.Entry me : npayServices.entrySet()) {
            int mid = (Integer)me.getKey();
            String services = Utils.toString((Iterable)((Iterable)me.getValue()));
            if (!Utils.notBlankString((String)services)) continue;
            String tableName = "npay_service_object_" + mid;
            query = "INSERT INTO " + tableName + " (cid, sid, date1, date2, col, emid, eid, comment, csid) VALUES  (?, ?, ?, ?, 1, ?, ?, ?, ?)";
            PreparedStatement psInsert = this.con.prepareStatement((String)query);
            query = "UPDATE " + tableName + " SET cid=?, sid=?, date1=?, date2=?, emid=?, eid=?, comment=? WHERE id=?";
            PreparedStatement psUpdate = this.con.prepareStatement((String)query);
            query = "SELECT cs.cid, cs.sid, cs.date1, cs.date2, cs.comment, nso.sid, nso.col, cs.emid, cs.eid, nso.id, cs.id FROM contract_service AS cs LEFT JOIN " + tableName + " AS nso ON cs.id=nso.csid WHERE cs.sid IN (" + services + ")";
            ps = this.con.prepareStatement((String)query);
            rs = ps.executeQuery();
            while (rs.next()) {
                int cid = rs.getInt(1);
                int sid = rs.getInt(2);
                java.sql.Date date1 = rs.getDate(3);
                java.sql.Date date2 = rs.getDate(4);
                String comment = rs.getString(5);
                int nsoSid = rs.getInt(6);
                Integer nsoCol = (Integer)rs.getObject(7);
                int emid = rs.getInt(8);
                int eid = rs.getInt(9);
                int nsoId = rs.getInt(10);
                int csId = rs.getInt(11);
                PreparedStatement psCorrect = null;
                if (nsoCol == null) {
                    psCorrect = psInsert;
                    psCorrect.setInt(8, csId);
                } else if (nsoSid == 0) {
                    psCorrect = psUpdate;
                    psCorrect.setInt(8, nsoId);
                }
                if (psCorrect == null) continue;
                psCorrect.setInt(1, cid);
                psCorrect.setInt(2, sid);
                psCorrect.setDate(3, TimeUtils.convertDateToSqlDate((Date)date1));
                psCorrect.setDate(4, TimeUtils.convertDateToSqlDate((Date)date2));
                psCorrect.setInt(5, emid);
                psCorrect.setInt(6, eid);
                psCorrect.setString(7, comment);
                psCorrect.executeUpdate();
            }
            ps.close();
            psInsert.close();
            psUpdate.close();
        }
    }

    public static void main(String[] args) {
        Setup setup = new Setup("data.data");
        try {
            new ServiceNormalizer(setup.getDBConnection());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

