/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action.web;

import bitel.billing.server.ActionResultContentType;
import bitel.billing.server.admin.bean.ContractParameterGroupManager;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractEmailParamValue;
import bitel.billing.server.contract.bean.ContractParameterManager;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.PhoneUtils;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPref;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.MultiListParamValues;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.PhoneParamItem;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.PhoneParamValue;
import ru.bitel.bgbilling.kernel.contract.param.server.bean.ContractParameterPrefDao;
import ru.bitel.bgbilling.kernel.event.events.ContractParamChangedEvent;
import ru.bitel.common.Utils;

public class ActionContractParameter
extends AbstractAction {
    private static final String PARAM_HIDDEN_VALUE = "< \u0421\u041a\u0420\u042b\u0422\u041e >";
    private int parameterId = 0;
    private Contract contract = null;
    private ContractParameterManager contractParameterManager = null;
    private ContractParameterPrefDao prefDao = null;

    @Override
    public void execute() throws BGException {
        this.a();
        if (this.contract != null) {
            Set<Integer> ids = null;
            if (this.contract.getParamGroup() > 0) {
                ids = new ContractParameterGroupManager(this.con).getParameterSetInGroup(this.contract.getParamGroup());
            }
            List<ContractParameterPref> groupList = this.prefDao.getContractParameterPrefList(ids);
            ArrayList<ContractParameterPref> showList = new ArrayList<ContractParameterPref>();
            HashSet<Integer> paramIds = new HashSet<Integer>();
            for (ContractParameterPref contractParameterPref : groupList) {
                if (!contractParameterPref.isRead() && !contractParameterPref.isWrite()) continue;
                showList.add(contractParameterPref);
                paramIds.add(contractParameterPref.getId());
            }
            HashMap<Integer, String> paramValue = this.contractParameterManager.getValuesForPids(paramIds, this.contractId);
            for (Map.Entry<Integer, ContractEmailParamValue> entry : this.contractParameterManager.getEmailParamMap(this.contractId, paramIds).entrySet()) {
                ContractEmailParamValue emailParamValue = entry.getValue();
                if (emailParamValue == null || emailParamValue.getEmail() == null) continue;
                String emails = emailParamValue.getEmail().trim();
                emails = emails.replaceAll("\n", "; ");
                emails = emails.replaceAll("<", "&lt;");
                emails = emails.replaceAll(">", "&gt;");
                paramValue.put(entry.getKey(), emails);
            }
            for (Map.Entry<Integer, Serializable> entry : this.contractParameterManager.getFlagParamMap(this.contractId, paramIds).entrySet()) {
                Boolean flagParamValue = (Boolean)entry.getValue();
                if (flagParamValue == null) continue;
                paramValue.put(entry.getKey(), flagParamValue != false ? "\u0432\u043a\u043b\u044e\u0447\u0435\u043d\u043e" : "\u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u043e");
            }
            this.setResultParam("paramList", showList);
            this.setResultParam("paramValue", paramValue);
        }
    }

    public void getParameterType3() throws BGException {
        this.a();
        ContractParameterPref contractParameterPref = (ContractParameterPref)this.prefDao.get(this.parameterId);
        if (contractParameterPref != null) {
            ArrayList<String[]> emails = new ArrayList<String[]>();
            ContractEmailParamValue paramValue = this.contractParameterManager.getEmailParam(this.contract.getId(), this.parameterId);
            if (paramValue != null) {
                Pattern pattern = Pattern.compile("^(.*)\\<(.*)\\>$");
                for (String email : paramValue.getEmail().split("\n")) {
                    if (email.trim().isEmpty()) continue;
                    String[] emailData = new String[2];
                    if (email.matches("^(.*)\\<(.*)\\>$")) {
                        Matcher matcher = pattern.matcher(email);
                        while (matcher.find()) {
                            emailData[0] = matcher.group(2);
                            emailData[1] = matcher.group(1).trim();
                        }
                    } else {
                        emailData[0] = email;
                        emailData[1] = "";
                    }
                    if (!contractParameterPref.isRead()) {
                        emailData[0] = Utils.maskEmail((String)emailData[0]);
                        emailData[1] = PARAM_HIDDEN_VALUE;
                    }
                    emails.add(emailData);
                }
            }
            this.setResultParam("paramValue", emails);
            this.setResultParam("paramTitle", contractParameterPref.getTitle());
            this.setResultParam("paramRead", contractParameterPref.isRead());
            this.setResultParam("paramWrite", contractParameterPref.isWrite());
        }
    }

    public void updateParameterType3() throws BGException, SQLException {
        this.a();
        ContractParameterPref contractParameterPref = (ContractParameterPref)this.prefDao.get(this.parameterId);
        if (contractParameterPref != null && contractParameterPref.isWrite()) {
            ArrayList<String[]> updateEmails = new ArrayList<String[]>();
            String parameterValue = this.req.get("parameterValue");
            if (parameterValue != null) {
                for (String splits : parameterValue.split("\n")) {
                    updateEmails.add(splits.split("\t"));
                }
            }
            ArrayList<String[]> currentEmails = new ArrayList<String[]>();
            ContractEmailParamValue paramValue = this.contractParameterManager.getEmailParam(this.contract.getId(), this.parameterId);
            if (paramValue != null && Utils.notBlankString((String)paramValue.getEmail())) {
                int index = 0;
                Pattern pattern = Pattern.compile("^(.*)\\<(.*)\\>$");
                for (String email : paramValue.getEmail().split("\n")) {
                    String[] emailData = new String[3];
                    if (email.matches("^(.*)\\<(.*)\\>$")) {
                        Matcher matcher = pattern.matcher(email);
                        while (matcher.find()) {
                            emailData[1] = matcher.group(2);
                            emailData[2] = matcher.group(1);
                        }
                    } else {
                        emailData[1] = email;
                        emailData[2] = "";
                    }
                    emailData[0] = String.valueOf(index++);
                    currentEmails.add(emailData);
                }
            } else {
                paramValue = new ContractEmailParamValue();
            }
            StringBuilder result = new StringBuilder();
            block3: for (String[] emailData : updateEmails) {
                if (emailData.length != 3) continue;
                if ("-1".equals(emailData[0])) {
                    this.addEmailToResult(result, emailData);
                    continue;
                }
                for (String[] currentEmail : currentEmails) {
                    if (!emailData[0].equals(currentEmail[0])) continue;
                    if (!contractParameterPref.isRead()) {
                        if (emailData[1].indexOf(42) > -1) {
                            emailData[1] = currentEmail[1];
                        }
                        if (PARAM_HIDDEN_VALUE.equals(emailData[2])) {
                            emailData[2] = currentEmail[2];
                        }
                    }
                    this.addEmailToResult(result, emailData);
                    continue block3;
                }
            }
            paramValue.setEmail(result.toString());
            if (Utils.isBlankString((String)paramValue.getEmail())) {
                this.contractParameterManager.deletePhoneParam(this.contract.getId(), this.parameterId, -1);
            } else {
                this.contractParameterManager.updateEmailParam(this.contract.getId(), this.parameterId, paramValue, -1);
            }
            this.context.publishAfterCommit(new ContractParamChangedEvent(-1, this.contractId, this.parameterId, paramValue));
            this.setResultParam("paramId", this.parameterId);
            this.setResultParam("paramType", contractParameterPref.getType().getId());
            this.setResultParam("paramValue", contractParameterPref.isRead() ? result.toString().replace("\n", "; ").replace("<", "&lt;").replace(">", "&gt;") : "");
        }
    }

    private void addEmailToResult(StringBuilder result, String[] emailData) {
        try {
            InternetAddress[] addresses = InternetAddress.parse((String)(emailData[2].trim() + " <" + emailData[1] + ">"));
            if (addresses.length == 1) {
                if (result.length() > 0) {
                    result.append("\n");
                }
                result.append(addresses[0].toUnicodeString());
            }
        }
        catch (AddressException addressException) {
            // empty catch block
        }
    }

    public void getParameterType9() throws BGException {
        this.a();
        ContractParameterPref contractParameterPref = (ContractParameterPref)this.prefDao.get(this.parameterId);
        if (contractParameterPref != null) {
            this.setResultParam("paramTitle", contractParameterPref.getTitle());
            this.setResultParam("paramRead", contractParameterPref.isRead());
            this.setResultParam("paramWrite", contractParameterPref.isWrite());
            this.setResultParam("prefixs", this.setup.get("phones.formats", ""));
            ArrayList<String[]> phones = new ArrayList<String[]>();
            PhoneParamValue paramValue = this.contractParameterManager.getPhoneParam(this.contract.getId(), this.parameterId);
            if (paramValue != null) {
                String formats = this.setup.get("phones.formats");
                for (PhoneParamItem phoneParamItem : paramValue) {
                    String[] phoneData = new String[2];
                    phoneData[0] = PhoneUtils.phoneToFormat((String)formats, (String)phoneParamItem.getPhone());
                    if (contractParameterPref.isRead()) {
                        phoneData[1] = phoneParamItem.getComment();
                    } else {
                        phoneData[0] = Utils.maskPhoneNumber((String)phoneData[0], (int)4, (int)2);
                        phoneData[1] = PARAM_HIDDEN_VALUE;
                    }
                    phones.add(phoneData);
                }
            }
            this.setResultParam("paramValue", phones);
        }
    }

    public void updateParameterType9() throws BGException, SQLException {
        this.a();
        ContractParameterPref contractParameterPref = (ContractParameterPref)this.prefDao.get(this.parameterId);
        if (contractParameterPref != null && contractParameterPref.isWrite()) {
            ArrayList<String[]> updatePhones = new ArrayList<String[]>();
            String parameterValue = this.req.get("parameterValue");
            if (parameterValue != null) {
                for (String splits : parameterValue.split("\n")) {
                    updatePhones.add(splits.split("\t"));
                }
            }
            ArrayList<PhoneParamItem> currentPhones = new ArrayList<PhoneParamItem>();
            PhoneParamValue paramValue = this.contractParameterManager.getPhoneParam(this.contract.getId(), this.parameterId);
            if (paramValue != null) {
                Iterator<PhoneParamItem> iterator = paramValue.iterator();
                while (iterator.hasNext()) {
                    currentPhones.add(iterator.next());
                }
            } else {
                paramValue = new PhoneParamValue();
            }
            int phoneNumberLength = this.setup.getInt("phones.customLengthNumber", 11);
            paramValue.clearParamItems();
            block2: for (String[] phoneData : updatePhones) {
                if (phoneData.length != 3) continue;
                if ("-1".equals(phoneData[0])) {
                    String phoneNumber = phoneData[1].replaceAll("[^\\d]", "");
                    if (phoneNumber.length() != phoneNumberLength) continue;
                    PhoneParamItem phoneParamItem = new PhoneParamItem();
                    phoneParamItem.setPhone(phoneNumber);
                    phoneParamItem.setFormat("");
                    phoneParamItem.setComment(phoneData[2]);
                    paramValue.addPhoneItem(phoneParamItem);
                    continue;
                }
                for (int index = 0; index < currentPhones.size(); ++index) {
                    if (Utils.parseInt((String)phoneData[0], (int)-1) != index) continue;
                    String phoneNumber = phoneData[1].replaceAll("[^\\d]", "");
                    PhoneParamItem phoneParamItem = (PhoneParamItem)currentPhones.get(index);
                    if ((!contractParameterPref.isRead() && phoneData[1].indexOf(42) == -1 || contractParameterPref.isRead()) && phoneNumber.length() == phoneNumberLength) {
                        phoneParamItem.setPhone(phoneNumber);
                    }
                    if (!contractParameterPref.isRead() && !PARAM_HIDDEN_VALUE.equals(phoneData[2]) || contractParameterPref.isRead()) {
                        phoneParamItem.setComment(phoneData[2]);
                    }
                    paramValue.addPhoneItem(phoneParamItem);
                    continue block2;
                }
            }
            paramValue.setPhones(PhoneUtils.getPhones((PhoneParamValue)paramValue, (String)this.setup.get("phones.formats")));
            if (paramValue.size() == 0) {
                this.contractParameterManager.deletePhoneParam(this.contract.getId(), this.parameterId, -1);
            } else {
                this.contractParameterManager.updatePhoneParam(this.contract.getId(), this.parameterId, paramValue, -1);
            }
            this.context.publishAfterCommit(new ContractParamChangedEvent(-1, this.contractId, this.parameterId, paramValue));
            this.setResultParam("paramId", this.parameterId);
            this.setResultParam("paramType", contractParameterPref.getType().getId());
            this.setResultParam("paramValue", contractParameterPref.isRead() ? paramValue.getPhones() : PARAM_HIDDEN_VALUE);
        }
    }

    public void getParameterType11() throws BGException, SQLException {
        this.a();
        ContractParameterPref contractParameterPref = (ContractParameterPref)this.prefDao.get(this.parameterId);
        if (contractParameterPref != null) {
            this.setResultParam("paramTitle", contractParameterPref.getTitle());
            this.setResultParam("paramRead", contractParameterPref.isRead());
            this.setResultParam("paramWrite", contractParameterPref.isWrite());
            MultiListParamValues multiListParamValue = this.contractParameterManager.getMultiListParamValues(this.contract.getId(), this.parameterId);
            String paramValue = multiListParamValue.getIdValue();
            if (!Utils.isEmptyString((String)paramValue)) {
                paramValue = paramValue.replaceAll("-1;", "");
            }
            this.setResultParam("paramValue", contractParameterPref.isRead() && multiListParamValue != null ? paramValue : "-1");
            this.setResultParam("paramCustomValue", contractParameterPref.isRead() && multiListParamValue != null ? multiListParamValue.getCustomValue() : "");
            this.setResultParam("paramValues", this.contractParameterManager.getMultiListValues(this.parameterId));
        }
    }

    public void updateParameterType11() throws BGException, SQLException {
        this.a();
        ContractParameterPref contractParameterPref = (ContractParameterPref)this.prefDao.get(this.parameterId);
        if (contractParameterPref != null && contractParameterPref.isWrite()) {
            String idValue = this.req.get("parameterValue");
            if (!Utils.isEmptyString((String)idValue)) {
                idValue = idValue.replaceAll(",", ";");
            }
            String customValue = this.req.get("parameterCustomValue");
            MultiListParamValues multiListParamValues = new MultiListParamValues();
            if (!Utils.isEmptyString((String)idValue)) {
                multiListParamValues.parseValue(idValue);
            }
            if (!Utils.isEmptyString((String)customValue)) {
                multiListParamValues.parseCustomValue(customValue);
            }
            this.contractParameterManager.updateMultiListParameterAndItems(this.contract.getId(), this.parameterId, multiListParamValues, -1);
            this.context.publishAfterCommit(new ContractParamChangedEvent(-1, this.contractId, this.parameterId, multiListParamValues));
            multiListParamValues = this.contractParameterManager.getMultiListParamValues(this.contract.getId(), this.parameterId);
            this.setResultParam("paramId", this.parameterId);
            String multiListValue = Utils.isEmptyString((String)multiListParamValues.toStringValue()) ? "" : multiListParamValues.toStringValue();
            this.setResultParam("paramValue", contractParameterPref.isRead() ? multiListValue : "");
            this.setResultParam("paramType", contractParameterPref.getType().getId());
        }
    }

    private void a() {
        if (this.context.getRequest().getParameter("ct") == null) {
            this.context.getRequest().setAttribute("contentType", (Object)ActionResultContentType.jsp);
        }
        if (this.contractParameterManager == null) {
            this.contractParameterManager = new ContractParameterManager(this.con);
        }
        if (this.prefDao == null) {
            this.prefDao = new ContractParameterPrefDao(this.con);
        }
        this.parameterId = this.req.getInt("parameterId", 0);
        this.contract = (Contract)this.context.getRequest().getSession().getAttribute("contract_current");
    }
}

