/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.object.action;

import bitel.billing.server.contract.bean.ContractMemo;
import bitel.billing.server.contract.bean.ContractMemoManager;
import bitel.billing.server.contract.bean.ContractUtils;
import bitel.billing.server.contract.object.action.base.ActionBase;
import bitel.billing.server.contract.object.bean.ContractObject;
import bitel.billing.server.contract.object.bean.ObjectManager;
import java.sql.SQLException;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.system.ObjectMoveEvent;

public class ActionMoveObject
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int objectId = this.getIntParameter("oid", -1);
        int cidTo = this.getIntParameter("cid_to", -1);
        if (this.cid <= 0 || cidTo <= 0 || objectId <= 0) {
            throw new BGIllegalArgumentException();
        }
        ObjectManager objectManager = new ObjectManager(this.con);
        ContractUtils cu = new ContractUtils(this.con);
        ContractMemoManager memoManager = new ContractMemoManager(this.con);
        EventProcessor.getInstance().request(new ObjectMoveEvent(this.userId, this.cid, objectId, cidTo));
        ContractObject object = objectManager.getObject(objectId);
        object.setContractId(cidTo);
        objectManager.moveObject(objectId, cidTo);
        String contractFrom = cu.getContractTitle(this.cid, true);
        String contractTo = cu.getContractTitle(this.cid, true);
        ContractMemo memo = new ContractMemo();
        memo.setSubject("\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d \u043e\u0431\u044a\u0435\u043a\u0442");
        memo.setComment("\u041e\u0431\u044a\u0435\u043a\u0442 " + object.getTitle() + " \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d \u0438\u0437 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " + contractFrom + " \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + contractTo);
        memo.setTime(new Date());
        memo.setContractId(this.cid);
        memoManager.updateMemo(memo);
        memo.setId(0);
        memo.setContractId(cidTo);
        memoManager.updateMemo(memo);
    }
}

