/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.multipart;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletInputStream;
import ru.bitel.bgbilling.kernel.base.server.multipart.MacBinaryDecoderOutputStream;
import ru.bitel.bgbilling.kernel.base.server.multipart.Part;
import ru.bitel.bgbilling.kernel.base.server.multipart.PartInputStream;

public class FilePart
extends Part {
    private String fileName = null;
    private String filePath = null;
    private String contentType = null;
    private PartInputStream partInput = null;

    FilePart(String name, ServletInputStream servletInputStream, String boundary, String contentType, String fileName, String filePath) throws IOException {
        super(name);
        this.fileName = fileName;
        this.filePath = filePath;
        this.contentType = contentType;
        this.partInput = new PartInputStream(servletInputStream, boundary);
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public InputStream getInputStream() {
        return this.partInput;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    long write(OutputStream out) throws IOException {
        int read;
        if (this.contentType.equals("application/x-macbinary")) {
            out = new MacBinaryDecoderOutputStream(out);
        }
        long size = 0L;
        byte[] buf = new byte[8192];
        while ((read = this.partInput.read(buf)) != -1) {
            out.write(buf, 0, read);
            size += (long)read;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeTo(File fileOrDirectory) throws IOException {
        long written = 0L;
        try (OutputStream fileOut = null;){
            if (this.fileName != null) {
                File file = fileOrDirectory.isDirectory() ? new File(fileOrDirectory, this.fileName) : fileOrDirectory;
                fileOut = new BufferedOutputStream(new FileOutputStream(file));
                written = this.write(fileOut);
            }
        }
        return written;
    }

    public long writeTo(OutputStream out) throws IOException {
        long size = 0L;
        if (this.fileName != null) {
            size = this.write(out);
        }
        return size;
    }
}

