/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree;

import java.math.BigDecimal;
import java.util.Calendar;
import ru.bitel.common.TimeUtils;

public abstract class ServiceCost {
    public int serviceId;
    public Calendar date1;
    public Calendar date2;
    public final Calendar serviceStart;
    public final Calendar serviceEnd;
    public int accountingPeriodDays;
    public long amount;
    public BigDecimal cost;
    public boolean amountNull = false;

    public ServiceCost(int serviceId, Calendar serviceStart, Calendar serviceEnd, Calendar date1, Calendar date2, long amount) {
        this.serviceId = serviceId;
        this.serviceStart = serviceStart;
        this.serviceEnd = serviceEnd;
        this.date1 = date1;
        this.date2 = date2;
        this.amount = amount;
        if (date1 != null && date2 != null) {
            this.accountingPeriodDays = date2.get(5) - date1.get(5) + 1;
        }
    }

    protected String paramsToString() {
        StringBuilder result = new StringBuilder();
        result.append("serviceId: ");
        result.append(this.serviceId);
        result.append("; date1: ");
        result.append(TimeUtils.formatDate((Calendar)this.date1));
        result.append("; date2: ");
        result.append(TimeUtils.formatDate((Calendar)this.date2));
        result.append("; serviceStart: ");
        result.append(TimeUtils.formatDate((Calendar)this.serviceStart));
        result.append("; serviceEnd: ");
        result.append(TimeUtils.formatDate((Calendar)this.serviceEnd));
        result.append("; accountingPeriodDays: ");
        result.append(this.accountingPeriodDays);
        result.append("; amount: ");
        result.append(this.amount);
        result.append("; cost: ");
        result.append(this.cost);
        return result.toString();
    }

    public ServiceCost newCost() {
        ServiceCost result = this.newCostInternal();
        result.amountNull = this.amountNull;
        return result;
    }

    protected ServiceCost newCostInternal() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder result = new StringBuilder(100);
        result.append("ServiceCost [");
        result.append(this.paramsToString());
        result.append("]");
        return result.toString();
    }
}

