/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.installer.server;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.bean.ModuleManager;
import ru.bitel.bgbilling.server.installer.InstallerModule;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.XMLUtils;

public class ComponentUpdate {
    private Logger logger = LogManager.getLogger();

    public ComponentUpdate(Setup setup) {
        try {
            Connection connection = setup.getDBConnectionFromPool();
            Statement st = connection.createStatement();
            st.executeUpdate("UPDATE installed_modules SET pack_server=LEFT(pack_server,LENGTH(pack_server)-7) WHERE pack_server LIKE '%.action'");
            st.executeUpdate("UPDATE installed_modules SET pack_server=LEFT(pack_server,LENGTH(pack_server)-9) WHERE pack_server LIKE '%.register'");
            st.executeUpdate("UPDATE `module` SET `title`='Yoomoney', `name`='yoomoney' WHERE name='yamoney'");
            st.executeUpdate("UPDATE `installed_modules` SET `pack_server`=REPLACE(`pack_server`, 'yamoney', 'yoomoney'), `pack_client`=REPLACE(`pack_client`, 'yamoney', 'yoomoney'), name='yoomoney', title='Yoomoney' WHERE name='yamoney'");
            st.close();
            String querySet = " SET `name`=?, `title`=?, `pack_server`=?, `pack_client`=?, `type`=?, `init`=?, `uninstall`=?";
            PreparedStatement psSelect = connection.prepareStatement("SELECT id FROM installed_modules WHERE name=?");
            PreparedStatement psInsert = connection.prepareStatement("INSERT INTO installed_modules" + querySet);
            PreparedStatement psUpdate = connection.prepareStatement("UPDATE installed_modules" + querySet + " WHERE id=?");
            try {
                Path path = Paths.get("./components", new String[0]);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Component path => " + path);
                }
                if (Files.exists(path, new LinkOption[0])) {
                    Files.newDirectoryStream(path).forEach(componentDir -> {
                        block39: {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("Found component directory => " + componentDir);
                            }
                            try {
                                boolean update = false;
                                Path updatePath = Paths.get(componentDir.toString(), "update");
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug("Component updatePath => " + updatePath);
                                }
                                if (Files.exists(updatePath, new LinkOption[0]) && Files.isRegularFile(updatePath, new LinkOption[0])) {
                                    update = Boolean.valueOf(Files.readString(updatePath));
                                }
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug("Component update flag => " + update);
                                }
                                if (!update) break block39;
                                String init = "";
                                Path initPath = Paths.get(componentDir.toString(), "init");
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug("Component initPath => " + initPath);
                                }
                                if (Files.exists(initPath, new LinkOption[0]) && Files.isRegularFile(initPath, new LinkOption[0])) {
                                    init = Files.readString(initPath);
                                }
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug("Component init:\n" + init);
                                }
                                String uninstall = "";
                                Path uninstallPath = Paths.get(componentDir.toString(), "uninstall");
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug("Component uninstallPath => " + uninstallPath);
                                }
                                if (Files.exists(uninstallPath, new LinkOption[0]) && Files.isRegularFile(uninstallPath, new LinkOption[0])) {
                                    uninstall = Files.readString(uninstallPath);
                                }
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug("Component uninstall:\n" + uninstall);
                                }
                                Path moduleXmlPath = Paths.get(componentDir.toString(), "module.xml");
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug("Component moduleXmlPath => " + moduleXmlPath);
                                }
                                if (Files.exists(moduleXmlPath, new LinkOption[0]) && Files.isRegularFile(moduleXmlPath, new LinkOption[0])) {
                                    Document document;
                                    Element informationElement;
                                    if (this.logger.isDebugEnabled()) {
                                        this.logger.debug("Component module.xml:\n" + Files.readString(moduleXmlPath));
                                    }
                                    if ((informationElement = XMLUtils.selectElement((Node)(document = XMLUtils.parseDocument((byte[])Files.readAllBytes(moduleXmlPath))), (String)"/module/information")) != null) {
                                        int parameterIndex;
                                        String componentName = XMLUtils.getAttribute((Element)informationElement, (String)"name");
                                        String componentType = XMLUtils.getAttribute((Element)informationElement, (String)"type");
                                        String componentTitle = XMLUtils.selectText((Node)informationElement, (String)"title");
                                        String clientPackage = XMLUtils.getAttribute((Element)informationElement, (String)"pack_client");
                                        String serverPackage = XMLUtils.getAttribute((Element)informationElement, (String)"pack_server");
                                        if (this.logger.isDebugEnabled()) {
                                            this.logger.debug("componentName = " + componentName);
                                            this.logger.debug("componentType = " + componentType);
                                            this.logger.debug("componentTitle = " + componentTitle);
                                            this.logger.debug("clientPackage = " + clientPackage);
                                            this.logger.debug("serverPackage = " + serverPackage);
                                        }
                                        int componentId = 0;
                                        psSelect.setString(1, componentName);
                                        ResultSet rs = psSelect.executeQuery();
                                        while (rs.next()) {
                                            componentId = rs.getInt(1);
                                        }
                                        rs.close();
                                        if (componentId > 0) {
                                            parameterIndex = 1;
                                            psUpdate.setString(parameterIndex++, componentName);
                                            psUpdate.setString(parameterIndex++, componentTitle);
                                            psUpdate.setString(parameterIndex++, serverPackage);
                                            psUpdate.setString(parameterIndex++, clientPackage);
                                            psUpdate.setString(parameterIndex++, componentType);
                                            psUpdate.setString(parameterIndex++, init);
                                            psUpdate.setString(parameterIndex++, uninstall);
                                            psUpdate.setInt(parameterIndex++, componentId);
                                            if (this.logger.isDebugEnabled()) {
                                                this.logger.debug(psUpdate.toString());
                                            }
                                            psUpdate.executeUpdate();
                                        } else {
                                            parameterIndex = 1;
                                            psInsert.setString(parameterIndex++, componentName);
                                            psInsert.setString(parameterIndex++, componentTitle);
                                            psInsert.setString(parameterIndex++, serverPackage);
                                            psInsert.setString(parameterIndex++, clientPackage);
                                            psInsert.setString(parameterIndex++, componentType);
                                            psInsert.setString(parameterIndex++, init);
                                            psInsert.setString(parameterIndex++, uninstall);
                                            psInsert.executeUpdate();
                                            if (this.logger.isDebugEnabled()) {
                                                this.logger.debug(psInsert.toString());
                                            }
                                            componentId = ServerUtils.lastInsertId(connection);
                                        }
                                        if (componentType.equals("module")) {
                                            if (this.logger.isDebugEnabled()) {
                                                this.logger.debug("Reinit module instanses");
                                            }
                                            for (BGModule module : (ArrayList)new ModuleManager(connection).getModules(componentName)) {
                                                if (this.logger.isDebugEnabled()) {
                                                    this.logger.debug("ReInit module => " + module.getId());
                                                }
                                                InstallerModule.initModule(connection, componentName, module.getId());
                                            }
                                        } else if (componentType.equals("plugin")) {
                                            if (this.logger.isDebugEnabled()) {
                                                this.logger.debug("ReInit plugin id=" + componentId);
                                            }
                                            InstallerModule.initModule(connection, componentName, componentId);
                                        } else if (componentType.equals("update")) {
                                            if (this.logger.isDebugEnabled()) {
                                                this.logger.debug("Update kernel...");
                                            }
                                            for (Element element : XMLUtils.selectElements((Node)document, (String)"/module/resources/call")) {
                                                String clazz = element.getAttribute("class");
                                                String param = element.getAttribute("param");
                                                if (!"ExecuteSQL".equals(clazz)) continue;
                                                if (this.logger.isDebugEnabled()) {
                                                    this.logger.debug("ExecuteSQL: class = " + clazz + "; param = " + param);
                                                }
                                                String query = null;
                                                Path sqlPath = Paths.get(componentDir.toString(), param);
                                                if (Files.exists(sqlPath, new LinkOption[0]) && Files.isRegularFile(sqlPath, new LinkOption[0])) {
                                                    query = Files.readString(sqlPath);
                                                } else {
                                                    this.logger.error(sqlPath + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                                                }
                                                if (query == null) continue;
                                                Connection con = null;
                                                try {
                                                    con = setup.getDBConnection();
                                                    InstallerModule.executeSqlComands(con, query.split(";\\s*\n"), "0");
                                                    this.logger.info("Executing database update... OK");
                                                }
                                                finally {
                                                    ServerUtils.closeConnection(con);
                                                }
                                            }
                                        }
                                    }
                                }
                                Files.writeString(updatePath, (CharSequence)"false", new OpenOption[0]);
                            }
                            catch (Exception e) {
                                this.logger.error((Object)e);
                            }
                        }
                    });
                }
            }
            catch (IOException e) {
                this.logger.error((Object)e);
            }
            psSelect.close();
            psInsert.close();
            psUpdate.close();
            ServerUtils.closeConnection(connection);
        }
        catch (SQLException e) {
            this.logger.error((Object)e);
        }
    }
}

