/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.oss.kernel.directories.address.common.bean.Country;

public class CountryDao
extends AbstractIdDao<Country>
implements Directory<Country> {
    public CountryDao(Connection con) {
        super(con, 0, "address_country");
    }

    protected Country getFromRS(ResultSet rs) throws SQLException, BGException {
        Country result = new Country();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        return result;
    }

    protected void updateImpl(Country b) throws BGException, SQLException {
        PreparedStatement ps;
        if (b.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (title) VALUES (?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET title=? WHERE id=?");
            ps.setInt(2, b.getId());
        }
        ps.setString(1, b.getTitle());
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    @Override
    public List<Country> list() throws BGException {
        return super.list(null, "title", new Object[0]);
    }

    public List<Country> list(String title) throws BGException {
        return super.list("(? OR title LIKE ?)", "title", new Object[]{Utils.isBlankString((String)title), title + "%"});
    }

    @Override
    public Country get(String title) throws BGException {
        return (Country)super.get("title=?", new Object[]{title});
    }
}

