/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.server.bean.AbstractCityItemDao;

public class StreetDao
extends AbstractCityItemDao<Street> {
    public StreetDao(Connection con) {
        super(con, "address_street");
    }

    @Override
    protected Street newBean() {
        return new Street();
    }

    public String getPostIndex(int streetId) throws BGException {
        String index = null;
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT p_index FROM " + this.tableName + " WHERE id=?");
            ps.setInt(1, streetId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                index = rs.getString(1);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return index;
    }

    public List<Street> search(int cityId, String title, String cityTitle, Page page) throws BGException {
        if (Utils.isBlankString((String)title) && Utils.isBlankString((String)cityTitle)) {
            return this.list(cityId, title);
        }
        try {
            int pageIndex;
            int pageSize;
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT street.*, city.title as cityTitle, CONCAT(city.title, ', ', street.title) as tt FROM address_street as street");
            sb.append(" LEFT JOIN address_city as city ON city.id=street.cityid");
            sb.append(" WHERE (? OR city.title LIKE ?)");
            String[] args = title.split("\\s+");
            int n = 0;
            int nl = 0;
            if (Utils.notBlankString((String)title)) {
                sb.append(" AND (city.title LIKE ? OR street.title LIKE ?) HAVING");
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].length() <= 0) continue;
                    if (args[i].length() > nl) {
                        n = i;
                        nl = args[i].length();
                    }
                    sb.append(" tt LIKE ? AND");
                }
                sb.setLength(sb.length() - 4);
            }
            sb.append(" ORDER BY street.title");
            if (page != null) {
                pageSize = page.getPageSize();
                pageIndex = page.getPageIndex();
                if (pageIndex <= 0) {
                    pageSize = 0;
                }
            } else {
                pageSize = 0;
                pageIndex = 0;
            }
            if (pageSize > 0 && pageIndex > 0) {
                sb.append(" LIMIT ?, ?");
            }
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            int idx = 0;
            ps.setBoolean(++idx, Utils.isBlankString((String)cityTitle));
            ps.setString(++idx, "%" + cityTitle + "%");
            if (Utils.notBlankString((String)title)) {
                ps.setString(++idx, "%" + args[n] + "%");
                ps.setString(++idx, "%" + args[n] + "%");
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].length() <= 0) continue;
                    ps.setString(++idx, "%" + args[i] + "%");
                }
            }
            if (pageSize > 0) {
                ps.setInt(++idx, (pageIndex - 1) * pageSize);
                ps.setInt(++idx, pageSize);
            }
            ArrayList<Street> result = new ArrayList<Street>();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Street street = (Street)this.getFromRS(rs);
                street.setCityTitle(rs.getString("cityTitle"));
                result.add(street);
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

