/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrContract;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDefaultDao;

class EntityAttrContractDao
extends EntityAttrDefaultDao<EntityAttrContract> {
    private String listValueTable = "contract";

    public EntityAttrContractDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String listTable) {
        super(con, entityAttrDao, listTable);
    }

    @Override
    protected void createTable() {
    }

    @Override
    protected PreparedStatement getSelectPS(int entityId, int entitySpecAttrId) throws SQLException {
        PreparedStatement selectPS = this.con.prepareStatement("SELECT v." + this.valueName() + ", t.title FROM " + this.table + " as v LEFT JOIN " + this.listValueTable + " as t ON t.id=v." + this.valueName() + " WHERE v." + this.idName() + "=? AND v." + this.typeName() + "=?");
        selectPS.setInt(1, entityId);
        selectPS.setInt(2, entitySpecAttrId);
        return selectPS;
    }

    @Override
    public EntityAttrContract get(int entityId, int attrSpecId) throws SQLException {
        EntityAttrContract result = null;
        try (PreparedStatement ps = this.getSelectPS(entityId, attrSpecId);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                result = new EntityAttrContract(entityId, attrSpecId, rs.getInt(1), rs.getString(2));
            }
        }
        return result;
    }

    @Override
    public void insert(int entityId, EntityAttr a) throws SQLException {
        try (PreparedStatement ps = this.getInsertPS(entityId, a.getEntitySpecAttrId());){
            ps.setInt(3, ((EntityAttrContract)a).getValue());
            ps.executeUpdate();
        }
    }

    @Override
    public boolean updateImpl(int entityId, EntityAttrContract attr) throws SQLException {
        boolean update = false;
        try (PreparedStatement ps = this.getUpdatePS(entityId, attr.getEntitySpecAttrId());){
            ps.setInt(1, attr.getValue());
            update = ps.executeUpdate() == 0;
        }
        if (update) {
            ps = this.getInsertPS(entityId, attr.getEntitySpecAttrId());
            try {
                ps.setInt(3, attr.getValue());
                ps.executeUpdate();
                boolean bl = true;
                return bl;
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        int oldValue = 0;
        try (PreparedStatement ps = this.entityAttrDao.getSelectOldValuePS();
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                oldValue = rs.getInt(1);
            }
        }
        return attr.getValue() != oldValue;
    }

    @Override
    protected void insertHistory(int contractId, EntityAttrContract attr) throws SQLException {
        try (PreparedStatement insertHistoryPS = this.con.prepareStatement("INSERT INTO " + this.table + "_log SET  " + this.idName() + "=?, " + this.typeName() + "=?, val=?, title=?, dt_change=?, user_id=?");){
            insertHistoryPS.setInt(1, contractId);
            insertHistoryPS.setInt(2, attr.getEntitySpecAttrId());
            insertHistoryPS.setInt(3, attr != null ? Integer.valueOf(attr.getValue()) : null);
            insertHistoryPS.setString(4, attr != null ? attr.toString() : null);
            insertHistoryPS.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
            insertHistoryPS.setInt(6, this.entityAttrDao.userId);
            insertHistoryPS.executeUpdate();
        }
    }
}

