/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.option.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.FloatTextField;
import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.EventHandler;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ChargeType;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.ChargeService;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOptionActivateMode;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.KeyValue;

public class TariffOptionActivateModesEditor
extends BGUPanel {
    private TariffOptionActivateMode mode;
    private BGTableModel<TariffOptionActivateMode> model;
    private BGUTable table;
    private BGEditor editor;

    public TariffOptionActivateModesEditor() {
        super(new GridBagLayout());
    }

    @Override
    protected void jbInit() {
        this.model = new BGTableModel<TariffOptionActivateMode>("activate_mode"){

            @Override
            protected void initColumns() {
                this.addColumn("", 0, 0, 0, "chargeTypeId", false);
                this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", String.class, -1, 100, -1, "period", false);
                this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", String.class, -1, 150, -1, "title", false);
                this.addColumn("\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f", String.class, -1, 150, -1, null, false);
                this.addColumn("\u0420\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f", String.class, -1, 150, -1, null, false);
                this.addColumn("\u0422\u0438\u043f \u0440\u0430\u0441\u0445\u043e\u0434\u0430", String.class, -1, 150, -1, "chargeTypeTitle", false);
                this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c", String.class, -1, 50, -1, "chargeSumma", false);
            }

            @Override
            public Object getValue(TariffOptionActivateMode val, int column) throws BGException {
                switch (column) {
                    case 1: {
                        return TimeUtils.formatPeriod(val.getDateFrom(), val.getDateTo());
                    }
                    case 2: {
                        return val;
                    }
                    case 3: {
                        if (val.getPeriodCol() != 0) {
                            return "";
                        }
                        switch (val.getDeactivationMode()) {
                            case 0: {
                                return "\u043c\u043e\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u043e";
                            }
                            case 4: {
                                return "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0447\u0430\u0441\u0430";
                            }
                            case 1: {
                                return "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0434\u043d\u044f";
                            }
                            case 2: {
                                return "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043d\u0435\u0434\u0435\u043b\u0438";
                            }
                            case 3: {
                                return "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043c\u0435\u0441\u044f\u0446\u0430";
                            }
                            case 5: {
                                return "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0433\u043e\u0434\u0430";
                            }
                        }
                        return null;
                    }
                    case 4: {
                        if (val.getPeriodCol() != 0) {
                            return "";
                        }
                        switch (val.getReactivationMode()) {
                            case 0: {
                                return "\u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430";
                            }
                            case 1: {
                                return "\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0430";
                            }
                        }
                        return null;
                    }
                }
                return super.getValue(val, column);
            }
        };
        this.table = new BGUTable(this.model);
        this.editor = new BGEditor();
        this.editor.setVisible(false);
        this.editor.addForm(new Editor());
        BGSwingUtilites.handleEdit(this.table, this.editor);
        this.editor.addPropertyChangeListener("edit", EventHandler.create(PropertyChangeListener.class, this.table, "enabled", "oldValue"));
        BGDialogToolBar toolBar = new BGDialogToolBar();
        this.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 0), 0, 0));
        this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        this.add((Component)this.editor, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        BGSwingUtilites.buildToolBar(toolBar, this);
        toolBar.setFloatable(false);
        toolBar.compact();
    }

    public void setData(List<TariffOptionActivateMode> modeList) {
        this.model.setData(modeList);
        this.editor.performAction("close");
    }

    public List<TariffOptionActivateMode> getData() {
        return this.model.getRows();
    }

    private class Editor
    extends BGUPanel {
        private BGTextField title;
        private BGUComboBox<KeyValue<Integer, String>> periodModeField;
        private BGUComboBox<KeyValue<Integer, String>> periodModeBegin;
        private BGUComboBox<KeyValue<Integer, String>> periodModeEnd;
        private BGUComboBox<KeyValue<Integer, String>> deactivationModeCB;
        private BGUComboBox<KeyValue<Integer, String>> reactivationModeCB;
        private BGUComboBox<KeyValue<Integer, String>> deleteModeCB;
        private BGUComboBox<KeyValue<Integer, String>> deleteChargeModeCB;
        private IntTextField periodColTF;
        private BGComboBox<ComboBoxItem> chargeTypeCB;
        private FloatTextField chargeSummTF;
        private BGControlPanelPeriodNoB period;

        public Editor() {
            super(new GridBagLayout());
        }

        @Override
        protected void jbInit() {
            this.title = new BGTextField();
            this.periodModeField = new BGUComboBox(KeyValue.class, Integer.class, String.class);
            this.periodModeBegin = new BGUComboBox(KeyValue.class, Integer.class, String.class);
            this.periodModeEnd = new BGUComboBox(KeyValue.class, Integer.class, String.class);
            this.deactivationModeCB = new BGUComboBox(KeyValue.class, Integer.class, String.class);
            this.reactivationModeCB = new BGUComboBox(KeyValue.class, Integer.class, String.class);
            this.deleteModeCB = new BGUComboBox(KeyValue.class, Integer.class, String.class);
            this.deleteChargeModeCB = new BGUComboBox(KeyValue.class, Integer.class, String.class);
            this.periodColTF = new IntTextField(5);
            this.chargeTypeCB = new BGComboBox();
            this.chargeSummTF = new FloatTextField(7);
            this.period = new BGControlPanelPeriodNoB();
            this.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.title, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            panel.add((Component)this.period, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 3), 0, 0));
            this.add((Component)panel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 0, 0), 0, 0));
            this.add((Component)new JLabel("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043d\u0430"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 0, 0), 0, 0));
            panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.periodColTF, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 3, 0, 0), 0, 0));
            panel.add(this.periodModeField, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 3, 0, 0), 0, 0));
            panel.add(this.periodModeBegin, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 3, 0, 0), 0, 0));
            panel.add(this.periodModeEnd, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 3, 0, 0), 0, 0));
            this.add((Component)panel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel("\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 0, 0), 0, 0));
            panel = new JPanel(new GridBagLayout());
            panel.add(this.deactivationModeCB, new GridBagConstraints(6, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 3, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0420\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f"), new GridBagConstraints(7, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
            panel.add(this.reactivationModeCB, new GridBagConstraints(8, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 3, 0, 3), 0, 0));
            this.add((Component)panel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 0, 0), 0, 0));
            panel = new JPanel(new GridBagLayout());
            panel.add(this.deleteModeCB, new GridBagConstraints(10, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 3, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0440\u0430\u0441\u0445\u043e\u0434\u0430"), new GridBagConstraints(11, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
            panel.add(this.deleteChargeModeCB, new GridBagConstraints(12, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 3, 0, 3), 0, 0));
            this.add((Component)panel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel("\u0421\u043d\u044f\u0442\u044c \u0440\u0430\u0441\u0445\u043e\u0434 "), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 0, 0), 0, 0));
            panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.chargeSummTF, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 3, 0, 0), 0, 0));
            panel.add(this.chargeTypeCB, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 3, 0, 3), 0, 0));
            this.add((Component)panel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.setBorder(BorderFactory.createCompoundBorder(new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
            this.periodColTF.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.check();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.check();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.check();
                }

                private void check() {
                    if (Utils.parseLong(Editor.this.periodColTF.getText()) == 0L) {
                        Editor.this.deactivationModeCB.setEnabled(true);
                        Editor.this.reactivationModeCB.setEnabled(true);
                    } else {
                        Editor.this.deactivationModeCB.setEnabled(false);
                        Editor.this.reactivationModeCB.setEnabled(false);
                    }
                }
            });
            this.deleteModeCB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if ((Integer)((KeyValue)Editor.this.deleteModeCB.getSelectedItem()).getKey() == 0) {
                        Editor.this.deleteChargeModeCB.setEnabled(false);
                    } else {
                        Editor.this.deleteChargeModeCB.setEnabled(true);
                    }
                }
            });
        }

        private void initEdit() throws BGException {
            ArrayList<KeyValue<Integer, String>> data = new ArrayList<KeyValue<Integer, String>>();
            data.add(new KeyValue<Integer, String>(1, "\u043c\u0438\u043d\u0443\u0442"));
            data.add(new KeyValue<Integer, String>(2, "\u0447\u0430\u0441\u043e\u0432"));
            data.add(new KeyValue<Integer, String>(3, "\u0434\u043d\u0435\u0439"));
            data.add(new KeyValue<Integer, String>(4, "\u043d\u0435\u0434\u0435\u043b\u044c"));
            data.add(new KeyValue<Integer, String>(5, "\u043c\u0435\u0441\u044f\u0446\u0435\u0432"));
            data.add(new KeyValue<Integer, String>(6, "\u043b\u0435\u0442"));
            this.periodModeField.setData(data);
            data = new ArrayList();
            data.add(new KeyValue<Integer, String>(1, "\u0441 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u043c\u043e\u043c\u0435\u043d\u0442\u0430"));
            data.add(new KeyValue<Integer, String>(2, "\u0441 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e(\u0435\u0439)"));
            data.add(new KeyValue<Integer, String>(3, "\u0441\u043e \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e(\u0435\u0439)"));
            data.add(new KeyValue<Integer, String>(4, "\u0441\u043e \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e \u0447\u0430\u0441\u0430"));
            this.periodModeBegin.setData(data);
            data = new ArrayList();
            data.add(new KeyValue<Integer, String>(1, "\u0440\u043e\u0432\u043d\u043e"));
            data.add(new KeyValue<Integer, String>(2, "\u043e\u043a\u0440\u0443\u0433\u043b\u0435\u043d\u043d\u043e"));
            this.periodModeEnd.setData(data);
            data = new ArrayList();
            data.add(new KeyValue<Integer, String>(0, "\u043c\u043e\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u043e"));
            data.add(new KeyValue<Integer, String>(4, "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0447\u0430\u0441\u0430"));
            data.add(new KeyValue<Integer, String>(1, "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0434\u043d\u044f"));
            data.add(new KeyValue<Integer, String>(2, "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043d\u0435\u0434\u0435\u043b\u0438"));
            data.add(new KeyValue<Integer, String>(3, "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043c\u0435\u0441\u044f\u0446\u0430"));
            data.add(new KeyValue<Integer, String>(5, "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0433\u043e\u0434\u0430"));
            this.deactivationModeCB.setData(data);
            data = new ArrayList();
            data.add(new KeyValue<Integer, String>(0, "\u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430"));
            data.add(new KeyValue<Integer, String>(1, "\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0430"));
            this.reactivationModeCB.setData(data);
            data = new ArrayList();
            data.add(new KeyValue<Integer, String>(0, "\u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e"));
            data.add(new KeyValue<Integer, String>(1, "\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e \u0434\u043b\u044f \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430"));
            data.add(new KeyValue<Integer, String>(2, "\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e"));
            this.deleteModeCB.setData(data);
            data = new ArrayList();
            data.add(new KeyValue<Integer, String>(0, "\u043d\u0435 \u0443\u0434\u0430\u043b\u044f\u0442\u044c"));
            data.add(new KeyValue<Integer, String>(1, "\u0443\u0434\u0430\u043b\u044f\u0442\u044c \u0435\u0441\u043b\u0438 \u0432\u0440\u0435\u043c\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043d\u0435 \u043d\u0430\u0441\u0442\u0443\u043f\u0438\u043b\u043e"));
            data.add(new KeyValue<Integer, String>(2, "\u0443\u0434\u0430\u043b\u044f\u0442\u044c"));
            this.deleteChargeModeCB.setData(data);
            this.deleteChargeModeCB.setSelectedIndex(1);
            DefaultComboBoxModel<ComboBoxItem> comboBoxModel = new DefaultComboBoxModel<ComboBoxItem>();
            for (ChargeType type : ((ClientContext)this.getContext()).getPort(ChargeService.class).chargeTypeList(1, 0, false)) {
                comboBoxModel.addElement(new ComboBoxItem(type.getId(), type.getTitle()));
            }
            this.chargeTypeCB.setModel(comboBoxModel);
        }

        @Override
        protected void initActions() {
            new AbstractBGUPanel.DefaultAction("new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0440\u0435\u0436\u0438\u043c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws BGException {
                    TariffOptionActivateModesEditor.this.mode = null;
                    Editor.this.initEdit();
                    Editor.this.title.setText("");
                    Editor.this.periodColTF.setText("1");
                    if (Editor.this.chargeTypeCB.getItemCount() > 0) {
                        Editor.this.chargeTypeCB.setSelectedIndex(0);
                    }
                    Editor.this.chargeSummTF.setText("0");
                    Editor.this.period.setDateCalendar1(new GregorianCalendar());
                    Editor.this.period.setDateCalendar2(null);
                    Editor.this.performActionOpen();
                }
            };
            new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0440\u0435\u0436\u0438\u043c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws BGException {
                    TariffOptionActivateModesEditor.this.mode = TariffOptionActivateModesEditor.this.model.getSelectedRow();
                    if (TariffOptionActivateModesEditor.this.mode == null) {
                        return;
                    }
                    Editor.this.initEdit();
                    Editor.this.title.setText(TariffOptionActivateModesEditor.this.mode.getTitle());
                    int[] modeValue = TariffOptionActivateMode.mode(TariffOptionActivateModesEditor.this.mode.getPeriodMode());
                    Editor.this.periodModeField.setSelectedItem(modeValue[0]);
                    Editor.this.periodModeBegin.setSelectedItem(modeValue[1]);
                    Editor.this.periodModeEnd.setSelectedItem(modeValue[2]);
                    Editor.this.periodColTF.setText(String.valueOf(TariffOptionActivateModesEditor.this.mode.getPeriodCol()));
                    Editor.this.deactivationModeCB.setSelectedItem(TariffOptionActivateModesEditor.this.mode.getDeactivationMode());
                    Editor.this.reactivationModeCB.setSelectedItem(TariffOptionActivateModesEditor.this.mode.getReactivationMode());
                    Editor.this.deleteModeCB.setSelectedItem(TariffOptionActivateModesEditor.this.mode.getDeleteMode());
                    Editor.this.deleteChargeModeCB.setSelectedItem(TariffOptionActivateModesEditor.this.mode.getDeleteChargeMode());
                    Editor.this.chargeTypeCB.setSelectedId(Integer.toString(TariffOptionActivateModesEditor.this.mode.getChargeTypeId()));
                    Editor.this.chargeSummTF.setText(Utils.formatBigDecimal(TariffOptionActivateModesEditor.this.mode.getChargeSumma(), 2));
                    Editor.this.period.setDateCalendar1(TimeUtils.convertDateToCalendar(TariffOptionActivateModesEditor.this.mode.getDateFrom()));
                    Editor.this.period.setDateCalendar2(TimeUtils.convertDateToCalendar(TariffOptionActivateModesEditor.this.mode.getDateTo()));
                    Editor.this.performActionOpen();
                }
            };
            new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0440\u0435\u0436\u0438\u043c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws BGException {
                    TariffOptionActivateModesEditor.this.model.deleteSelectedRows();
                    Editor.this.performActionClose();
                }
            };
            new AbstractBGUPanel.DefaultAction("ok", "Ok"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws BGException {
                    ComboBoxItem chargeType;
                    if (TariffOptionActivateModesEditor.this.mode == null) {
                        TariffOptionActivateModesEditor.this.mode = new TariffOptionActivateMode();
                        TariffOptionActivateModesEditor.this.model.getRows().add(TariffOptionActivateModesEditor.this.mode);
                    }
                    if ((chargeType = Editor.this.chargeTypeCB.getSelectedItem()) == null) {
                        ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0440\u0430\u0441\u0445\u043e\u0434\u0430!");
                        return;
                    }
                    TariffOptionActivateModesEditor.this.mode.setTitle(Editor.this.title.getText());
                    int modeField = (Integer)((KeyValue)Editor.this.periodModeField.getSelectedItem()).getKey();
                    int modeBegin = (Integer)((KeyValue)Editor.this.periodModeBegin.getSelectedItem()).getKey();
                    int modeEnd = (Integer)((KeyValue)Editor.this.periodModeEnd.getSelectedItem()).getKey();
                    TariffOptionActivateModesEditor.this.mode.setPeriodMode(modeField + modeBegin * 10 + modeEnd * 100);
                    TariffOptionActivateModesEditor.this.mode.setPeriodCol(Utils.parseInt(Editor.this.periodColTF.getText()));
                    TariffOptionActivateModesEditor.this.mode.setDeactivationMode((Integer)((KeyValue)Editor.this.deactivationModeCB.getSelectedItem()).getKey());
                    TariffOptionActivateModesEditor.this.mode.setReactivationMode((Integer)((KeyValue)Editor.this.reactivationModeCB.getSelectedItem()).getKey());
                    TariffOptionActivateModesEditor.this.mode.setDeleteMode((Integer)((KeyValue)Editor.this.deleteModeCB.getSelectedItem()).getKey());
                    TariffOptionActivateModesEditor.this.mode.setDeleteChargeMode((Integer)((KeyValue)Editor.this.deleteChargeModeCB.getSelectedItem()).getKey());
                    TariffOptionActivateModesEditor.this.mode.setChargeTypeId(Utils.parseInt((String)chargeType.getObject()));
                    TariffOptionActivateModesEditor.this.mode.setChargeTypeTitle(chargeType.toString());
                    TariffOptionActivateModesEditor.this.mode.setChargeSumma(Utils.parseBigDecimal(Editor.this.chargeSummTF.getText(), BigDecimal.ZERO));
                    TariffOptionActivateModesEditor.this.mode.setDateFrom(Editor.this.period.getDateFrom());
                    TariffOptionActivateModesEditor.this.mode.setDateTo(Editor.this.period.getDateTo());
                    Editor.this.performActionClose();
                    TariffOptionActivateModesEditor.this.model.fireTableDataChanged();
                }
            };
        }
    }
}

