/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.task.client.SchedulerTaskPanel;
import ru.bitel.bgbilling.kernel.task.common.SchedulerService;
import ru.bitel.bgbilling.kernel.task.common.bean.LightweightTaskData;
import ru.bitel.bgbilling.kernel.task.common.bean.TaskStatus;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.model.Pair;

public class TaskEditor
extends BGUPanel {
    private BGControlPanelPeriod periodPanel = new BGControlPanelPeriod();
    private JTextArea commentTextArea = new JTextArea("");
    private BGConfigEditorPane params = new BGConfigEditorPane();
    private BGComboBox<ComboBoxItem> moduleNameComboBox = new BGComboBox();
    private BGComboBox<ComboBoxItem> taskNameComboBox = new BGComboBox();
    private JComboBox<ComboBoxItem> priorityComboBox;
    private BGComboBox<TaskStatus> statusComboBox = new BGComboBox();
    private JTextField min = new JTextField("");
    private JTextField hh = new JTextField("");
    private JTextField dm = new JTextField("");
    private JTextField dw = new JTextField("");
    private JTextField mm = new JTextField("");
    private LightweightTaskData currentTask;
    private SchedulerTaskPanel parentPanel;

    public TaskEditor(SchedulerTaskPanel parent) {
        this.parentPanel = parent;
    }

    @Override
    protected void jbInit() throws Exception {
        BGButtonPanel buttonPanel = new BGButtonPanel(BGButtonPanel.RESET, BGButtonPanel.OK, BGButtonPanel.CANCEL);
        buttonPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String actionCommand = e.getActionCommand();
                if (actionCommand.equals("reset")) {
                    TaskEditor.this.performAction("refresh");
                } else if (actionCommand.equals("ok")) {
                    ComboBoxItem selectedItem = TaskEditor.this.taskNameComboBox.getSelectedItem();
                    if (selectedItem != null) {
                        Date dateFrom = TaskEditor.this.periodPanel.getDateFrom();
                        Date dateTo = TaskEditor.this.periodPanel.getDateTo();
                        if (dateFrom != null && dateTo != null && dateFrom.compareTo(dateTo) > 0) {
                            ClientUtils.showErrorMessageDialog("\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0437\u0430\u0434\u0430\u0447\u0438 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0440\u0430\u043d\u0435\u0435 \u0435\u0433\u043e \u043a\u043e\u043d\u0446\u0430!");
                        } else {
                            TaskEditor.this.performAction("save");
                        }
                    } else {
                        ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u0430\u0434\u0430\u0447\u0443!");
                    }
                } else if (actionCommand.equals("cancel")) {
                    TaskEditor.this.setVisible(false);
                }
            }
        });
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add((Component)this.getRunTimePanel(), "\u0412\u0440\u0435\u043c\u044f \u0437\u0430\u043f\u0443\u0441\u043a\u0430");
        tabbedPane.add((Component)this.getRunParamsPanel(), "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0443\u0441\u043a\u0430");
        tabbedPane.add((Component)this.getCommentPanel(), "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.periodPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.getTaskPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)buttonPanel, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)tabbedPane, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
    }

    private JPanel getTaskPanel() {
        ComboBoxItem[] items = new ComboBoxItem[]{new ComboBoxItem(1, "\u043c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439"), new ComboBoxItem(2, "\u043d\u043e\u0440\u043c\u0430\u043b\u044c\u043d\u044b\u0439"), new ComboBoxItem(3, "\u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439")};
        this.priorityComboBox = new JComboBox<ComboBoxItem>(items);
        this.priorityComboBox.setSelectedIndex(1);
        this.statusComboBox.setModel(new DefaultComboBoxModel<TaskStatus>(TaskStatus.values()));
        this.statusComboBox.setSelectedIndex(0);
        this.moduleNameComboBox.addItemListener(e -> this.performAction("moduleChange"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder("\u0417\u0430\u0434\u0430\u0447\u0430"));
        panel.add((Component)new JLabel("\u041c\u043e\u0434\u0443\u043b\u044c:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add(this.moduleNameComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add(this.taskNameComboBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u041f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add(this.priorityComboBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add(this.statusComboBox, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getRunTimePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041c\u0438\u043d\u0443\u0442\u044b:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.min, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u0427\u0430\u0441\u044b:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.hh, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u0414\u043d\u0438 \u043c\u0435\u0441\u044f\u0446\u0430:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.dm, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u0414\u043d\u0438 \u043d\u0435\u0434\u0435\u043b\u0438:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.dw, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u041c\u0435\u0441\u044f\u0446\u044b:"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.mm, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getCommentPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(this.commentTextArea), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getRunParamsPanel() {
        this.params.setText("");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(this.params), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    public void setTask(LightweightTaskData task) throws BGException {
        this.currentTask = task;
        List<Pair<String, String>> modulesPairs = ((ClientContext)this.getContext()).getPort(SchedulerService.class).getModuleAndPluginList();
        ComboBoxItem[] result = new ComboBoxItem[modulesPairs.size()];
        for (int i = 0; i < modulesPairs.size(); ++i) {
            Pair<String, String> current = modulesPairs.get(i);
            result[i] = "-1".equals(current.getFirst()) ? new BGComboBox.Separator(current.getSecond()) : new ComboBoxItem(current.getFirst(), current.getSecond());
        }
        this.moduleNameComboBox.setModel(new DefaultComboBoxModel<ComboBoxItem>(result));
        if (task != null) {
            this.periodPanel.setPeriod(task.getPeriod());
            this.commentTextArea.setText(task.getComment());
            this.params.setText(task.getParams());
            this.priorityComboBox.setSelectedIndex(task.getPriority());
            this.statusComboBox.setSelectedItem((Object)task.getTaskStatus());
            this.mm.setText(Utils.unpackValues(task.getMonth(), 1));
            this.dm.setText(Utils.unpackValues(task.getDay(), 1));
            this.dw.setText(Utils.unpackValues(task.getDayOfWeek(), 1));
            this.hh.setText(Utils.unpackValues(task.getHour(), 0));
            this.min.setText(Utils.unpackValues(task.getMin(), 0));
            ClientUtils.setComboBoxSelection(this.moduleNameComboBox, task.isPlugin() ? "p" + task.getModuleId() : String.valueOf(task.getModuleId()));
            ClientUtils.setComboBoxSelection(this.taskNameComboBox, task.getClassName());
        } else {
            this.periodPanel.setPeriod(null);
            this.commentTextArea.setText("");
            this.params.setText("");
            this.priorityComboBox.setSelectedIndex(1);
            this.statusComboBox.setSelectedIndex(0);
            this.mm.setText("");
            this.dm.setText("");
            this.dw.setText("");
            this.hh.setText("");
            this.min.setText("");
            this.moduleNameComboBox.setSelectedIndex(0);
            this.taskNameComboBox.removeAllItems();
            this.taskNameComboBox.setSelectedIndex(-1);
        }
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0437\u0430\u0434\u0430\u0447\u0443"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                TaskEditor.this.setTask(TaskEditor.this.currentTask);
            }
        };
        new AbstractBGUPanel.DefaultAction("save", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0437\u0430\u0434\u0430\u0447\u0443"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (TaskEditor.this.currentTask == null) {
                    TaskEditor.this.currentTask = new LightweightTaskData();
                }
                ClientUtils.checkValues(TaskEditor.this.min, 0, 59);
                ClientUtils.checkValues(TaskEditor.this.hh, 0, 23);
                ClientUtils.checkValues(TaskEditor.this.dw, 1, 7);
                ClientUtils.checkValues(TaskEditor.this.dm, 1, 31);
                ClientUtils.checkValues(TaskEditor.this.mm, 1, 12);
                TaskEditor.this.currentTask.setMin(Utils.packValues(Utils.toList(TaskEditor.this.min.getText()), 0));
                TaskEditor.this.currentTask.setHour((int)Utils.packValues(Utils.toList(TaskEditor.this.hh.getText()), 0));
                TaskEditor.this.currentTask.setDay((int)Utils.packValues(Utils.toList(TaskEditor.this.dm.getText()), 1));
                TaskEditor.this.currentTask.setDayOfWeek((int)Utils.packValues(Utils.toList(TaskEditor.this.dw.getText()), 1));
                TaskEditor.this.currentTask.setMonth((int)Utils.packValues(Utils.toList(TaskEditor.this.mm.getText()), 1));
                TaskEditor.this.currentTask.setPeriod(TaskEditor.this.periodPanel.getPeriod());
                TaskEditor.this.currentTask.setTaskStatus(TaskEditor.this.statusComboBox.getSelectedItem());
                TaskEditor.this.currentTask.setPriority(TaskEditor.this.priorityComboBox.getSelectedIndex());
                TaskEditor.this.currentTask.setComment(TaskEditor.this.commentTextArea.getText());
                TaskEditor.this.currentTask.setParams(TaskEditor.this.params.getText());
                TaskEditor.this.currentTask.setClassName(TaskEditor.this.taskNameComboBox.getSelectedItem().getObject().toString());
                String selectedItem = TaskEditor.this.moduleNameComboBox.getSelectedItem().getObject().toString();
                TaskEditor.this.currentTask.setPlugin(selectedItem.startsWith("p"));
                TaskEditor.this.currentTask.setModuleId(Utils.parseInt(TaskEditor.this.currentTask.isPlugin() ? selectedItem.substring(1) : selectedItem, -1));
                ((ClientContext)TaskEditor.this.getContext()).getPort(SchedulerService.class).updateTask(TaskEditor.this.currentTask);
                TaskEditor.this.setVisible(false);
                TaskEditor.this.parentPanel.performAction("refresh");
            }
        };
        new AbstractBGUPanel.DefaultAction("moduleChange", "\u041c\u043e\u0434\u0443\u043b\u044c \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u0441\u044f"){

            @Override
            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                String moduleId = (String)TaskEditor.this.moduleNameComboBox.getSelectedItem().getObject();
                if (!moduleId.equals("-1")) {
                    ComboBoxItem[] result = ((ClientContext)TaskEditor.this.getContext()).getPort(SchedulerService.class).getAvailableSchedulerTasks(moduleId).stream().map(a -> new ComboBoxItem(a.getFirst(), (String)a.getSecond())).collect(Collectors.toList()).toArray(new ComboBoxItem[0]);
                    TaskEditor.this.taskNameComboBox.setModel(new DefaultComboBoxModel<ComboBoxItem>(result));
                }
            }
        };
    }
}

