/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.wifi;

import java.net.DatagramSocket;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.wifi.WiFiManager;
import ru.bitel.bgbilling.kernel.wifi.common.IpInfo;
import ru.bitel.bgbilling.kernel.wifi.common.WiFiPacket;
import ru.bitel.bgbilling.kernel.wifi.common.WiFiPacketRecord;
import ru.bitel.bgbilling.kernel.wifi.common.WiFiUtil;

public class WiFiThread
extends Thread {
    private static Logger log = LogManager.getLogger();
    private DatagramSocket socket = null;
    private WiFiManager manager = null;
    private byte[] data = null;
    private String host = null;
    private int port = 0;
    private String secret;

    public WiFiThread(WiFiManager manager) {
        this.manager = manager;
    }

    public void init(String host, int port, byte[] data, DatagramSocket socket, String secret) {
        this.host = host;
        this.port = port;
        this.data = data;
        this.socket = socket;
        this.secret = secret;
    }

    @Override
    public void run() {
        try {
            WiFiPacket packet = new WiFiPacket();
            packet.setSecret(this.secret);
            if (!packet.parse(this.data)) {
                throw new RuntimeException("can't parse WiFiPacket ");
            }
            this.proccessPacket(packet, this.host, this.port);
            log.debug("registered ips:");
            for (Map.Entry<Integer, IpInfo> pair : this.manager.getIpHash().entrySet()) {
                log.debug(WiFiUtil.getIp(pair.getKey()));
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proccessPacket(WiFiPacket packetIn, String remoteHost, int remotePort) {
        WiFiThread wiFiThread = this;
        synchronized (wiFiThread) {
            List<WiFiPacketRecord> list = packetIn.getIpList();
            if (list.size() < 1) {
                return;
            }
            if (packetIn.getType() != 1 && packetIn.getType() != 2 && packetIn.getType() != 3) {
                return;
            }
            WiFiPacketRecord record = list.get(0);
            WiFiPacket packetOut = new WiFiPacket();
            packetOut.setType((byte)5);
            packetOut.setSecret(this.secret);
            if (packetIn.getType() == 2 || packetIn.getType() == 1) {
                boolean checkRadius;
                boolean bl = checkRadius = packetIn.getType() == 1;
                if (this.manager.isIpAlive(record.getIp(), checkRadius)) {
                    packetOut.add(record.getIp());
                }
            } else if (packetIn.getType() == 3) {
                this.manager.kill(record.getIp());
                packetOut.add(record.getIp());
            }
            try {
                log.info("send :" + packetOut.print());
                WiFiUtil.sendPacket(this.socket, packetOut, remoteHost, remotePort);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
    }
}

