/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.wifi.dhcp;

import bitel.billing.server.ext.dhcp.DHCPPacket;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.wifi.common.WiFiUtil;
import ru.bitel.bgbilling.kernel.wifi.dhcp.DHCPChecker;
import ru.bitel.bgbilling.kernel.wifi.server.util.ARPUtil;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Pair;

public class RelayThread
extends Thread {
    private byte[] data = null;
    private DatagramSocket socket = null;
    private static Logger log = LogManager.getLogger();
    private byte[] agentHost = null;
    private DHCPChecker checker = null;
    private List<Pair<String, Integer>> hostPorts = new ArrayList<Pair<String, Integer>>();

    public void init(byte[] data, DatagramSocket socket, String agentHost, DHCPChecker checker, List<Pair<String, Integer>> hostPorts) {
        this.data = data;
        this.socket = socket;
        this.agentHost = Utils.convertIntToBytes(WiFiUtil.getIp(agentHost));
        this.checker = checker;
        this.hostPorts = hostPorts;
    }

    @Override
    public void run() {
        log.info("relay agent :  starting RelayThread.... ");
        ByteBuffer bb = ByteBuffer.wrap(this.data);
        log.debug("relay agent :  byte buffer recieved... ");
        DHCPPacket packet = DHCPPacket.getDHCPPacket((ByteBuffer)bb);
        log.debug("relay agent :  DHCP packet parsed... ");
        try {
            byte messageType = packet.messageType;
            log.debug("relay agent : messageType = " + packet.getMessageTypeString());
            if (messageType == 2 || messageType == 5 || messageType == 6) {
                log.debug("relay agent : recieved server answer..Sending it to client");
                if (messageType == 2 || messageType == 5) {
                    String mac = ARPUtil.getMAC(packet.chaddr, packet.hlen);
                    log.debug("relay agent :  mac = " + mac);
                    String ip = WiFiUtil.getIp(packet.yiaddr);
                    log.debug("relay agent :  ip = " + ip);
                    DHCPPacket.DHCPOption option = packet.getOption((byte)51);
                    if (option == null) {
                        log.error("relay agent : can't find lease time option!!! ");
                    }
                    log.debug("relay agent :  option code =  " + option.code);
                    int leaseTime = WiFiUtil.byteToInt(option.value);
                    ARPUtil.addRecord(ip, mac);
                    this.checker.addEntry(ip, mac, leaseTime);
                }
                if (packet.flags < 0) {
                    log.debug("sending brodcast ");
                    this.sendPacket(packet, "255.255.255.255", 68);
                } else {
                    log.debug("sending direct ");
                    this.sendPacket(packet, WiFiUtil.getIp(packet.yiaddr), 68);
                }
            } else {
                log.debug("relay agent : recieved client request..Forwarding it to server ");
                if (packet.hops > 16) {
                    return;
                }
                packet.hops = (byte)(packet.hops + 1);
                log.debug("relay agent : hops checked ");
                IPUtils.convertLongIpToString(Utils.unsignedIntToLong(Utils.convertBytesToInt(packet.giaddr)));
                if (!packet.isFromRelayAgent()) {
                    log.debug("relay agent : agentHost =" + IPUtils.convertLongIpToString(Utils.unsignedIntToLong(Utils.convertBytesToInt(this.agentHost))));
                    packet.giaddr = new byte[4];
                    System.arraycopy(this.agentHost, 0, packet.giaddr, 0, 4);
                    log.debug("relay agent : setting giaddr =" + IPUtils.convertLongIpToString(Utils.unsignedIntToLong(Utils.convertBytesToInt(packet.giaddr))));
                } else {
                    log.debug("request from other relay agent(giaddr already exists");
                }
                for (Pair<String, Integer> pair : this.hostPorts) {
                    this.sendPacket(packet, pair.getFirst(), pair.getSecond());
                }
            }
            log.debug("relay agent : RelayThread - OK ");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("", (Throwable)e);
        }
    }

    private final void sendPacket(DHCPPacket packet, String host, int port) throws IOException {
        byte[] data = packet.serialize();
        InetAddress inetAddr = InetAddress.getByName(host);
        DatagramPacket dataPacket = new DatagramPacket(data, data.length, inetAddr, port);
        log.debug("sending packet to host=" + host + ";port=" + port);
        log.debug("inetAddr=" + inetAddr);
        log.debug("inetAddr.getHostAddress=" + inetAddr.getHostAddress());
        log.debug("inetAddr.getHostName=" + inetAddr.getHostName());
        log.debug("inetAddr.getAddress=" + inetAddr.getAddress());
        this.socket.send(dataPacket);
        log.debug("relay agent : sending packet - OK ");
    }
}

