/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.tree.BGCheckTreeModel;
import ru.bitel.common.client.tree.BGUCheckTree;
import ru.bitel.common.model.Period;
import ru.bitel.oss.systems.inventory.product.client.ProductSpecForm;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecServiceLink;
import ru.bitel.oss.systems.inventory.product.common.service.ProductService;
import ru.bitel.oss.systems.inventory.service.common.bean.ServiceSpec;
import ru.bitel.oss.systems.inventory.service.common.service.ServiceService;

public class ProductSpecServiceLinkPanel
extends BGUPanel {
    private final AtomicReference<ProductSpec> currentRef;
    private BGEditor editor;
    private ProductService productService;
    private Directory<ServiceSpec> serviceSpecDirectory;
    private ProductSpecServiceLinkTableModel model = new ProductSpecServiceLinkTableModel(ProductSpecServiceLinkTableModel.class.getName());
    AbstractBGUPanel.DefaultAction add = new AbstractBGUPanel.DefaultAction("new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c"){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            ProductSpecServiceLinkPanel.this.model.setData(new ArrayList());
        }
    };
    AbstractBGUPanel.DefaultAction edit = new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            ProductSpecServiceLinkPanel.this.model.setData(ProductSpecServiceLinkPanel.this.getProductService().serviceLinkList(ProductSpecServiceLinkPanel.this.currentRef.get().getId(), null));
        }
    };
    AbstractBGUPanel.DefaultAction ok = new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            ProductSpecServiceLinkPanel.this.getProductService().serviceLinkUpdate(ProductSpecServiceLinkPanel.this.currentRef.get().getId(), ProductSpecServiceLinkPanel.this.model.getRows());
        }
    };
    AbstractBGUPanel.DefaultAction remove = new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            ProductSpecServiceLinkPanel.this.getProductService().serviceLinkUpdate(ProductSpecServiceLinkPanel.this.currentRef.get().getId(), new ArrayList());
        }
    };

    public ProductSpecServiceLinkPanel(ProductSpecForm productSpecForm, AtomicReference<ProductSpec> currentRef) throws BGException {
        super(new GridBagLayout());
        this.currentRef = currentRef;
        this.serviceSpecDirectory = ((ClientContext)this.getContext()).getDirectory(ServiceSpec.class, 0);
    }

    @Override
    protected void jbInit() throws Exception {
        this.editor = new BGEditor();
        this.editor.setVisible(false);
        this.editor.addForm(new Editor());
        BGUTable table = new BGUTable(this.model);
        BGDialogToolBar toolBar = new BGDialogToolBar();
        this.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 0), 0, 0));
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        this.add((Component)this.editor, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        BGSwingUtilites.buildToolBar(toolBar, this.editor);
        toolBar.setFloatable(false);
        toolBar.compact();
        BGSwingUtilites.handleEdit(table, this.editor);
    }

    private ProductService getProductService() {
        if (this.productService == null) {
            this.productService = ((ClientContext)this.getContext()).getPort(ProductService.class, 0);
        }
        return this.productService;
    }

    class ProductSpecServiceLinkTableModel
    extends BGTableModel<ProductSpecServiceLink> {
        public ProductSpecServiceLinkTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 200, 200, 200, "period", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0435\u0440\u0432\u0438\u0441", 300, 400, 500, "product", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, 300, -1, "comment", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(ProductSpecServiceLink productSpecServiceLink, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("period".equals(identifier)) {
                return new Period(productSpecServiceLink.getDateFrom(), productSpecServiceLink.getDateTo());
            }
            if ("product".equals(identifier)) {
                try {
                    return ProductSpecServiceLinkPanel.this.serviceSpecDirectory.get(productSpecServiceLink.getServiceSpecId());
                }
                catch (BGException e) {
                    return e.getMessage();
                }
            }
            return super.getValue(productSpecServiceLink, column);
        }
    }

    class Editor
    extends BGUPanel {
        private ProductSpecServiceLink current;
        private BGUCheckTree<ServiceSpec> serviceSpecTree;
        private BGControlPanelPeriod period;
        private JTextArea comment;
        AbstractBGUPanel.DefaultAction add;
        AbstractBGUPanel.DefaultAction edit;
        AbstractBGUPanel.DefaultAction ok;
        AbstractBGUPanel.DefaultAction remove;

        public Editor() {
            super(new GridBagLayout());
            this.add = new AbstractBGUPanel.DefaultAction("new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    Editor.this.current = null;
                    Editor.this.serviceSpecTree.setData(((ClientContext)Editor.this.getContext()).getPort(ServiceService.class, 0).serviceSpecTree(Integer.valueOf(((ClientContext)Editor.this.getContext()).getModuleId()), null, null, null));
                    Editor.this.serviceSpecTree.setChecked(Collections.emptySet());
                    Editor.this.period.setDateCalendar1(null);
                    Editor.this.period.setDateCalendar2(null);
                    Editor.this.comment.setText("");
                    Editor.this.performActionOpen();
                }
            };
            this.edit = new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    Editor.this.current = (ProductSpecServiceLink)ProductSpecServiceLinkPanel.this.model.getSelectedRow();
                    Editor.this.serviceSpecTree.setData(((ClientContext)Editor.this.getContext()).getPort(ServiceService.class, 0).serviceSpecTree(Integer.valueOf(((ClientContext)Editor.this.getContext()).getModuleId()), null, null, null));
                    Editor.this.serviceSpecTree.setChecked(Collections.singleton(Editor.this.current.getServiceSpecId()));
                    Editor.this.period.setDateCalendar1(TimeUtils.convertDateToCalendar(Editor.this.current.getDateFrom()));
                    Editor.this.period.setDateCalendar2(TimeUtils.convertDateToCalendar(Editor.this.current.getDateTo()));
                    Editor.this.comment.setText(Editor.this.current.getComment());
                    Editor.this.performActionOpen();
                }
            };
            this.ok = new AbstractBGUPanel.DefaultAction("ok", "Ok"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    if (Editor.this.current == null) {
                        Editor.this.current = new ProductSpecServiceLink();
                        ProductSpecServiceLinkPanel.this.model.addRow(Editor.this.current);
                    }
                    if (Editor.this.serviceSpecTree.getChecked().size() == 0) {
                        ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0435\u0440\u0432\u0438\u0441!");
                        return;
                    }
                    Editor.this.current.setServiceSpecId(Editor.this.serviceSpecTree.getChecked().iterator().next().intValue());
                    Editor.this.current.setDateFrom(TimeUtils.convertCalendarToDate(Editor.this.period.getDateCalendar1()));
                    Editor.this.current.setDateTo(TimeUtils.convertCalendarToDate(Editor.this.period.getDateCalendar2()));
                    Editor.this.current.setComment(Editor.this.comment.getText());
                    Editor.this.performActionClose();
                    ProductSpecServiceLinkPanel.this.model.fireTableDataChanged();
                }
            };
            this.remove = new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    ProductSpecServiceLinkPanel.this.model.deleteSelectedRows();
                    Editor.this.performActionClose();
                }
            };
            this.build();
        }

        @Override
        protected void jbInit() throws Exception {
            this.serviceSpecTree = new BGUCheckTree<ServiceSpec>(new ServiceTreeModel("ServiceSpec", ServiceSpec.class));
            this.period = new BGControlPanelPeriod();
            this.comment = new JTextArea();
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setMinimumSize(new Dimension(0, 300));
            panel.add((Component)this.period, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(1, 2, 1, 2, 1.0, 1.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
            this.add((Component)new JLabel("\u0421\u0435\u0440\u0432\u0438\u0441:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)new JScrollPane(this.serviceSpecTree), new GridBagConstraints(0, 1, 1, 1, 0.5, 1.0, 17, 1, new Insets(3, 0, 0, 5), 0, 0));
            this.add((Component)panel, new GridBagConstraints(1, 0, 1, 2, 0.5, 1.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
            this.setBorder(BorderFactory.createCompoundBorder(new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
            this.serviceSpecTree.setData(((ClientContext)this.getContext()).getPort(ServiceService.class, 0).serviceSpecTree(Integer.valueOf(((ClientContext)this.getContext()).getModuleId()), null, null, null));
        }
    }

    class ServiceTreeModel
    extends BGCheckTreeModel<ServiceSpec> {
        private final Icon iconRoot;
        private final Icon iconNode;
        private final Icon iconLeaf;

        public ServiceTreeModel(String name, Class<ServiceSpec> clazz) {
            super(name, clazz);
            this.iconRoot = ClientUtils.getIcon("fugue/folder");
            this.iconNode = ClientUtils.getIcon("fugue/folder");
            this.iconLeaf = ClientUtils.getIcon("fugue/cake");
        }

        @Override
        public Icon getIcon(ServiceSpec value) {
            if (value == this.root) {
                return this.iconRoot;
            }
            if (this.isLeaf(value)) {
                return this.iconLeaf;
            }
            return this.iconNode;
        }
    }
}

