/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class BGConfigEditorPane
extends JTextPane
implements KeyListener {
    StyledDocument doc;

    public BGConfigEditorPane() {
        this.setContentType("text/plain");
        this.setDocument(new ConfigStyledDoc());
        this.addKeyListener(this);
    }

    public void append(String str) {
        this.setText(super.getText() + str);
    }

    @Override
    public String getText() {
        return super.getText().replaceAll("\r", "");
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 67 && e.isShiftDown() && e.isControlDown()) {
            this.toggleComment();
        }
    }

    public void toggleComment() {
        int selectionStart = this.getSelectionStart();
        int selectionEnd = this.getSelectionEnd();
        int caretPosition = this.getCaretPosition();
        StringBuilder sb = new StringBuilder(this.getText());
        for (int selstart1 = selectionStart; selstart1 > 0 && sb.charAt(selstart1 - 1) != '\n'; --selstart1) {
        }
        boolean nextIsNew = true;
        ArrayList<Integer> newIndexs = new ArrayList<Integer>();
        for (int index = selstart1; index <= selectionEnd; ++index) {
            if (nextIsNew) {
                newIndexs.add(index);
                nextIsNew = false;
            }
            if (index != sb.length() && sb.charAt(index) != '\n') continue;
            nextIsNew = true;
        }
        boolean thisAllCommented = true;
        for (Integer newIndex : newIndexs) {
            thisAllCommented &= newIndex.intValue() != sb.length() && sb.charAt(newIndex) == '#';
        }
        for (int index = newIndexs.size() - 1; index >= 0; --index) {
            int newIndex = (Integer)newIndexs.get(index);
            if (thisAllCommented) {
                sb.deleteCharAt(newIndex);
                if (caretPosition > newIndex) {
                    --caretPosition;
                }
                if (selectionStart > newIndex) {
                    --selectionStart;
                }
                if (selectionEnd <= newIndex) continue;
                --selectionEnd;
                continue;
            }
            sb.insert(newIndex, '#');
            if (caretPosition >= newIndex) {
                ++caretPosition;
            }
            if (selectionStart >= newIndex) {
                ++selectionStart;
            }
            if (selectionEnd < newIndex) continue;
            ++selectionEnd;
        }
        this.setText(sb.toString());
        this.setCaretPosition(caretPosition);
        this.setSelectionStart(selectionStart);
        this.setSelectionEnd(selectionEnd);
    }

    public static class ConfigStyledDoc
    extends DefaultStyledDocument {
        public ConfigStyledDoc() {
            Style style = this.addStyle("comment", null);
            StyleConstants.setForeground(style, new Color(168, 168, 168));
            StyleConstants.setItalic(style, true);
            StyleConstants.setBold(style, true);
            style = this.addStyle("attr", style);
            StyleConstants.setForeground(style, Color.blue);
            StyleConstants.setBold(style, true);
            style = this.addStyle("value", null);
            StyleConstants.setForeground(style, Color.red);
            StyleConstants.setBold(style, true);
            style = this.addStyle("normal", null);
            StyleConstants.setForeground(style, Color.black);
            style = this.addStyle("var", null);
            StyleConstants.setForeground(style, new Color(32768));
            StyleConstants.setItalic(style, true);
            StyleConstants.setBold(style, true);
            style = this.addStyle("varValue", null);
            StyleConstants.setForeground(style, new Color(32768));
            StyleConstants.setBold(style, true);
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            super.insertString(offset, str, a);
            this.updateView(offset, str.length());
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            super.remove(offs, len);
            this.updateView(offs, 0);
        }

        private void updateView(int offset, int len) {
            try {
                int textLength = this.getLength();
                String text = this.getText(0, textLength);
                int end = offset + len;
                if (offset > 0) {
                    --offset;
                }
                while (offset > 0 && text.charAt(offset) != '\n') {
                    --offset;
                }
                if (offset > 0) {
                    ++offset;
                }
                while (end < textLength && text.charAt(end) != '\n') {
                    ++end;
                }
                text = text.substring(offset, end);
                int pos = 0;
                StringTokenizer st = new StringTokenizer(text, "\n", true);
                while (st.hasMoreTokens()) {
                    int dev_pos;
                    String line = st.nextToken();
                    this.setCharacterAttributes(offset + pos, line.length(), this.getStyle("normal"), true);
                    if (line.startsWith("#")) {
                        this.setCharacterAttributes(offset + pos, line.length(), this.getStyle("comment"), true);
                    } else if (line.startsWith("@")) {
                        dev_pos = line.indexOf("=");
                        if (dev_pos > 0) {
                            this.setCharacterAttributes(offset + pos, dev_pos, this.getStyle("var"), true);
                            this.setCharacterAttributes(offset + pos + dev_pos + 1, line.length() - dev_pos - 1, this.getStyle("value"), true);
                        }
                    } else {
                        dev_pos = line.indexOf("=");
                        if (dev_pos > 0) {
                            this.setCharacterAttributes(offset + pos, dev_pos, this.getStyle("attr"), true);
                            this.setCharacterAttributes(offset + pos + dev_pos + 1, line.length() - dev_pos - 1, this.getStyle("value"), true);
                        }
                    }
                    pos += line.length();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

